/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.rmic;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TabbedWriter
extends FilterWriter {
    private static final String defaultTabstring = "    ";
    private char[] tabstring;
    private int tabs = 0;

    public TabbedWriter(Writer writer) {
        this(writer, defaultTabstring);
    }

    public TabbedWriter(Writer writer, String string) {
        super(writer);
        this.tabstring = string.toCharArray();
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        if (n == 10) {
            for (int i = 0; i < this.tabs; ++i) {
                this.out.write(this.tabstring, 0, this.tabstring.length);
            }
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(cArray[i + n]);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void unindent() throws IOException {
        this.unindent(1);
    }

    public void unindent(int n) throws IOException {
        this.indent(-n);
    }

    public void indent() throws IOException {
        this.indent(1);
    }

    public void indent(int n) throws IOException {
        this.tabs += n;
        if (this.tabs < 0) {
            this.tabs = 0;
        }
        this.write(10);
    }
}

