/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class PolicyNodeImpl
implements PolicyNode {
    private String policy;
    private final Set expectedPolicies = new HashSet();
    private final Set qualifiers = new HashSet();
    private final Set children = new HashSet();
    private PolicyNodeImpl parent;
    private int depth;
    private boolean critical = false;
    private boolean readOnly = false;

    public void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        if (policyNodeImpl.getParent() != null) {
            throw new IllegalStateException("already a child node");
        }
        policyNodeImpl.parent = this;
        policyNodeImpl.setDepth(this.depth + 1);
        this.children.add(policyNodeImpl);
    }

    public Iterator getChildren() {
        return Collections.unmodifiableSet(this.children).iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.depth = n;
    }

    public void addAllExpectedPolicies(Set set) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.addAll(set);
    }

    public void addExpectedPolicy(String string) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.add(string);
    }

    public Set getExpectedPolicies() {
        return Collections.unmodifiableSet(this.expectedPolicies);
    }

    public PolicyNode getParent() {
        return this.parent;
    }

    public void addAllPolicyQualifiers(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof PolicyQualifierInfo) continue;
            throw new IllegalArgumentException("can only add PolicyQualifierInfos");
        }
        collection.addAll(collection);
    }

    public void addPolicyQualifier(PolicyQualifierInfo policyQualifierInfo) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.qualifiers.add(policyQualifierInfo);
    }

    public Set getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public String getValidPolicy() {
        return this.policy;
    }

    public void setValidPolicy(String string) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.policy = string;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean bl) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.critical = bl;
    }

    public void setReadOnly() {
        if (this.readOnly) {
            return;
        }
        this.readOnly = true;
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            ((PolicyNodeImpl)iterator.next()).setReadOnly();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("(");
        stringBuffer.append(PolicyNodeImpl.class$("gnu.java.security.x509.PolicyNodeImpl").getName());
        stringBuffer.append(" (oid ");
        stringBuffer.append(this.policy);
        stringBuffer.append(") (depth ");
        stringBuffer.append(this.depth);
        stringBuffer.append(") (qualifiers ");
        stringBuffer.append(this.qualifiers);
        stringBuffer.append(") (critical ");
        stringBuffer.append(this.critical);
        stringBuffer.append(") (expectedPolicies ");
        stringBuffer.append(this.expectedPolicies);
        stringBuffer.append(") (children (");
        String string = System.getProperty("line.separator");
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append(")))");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

