/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.BaseMode;

public class CBC
extends BaseMode
implements Cloneable {
    private byte[] lastBlock;
    private byte[] scratch;

    CBC(IBlockCipher iBlockCipher, int n) {
        super("cbc", iBlockCipher, n);
    }

    private CBC(CBC cBC) {
        this((IBlockCipher)cBC.cipher.clone(), cBC.cipherBlockSize);
    }

    public Object clone() {
        return new CBC(this);
    }

    public void setup() {
        if (this.modeBlockSize != this.cipherBlockSize) {
            throw new IllegalArgumentException();
        }
        this.scratch = new byte[this.cipherBlockSize];
        this.lastBlock = new byte[this.cipherBlockSize];
        for (int i = 0; i < this.lastBlock.length && i < this.iv.length; ++i) {
            this.lastBlock[i] = this.iv[i];
        }
    }

    public void teardown() {
        this.lastBlock = null;
        this.scratch = null;
    }

    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        for (int i = 0; i < this.scratch.length; ++i) {
            this.scratch[i] = this.lastBlock[i] ^ byArray[i + n];
        }
        this.cipher.encryptBlock(this.scratch, 0, byArray2, n2);
        System.arraycopy(byArray2, n2, this.lastBlock, 0, this.cipherBlockSize);
    }

    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[this.cipherBlockSize];
        System.arraycopy(byArray, n, byArray3, 0, this.cipherBlockSize);
        this.cipher.decryptBlock(byArray, n, this.scratch, 0);
        for (int i = 0; i < this.scratch.length; ++i) {
            byArray2[n2 + i] = this.lastBlock[i] ^ this.scratch[i];
        }
        System.arraycopy(byArray3, 0, this.lastBlock, 0, this.cipherBlockSize);
    }
}

