/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.RawData;
import gnu.gcj.RawDataManaged;
import gnu.java.util.WeakIdentityHashMap;
import java.util.Map;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    ThreadGroup group;
    private Runnable runnable;
    String name;
    private boolean daemon;
    private int priority;
    boolean interrupt_flag;
    private boolean alive_flag;
    private boolean startable_flag;
    private ClassLoader contextClassLoader;
    private final long threadId;
    private static long nextThreadId;
    private static UncaughtExceptionHandler defaultHandler;
    WeakIdentityHashMap locals;
    UncaughtExceptionHandler exceptionHandler;
    Object accessControlState;
    RawData interp_frame;
    private RawDataManaged data;

    private /* synthetic */ void finit$() {
        this.accessControlState = null;
    }

    public Thread() {
        this(null, null, Thread.gen_name());
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.gen_name());
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.gen_name());
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this(Thread.currentThread(), threadGroup, runnable, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this(Thread.currentThread(), threadGroup, runnable, string);
    }

    private Thread(Thread thread, ThreadGroup threadGroup, Runnable runnable, String string) {
        this.finit$();
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        this.group = threadGroup == null ? (thread == null ? ThreadGroup.root : thread.getThreadGroup()) : threadGroup;
        this.data = null;
        this.interrupt_flag = false;
        this.alive_flag = false;
        this.startable_flag = true;
        Class clazz = Thread.class$("java.lang.Thread");
        synchronized (clazz) {
            try {
                this.threadId = nextThreadId++;
            }
            finally {
                Object var6_6 = null;
            }
            if (thread != null) {
                this.group.checkAccess();
                this.daemon = thread.isDaemon();
                int n = this.group.getMaxPriority();
                int n2 = thread.getPriority();
                this.priority = n < n2 ? n : n2;
                this.contextClassLoader = thread.contextClassLoader;
                InheritableThreadLocal.newChildThread(this);
            } else {
                this.daemon = false;
                this.priority = 5;
            }
            this.name = string;
            this.group.addThread(this);
            this.runnable = runnable;
            this.initialize_native();
            return;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static int activeCount() {
        return Thread.currentThread().group.activeCount();
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().group.enumerate(threadArray);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static native boolean holdsLock(Object var0);

    public native void interrupt();

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.interrupt_flag;
    }

    public final synchronized boolean isAlive() {
        return this.alive_flag;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final native void join(long var1, int var3) throws InterruptedException;

    public final native void resume();

    private final native void finish_();

    private boolean isInterrupted(boolean bl) {
        boolean bl2 = this.interrupt_flag;
        if (bl && bl2) {
            this.interrupt_flag = false;
        }
        return bl2;
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public final void setDaemon(boolean bl) {
        if (!this.startable_flag) {
            throw new IllegalThreadStateException();
        }
        this.checkAccess();
        this.daemon = bl;
    }

    public synchronized ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && classLoader != null) {
            for (classLoader = null; classLoader != null && classLoader != this.contextClassLoader; classLoader = classLoader.getParent()) {
            }
            if (classLoader != this.contextClassLoader) {
                securityManager.checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        return this.contextClassLoader;
    }

    public synchronized void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public final void setName(String string) {
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
    }

    public static native void yield();

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    public native void start();

    public final void stop() {
        this.stop(null);
    }

    public final native void stop(Throwable var1);

    public final native void suspend();

    public final native void setPriority(int var1);

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "," + (this.group == null ? "" : this.group.getName()) + "]";
    }

    private final native void initialize_native();

    private static final native String gen_name();

    static Map getThreadLocals() {
        Thread thread = Thread.currentThread();
        WeakIdentityHashMap weakIdentityHashMap = thread.locals;
        if (weakIdentityHashMap == null) {
            weakIdentityHashMap = thread.locals = new WeakIdentityHashMap();
        }
        return weakIdentityHashMap;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
        this.exceptionHandler = uncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.exceptionHandler != null) {
            return this.exceptionHandler;
        }
        return this.group;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultHandler;
    }

    public long getId() {
        return this.threadId;
    }

    public String getState() {
        return "NEW";
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

