/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ThreadInfo {
    private long threadId;
    private String threadName;
    private String threadState;
    private long blockedCount;
    private long blockedTime;
    private String lockName;
    private long lockOwnerId;
    private String lockOwnerName;
    private long waitedCount;
    private long waitedTime;
    private boolean isInNative;
    private boolean isSuspended;
    private StackTraceElement[] trace;
    private static ThreadMXBean bean = null;

    private ThreadInfo(Thread thread, long l, long l2, Object object, Thread thread2, long l3, long l4, boolean bl, boolean bl2, StackTraceElement[] stackTraceElementArray) {
        this(thread.getId(), thread.getName(), thread.getState(), l, l2, object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object)), thread2.getId(), thread2.getName(), l3, l4, bl, bl2, stackTraceElementArray);
    }

    private ThreadInfo(long l, String string, String string2, long l2, long l3, String string3, long l4, String string4, long l5, long l6, boolean bl, boolean bl2, StackTraceElement[] stackTraceElementArray) {
        this.threadId = l;
        this.threadName = string;
        this.threadState = string2;
        this.blockedCount = l2;
        this.blockedTime = l3;
        this.lockName = string3;
        this.lockOwnerId = l4;
        this.lockOwnerName = string4;
        this.waitedCount = l5;
        this.waitedTime = l6;
        this.isInNative = bl;
        this.isSuspended = bl2;
        this.trace = stackTraceElementArray;
    }

    static void checkAttribute(CompositeType compositeType, String string, OpenType openType) throws IllegalArgumentException {
        OpenType openType2 = compositeType.getType(string);
        if (openType2 == null) {
            throw new IllegalArgumentException("Could not find a field named " + string);
        }
        if (!openType2.equals(openType)) {
            throw new IllegalArgumentException("Field " + string + " is not of " + "type " + openType.getClassName());
        }
    }

    public static ThreadInfo from(CompositeData compositeData) {
        CompositeData[] compositeDataArray;
        if (compositeData == null) {
            return null;
        }
        CompositeType compositeType = compositeData.getCompositeType();
        ThreadInfo.checkAttribute(compositeType, "threadId", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "threadName", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "threadState", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "suspended", SimpleType.BOOLEAN);
        ThreadInfo.checkAttribute(compositeType, "inNative", SimpleType.BOOLEAN);
        ThreadInfo.checkAttribute(compositeType, "blockedCount", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "blockedTime", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "waitedCount", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "waitedTime", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "lockName", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "lockOwnerId", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "lockOwnerName", SimpleType.STRING);
        try {
            compositeDataArray = new CompositeType(ThreadInfo.class$("java.lang.StackTraceElement").getName(), "An element of a stack trace", new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"}, new String[]{"Name of the class", "Name of the method", "Name of the source code file", "Line number", "True if this is a native method"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN});
            ThreadInfo.checkAttribute(compositeType, "stackTrace", new ArrayType(1, (OpenType)compositeDataArray));
        }
        catch (OpenDataException openDataException) {
            throw new IllegalStateException("Something went wrong in creating the composite data type for the stack trace element.", openDataException);
        }
        compositeDataArray = (CompositeData[])compositeData.get("stackTrace");
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            stackTraceElementArray[i] = new StackTraceElement((String)compositeDataArray[i].get("className"), (String)compositeDataArray[i].get("methodName"), (String)compositeDataArray[i].get("fileName"), (Integer)compositeDataArray[i].get("lineNumber"));
        }
        return new ThreadInfo((Long)compositeData.get("threadId"), (String)compositeData.get("threadName"), (String)compositeData.get("threadState"), (Long)compositeData.get("blockedCount"), (Long)compositeData.get("blockedTime"), (String)compositeData.get("lockName"), (Long)compositeData.get("lockOwnerId"), (String)compositeData.get("lockOwnerName"), (Long)compositeData.get("waitedCount"), (Long)compositeData.get("waitedTime"), (Boolean)compositeData.get("inNative"), (Boolean)compositeData.get("suspended"), stackTraceElementArray);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        if (bean == null) {
            bean = ManagementFactory.getThreadMXBean();
        }
        if (bean.isThreadContentionMonitoringEnabled()) {
            return this.blockedTime;
        }
        return -1;
    }

    public String getLockName() {
        if (this.threadState.equals("BLOCKED")) {
            return null;
        }
        return this.lockName;
    }

    public long getLockOwnerId() {
        if (this.threadState.equals("BLOCKED")) {
            return -1;
        }
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        if (this.threadState.equals("BLOCKED")) {
            return null;
        }
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.trace;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getThreadState() {
        return this.threadState;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        if (bean == null) {
            bean = ManagementFactory.getThreadMXBean();
        }
        if (bean.isThreadContentionMonitoringEnabled()) {
            return this.waitedTime;
        }
        return -1;
    }

    public boolean isInNative() {
        return this.isInNative;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.threadId + ", name=" + this.threadName + ", state=" + this.threadState + ", blockedCount=" + this.blockedCount + ", waitedCount=" + this.waitedCount + ", isInNative=" + this.isInNative + ", isSuspended=" + this.isSuspended + (this.threadState.equals("BLOCKED") ? ", lockOwnerId=" + this.lockOwnerId + ", lockOwnerName=" + this.lockOwnerName : "") + "]";
    }
}

