/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.DummyKeyPairGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final String KEY_PAIR_GENERATOR = "KeyPairGenerator";
    Provider provider;
    private String algorithm;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
        this.provider = null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return KeyPairGenerator.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return KeyPairGenerator.getInstance(string, provider);
    }

    public static KeyPairGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Object object = null;
        try {
            object = Engine.getInstance(KEY_PAIR_GENERATOR, string, provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        KeyPairGenerator keyPairGenerator = null;
        if (object instanceof KeyPairGenerator) {
            keyPairGenerator = (KeyPairGenerator)object;
            keyPairGenerator.algorithm = string;
        } else if (object instanceof KeyPairGeneratorSpi) {
            keyPairGenerator = new DummyKeyPairGenerator((KeyPairGeneratorSpi)object, string);
        }
        keyPairGenerator.provider = provider;
        return keyPairGenerator;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int n) {
        this.initialize(n, new SecureRandom());
    }

    public void initialize(int n, SecureRandom secureRandom) {
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        super.initialize(algorithmParameterSpec, secureRandom);
    }

    public final KeyPair genKeyPair() {
        try {
            return KeyPairGenerator.getInstance("DSA", "GNU").generateKeyPair();
        }
        catch (Exception exception) {
            System.err.println("genKeyPair failed: " + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public KeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

