/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public abstract class TextAction
extends AbstractAction {
    public TextAction(String string) {
        super(string);
    }

    protected final JTextComponent getTextComponent(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextComponent) {
            return (JTextComponent)actionEvent.getSource();
        }
        return this.getFocusedComponent();
    }

    public static final Action[] augmentList(Action[] actionArray, Action[] actionArray2) {
        int n;
        HashSet hashSet = new HashSet();
        for (n = 0; n < actionArray.length; ++n) {
            hashSet.add(actionArray[n]);
        }
        for (n = 0; n < actionArray2.length; ++n) {
            hashSet.add(actionArray2[n]);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return (Action[])arrayList.toArray(new Action[hashSet.size()]);
    }

    protected final JTextComponent getFocusedComponent() {
        return null;
    }

    static abstract class VerticalMovementAction
    extends TextAction {
        int dir;

        VerticalMovementAction(String string, int n) {
            super(string);
            this.dir = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n;
                    Caret caret = jTextComponent.getCaret();
                    Point point = caret.getMagicCaretPosition();
                    if (point != null) {
                        point.y = jTextComponent.modelToView((int)caret.getDot()).y;
                        n = jTextComponent.viewToModel(point);
                    } else {
                        n = caret.getDot();
                    }
                    n = Utilities.getNextVisualPositionFrom(jTextComponent, jTextComponent.getCaretPosition(), this.dir);
                    if (n > -1) {
                        this.actionPerformedImpl(caret, n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw (InternalError)new InternalError("Illegal offset").initCause(badLocationException);
            }
        }

        protected abstract void actionPerformedImpl(Caret var1, int var2) throws BadLocationException;
    }

    static abstract class HorizontalMovementAction
    extends TextAction {
        int dir;

        HorizontalMovementAction(String string, int n) {
            super(string);
            this.dir = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n = Utilities.getNextVisualPositionFrom(jTextComponent, jTextComponent.getCaretPosition(), this.dir);
                    Caret caret = jTextComponent.getCaret();
                    this.actionPerformedImpl(caret, n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                throw (InternalError)new InternalError("Illegal offset").initCause(badLocationException);
            }
        }

        protected abstract void actionPerformedImpl(Caret var1, int var2) throws BadLocationException;
    }
}

