/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.indicim;

import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

class IndicInputMethodImpl {
    protected char[] KBD_MAP;
    private static final char SUBSTITUTION_BASE = '\uff00';
    protected char[][] SUBSTITUTION_TABLE;
    private static final char INVALID_CHAR = '\uffff';
    private static final char KEY_SIGN_VIRAMA = 'd';
    private static final char KEY_SIGN_NUKTA = ']';
    private static final char ZWJ = '\u200d';
    private static final char ZWNJ = '\u200c';
    private static final char BACKSPACE = '\b';
    protected char[] JOIN_WITH_NUKTA;
    protected char[] NUKTA_FORM;
    private int log2;
    private int power;
    private int extra;
    private static final TextHitInfo ZERO_TRAILING_HIT_INFO = TextHitInfo.trailing(0);
    private char[] text = new char[4];
    private int committedChars = 0;
    private int totalChars = 0;
    private boolean lastCharWasVirama = false;
    private InputMethodContext context;

    private int nuktaIndex(char c) {
        if (this.JOIN_WITH_NUKTA == null) {
            return -1;
        }
        int n = this.power;
        int n2 = 0;
        if (this.JOIN_WITH_NUKTA[this.extra] <= c) {
            n2 = this.extra;
        }
        while (n > 1) {
            if (this.JOIN_WITH_NUKTA[n2 + (n >>= 1)] > c) continue;
            n2 += n;
        }
        if (this.JOIN_WITH_NUKTA[n2] != c) {
            n2 = -1;
        }
        return n2;
    }

    private char getMappedChar(char c) {
        if (c <= this.KBD_MAP.length) {
            return this.KBD_MAP[c];
        }
        return c;
    }

    private static byte highBit(int n) {
        if (n <= 0) {
            return -32;
        }
        byte by = 0;
        if (n >= 65536) {
            n >>= 16;
            by = (byte)(by + 16);
        }
        if (n >= 256) {
            n >>= 8;
            by = (byte)(by + 8);
        }
        if (n >= 16) {
            n >>= 4;
            by = (byte)(by + 4);
        }
        if (n >= 4) {
            n >>= 2;
            by = (byte)(by + 2);
        }
        if (n >= 2) {
            n >>= 1;
            by = (byte)(by + 1);
        }
        return by;
    }

    IndicInputMethodImpl(char[] cArray, char[] cArray2, char[] cArray3, char[][] cArray4) {
        this.KBD_MAP = cArray;
        this.JOIN_WITH_NUKTA = cArray2;
        this.NUKTA_FORM = cArray3;
        this.SUBSTITUTION_TABLE = cArray4;
        if (this.JOIN_WITH_NUKTA != null) {
            byte by = IndicInputMethodImpl.highBit(this.JOIN_WITH_NUKTA.length);
            this.power = 1 << by;
            this.extra = this.JOIN_WITH_NUKTA.length - this.power;
        } else {
            this.extra = 0;
            this.power = 0;
        }
    }

    void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.context = inputMethodContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleKeyTyped(KeyEvent keyEvent) {
        int n;
        char c = keyEvent.getKeyChar();
        char c2 = this.getMappedChar(c);
        if (this.lastCharWasVirama) {
            switch (c) {
                case ']': {
                    c2 = '\u200d';
                    break;
                }
                case 'd': {
                    c2 = '\u200c';
                    break;
                }
            }
        }
        if (c2 == '\uffff') {
            keyEvent.consume();
            return;
        }
        if (c2 == '\b') {
            this.lastCharWasVirama = false;
            if (this.totalChars <= 0) return;
            this.committedChars = 0;
            this.totalChars = 0;
        } else if (c == ']') {
            n = this.nuktaIndex(this.text[0]);
            if (n != -1) {
                this.text[0] = this.NUKTA_FORM[n];
            } else {
                this.text[this.totalChars++] = c2;
            }
            ++this.committedChars;
        } else {
            n = this.nuktaIndex(c2);
            if (n != -1) {
                this.text[this.totalChars++] = c2;
                this.committedChars = this.totalChars - 1;
            } else {
                if (c2 >= '\uff00') {
                    char[] cArray = this.SUBSTITUTION_TABLE[c2 - 65280];
                    System.arraycopy(cArray, 0, this.text, this.totalChars, cArray.length);
                    this.totalChars += cArray.length;
                } else {
                    this.text[this.totalChars++] = c2;
                }
                this.committedChars = this.totalChars;
            }
        }
        ACIText aCIText = new ACIText(this.text, 0, this.totalChars, this.committedChars);
        int n2 = this.totalChars - this.committedChars;
        TextHitInfo textHitInfo = null;
        TextHitInfo textHitInfo2 = null;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                textHitInfo2 = textHitInfo = ZERO_TRAILING_HIT_INFO;
                break;
            }
            default: {
                assert (false) : "The code should not reach here. There is no case where there can be more than one character pending.";
                break;
            }
        }
        this.context.dispatchInputMethodEvent(1100, aCIText, this.committedChars, textHitInfo, textHitInfo2);
        this.text[0] = this.totalChars == 0 ? 65535 : this.text[this.totalChars - 1];
        this.lastCharWasVirama = c == 'd' && !this.lastCharWasVirama;
        this.totalChars -= this.committedChars;
        this.committedChars = 0;
        keyEvent.consume();
    }

    void endComposition() {
        if (this.totalChars != 0) {
            ACIText aCIText = new ACIText(this.text, 0, this.totalChars, this.totalChars);
            this.context.dispatchInputMethodEvent(1100, aCIText, this.totalChars, null, null);
            this.committedChars = 0;
            this.totalChars = 0;
            this.text[0] = 65535;
            this.lastCharWasVirama = false;
        }
    }

    private class ACIText
    implements AttributedCharacterIterator {
        private char[] text = null;
        private int committed = 0;
        private int index = 0;

        ACIText(char[] cArray, int n, int n2, int n3) {
            this.text = new char[n2];
            this.committed = n3;
            System.arraycopy(cArray, n, this.text, 0, n2);
        }

        @Override
        public char first() {
            return this._setIndex(0);
        }

        @Override
        public char last() {
            if (this.text.length == 0) {
                return this._setIndex(this.text.length);
            }
            return this._setIndex(this.text.length - 1);
        }

        @Override
        public char current() {
            if (this.index == this.text.length) {
                return '\uffff';
            }
            return this.text[this.index];
        }

        @Override
        public char next() {
            if (this.index == this.text.length) {
                return '\uffff';
            }
            return this._setIndex(this.index + 1);
        }

        @Override
        public char previous() {
            if (this.index == 0) {
                return '\uffff';
            }
            return this._setIndex(this.index - 1);
        }

        @Override
        public char setIndex(int n) {
            if (n < 0 || n > this.text.length) {
                throw new IllegalArgumentException();
            }
            return this._setIndex(n);
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.text.length;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object clone() {
            try {
                ACIText aCIText = (ACIText)super.clone();
                return aCIText;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        @Override
        public int getRunStart() {
            return this.index >= this.committed ? this.committed : 0;
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return this.index >= this.committed && attribute == TextAttribute.INPUT_METHOD_UNDERLINE ? this.committed : 0;
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
            return this.index >= this.committed && set.contains(TextAttribute.INPUT_METHOD_UNDERLINE) ? this.committed : 0;
        }

        @Override
        public int getRunLimit() {
            return this.index < this.committed ? this.committed : this.text.length;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return this.index < this.committed && attribute == TextAttribute.INPUT_METHOD_UNDERLINE ? this.committed : this.text.length;
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
            return this.index < this.committed && set.contains(TextAttribute.INPUT_METHOD_UNDERLINE) ? this.committed : this.text.length;
        }

        public Map getAttributes() {
            Hashtable<TextAttribute, Integer> hashtable = new Hashtable<TextAttribute, Integer>();
            if (this.index >= this.committed && this.committed < this.text.length) {
                hashtable.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            return hashtable;
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            if (this.index >= this.committed && this.committed < this.text.length && attribute == TextAttribute.INPUT_METHOD_UNDERLINE) {
                return TextAttribute.UNDERLINE_LOW_ONE_PIXEL;
            }
            return null;
        }

        public Set getAllAttributeKeys() {
            HashSet<TextAttribute> hashSet = new HashSet<TextAttribute>();
            if (this.committed < this.text.length) {
                hashSet.add(TextAttribute.INPUT_METHOD_UNDERLINE);
            }
            return hashSet;
        }

        private char _setIndex(int n) {
            this.index = n;
            if (n == this.text.length) {
                return '\uffff';
            }
            return this.text[n];
        }
    }
}

