/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.UnpackerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

class Utils {
    static final String COM_PREFIX = "com.sun.java.util.jar.pack.";
    static final String METAINF = "META-INF";
    static final String DEBUG_VERBOSE = "com.sun.java.util.jar.pack.verbose";
    static final String DEBUG_DISABLE_NATIVE = "com.sun.java.util.jar.pack.disable.native";
    static final String PACK_DEFAULT_TIMEZONE = "com.sun.java.util.jar.pack.default.timezone";
    static final String UNPACK_MODIFICATION_TIME = "com.sun.java.util.jar.pack.unpack.modification.time";
    static final String UNPACK_STRIP_DEBUG = "com.sun.java.util.jar.pack.unpack.strip.debug";
    static final String UNPACK_REMOVE_PACKFILE = "com.sun.java.util.jar.pack.unpack.remove.packfile";
    static final String NOW = "now";
    static final String PACK_KEEP_CLASS_ORDER = "com.sun.java.util.jar.pack.keep.class.order";
    static final String PACK_ZIP_ARCHIVE_MARKER_COMMENT = "PACK200";
    static final ThreadLocal currentInstance = new ThreadLocal();
    static final boolean nolog = Boolean.getBoolean("com.sun.java.util.jar.pack.nolog");
    static final Logger log = new Logger("java.util.jar.Pack200", null){

        @Override
        public void log(LogRecord logRecord) {
            int n = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (n > 0) {
                if (nolog && logRecord.getLevel().intValue() < Level.WARNING.intValue()) {
                    System.out.println(logRecord.getMessage());
                } else {
                    super.log(logRecord);
                }
            }
        }

        @Override
        public void fine(String string) {
            int n = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (n > 0) {
                System.out.println(string);
            }
        }
    };

    static PropMap currentPropMap() {
        Object t = currentInstance.get();
        if (t instanceof PackerImpl) {
            return ((PackerImpl)t)._props;
        }
        if (t instanceof UnpackerImpl) {
            return ((UnpackerImpl)t)._props;
        }
        return null;
    }

    static String getVersionString() {
        return "Pack200, Vendor: Sun Microsystems, Version: 160.1";
    }

    static void markJarFile(JarOutputStream jarOutputStream) throws IOException {
        jarOutputStream.setComment(PACK_ZIP_ARCHIVE_MARKER_COMMENT);
    }

    static void copyJarFile(JarInputStream jarInputStream, JarOutputStream jarOutputStream) throws IOException {
        JarEntry jarEntry;
        Object object;
        if (jarInputStream.getManifest() != null) {
            object = new ZipEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry((ZipEntry)object);
            jarInputStream.getManifest().write(jarOutputStream);
            jarOutputStream.closeEntry();
        }
        object = new byte[16384];
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            int n;
            jarOutputStream.putNextEntry(jarEntry);
            while (0 < (n = jarInputStream.read((byte[])object))) {
                jarOutputStream.write((byte[])object, 0, n);
            }
        }
        jarInputStream.close();
        Utils.markJarFile(jarOutputStream);
    }

    static void copyJarFile(JarFile jarFile, JarOutputStream jarOutputStream) throws IOException {
        byte[] byArray = new byte[16384];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            JarEntry jarEntry = enumeration.nextElement();
            jarOutputStream.putNextEntry(jarEntry);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            while (0 < (n = inputStream.read(byArray))) {
                jarOutputStream.write(byArray, 0, n);
            }
        }
        jarFile.close();
        Utils.markJarFile(jarOutputStream);
    }

    static void copyJarFile(JarInputStream jarInputStream, OutputStream outputStream) throws IOException {
        outputStream = new BufferedOutputStream(outputStream);
        outputStream = new NonCloser(outputStream);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        Utils.copyJarFile(jarInputStream, jarOutputStream);
        jarOutputStream.close();
    }

    static void copyJarFile(JarFile jarFile, OutputStream outputStream) throws IOException {
        outputStream = new BufferedOutputStream(outputStream);
        outputStream = new NonCloser(outputStream);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        Utils.copyJarFile(jarFile, jarOutputStream);
        jarOutputStream.close();
    }

    static String getJarEntryName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace(File.separatorChar, '/');
    }

    static String zeString(ZipEntry zipEntry) {
        int n = zipEntry.getCompressedSize() > 0L ? (int)((1.0 - (double)zipEntry.getCompressedSize() / (double)zipEntry.getSize()) * 100.0) : 0;
        return zipEntry.getSize() + "\t" + zipEntry.getMethod() + "\t" + zipEntry.getCompressedSize() + "\t" + n + "%\t" + new Date(zipEntry.getTime()) + "\t" + Long.toHexString(zipEntry.getCrc()) + "\t" + zipEntry.getName();
    }

    static byte[] readMagic(BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.mark(4);
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length && 1 == bufferedInputStream.read(byArray, i, 1); ++i) {
        }
        bufferedInputStream.reset();
        return byArray;
    }

    static boolean isJarMagic(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 75 && byArray[2] >= 1 && byArray[2] < 8 && byArray[3] == byArray[2] + 1;
    }

    static boolean isPackMagic(byte[] byArray) {
        return byArray[0] == -54 && byArray[1] == -2 && byArray[2] == -48 && byArray[3] == 13;
    }

    static boolean isGZIPMagic(byte[] byArray) {
        return byArray[0] == 31 && byArray[1] == -117 && byArray[2] == 8;
    }

    private Utils() {
    }

    static {
        LogManager.getLogManager().addLogger(log);
    }

    private static class NonCloser
    extends FilterOutputStream {
        NonCloser(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

