/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

public class Util {
    private static final int NAMESPACE_SEPARATOR_LENGTH = "//".length();
    public static final char[] ILLEGAL_MBEANSERVER_NAME_CHARS = ";:*?".toCharArray();

    static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    static <K, V> Map<K, V> newSynchronizedMap() {
        return Collections.synchronizedMap(Util.newMap());
    }

    static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    static <K, V> Map<K, V> newSynchronizedIdentityHashMap() {
        IdentityHashMap<K, V> identityHashMap = Util.newIdentityHashMap();
        return Collections.synchronizedMap(identityHashMap);
    }

    static <K, V> SortedMap<K, V> newSortedMap() {
        return new TreeMap();
    }

    static <K, V> SortedMap<K, V> newSortedMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    static <K, V> Map<K, V> newInsertionOrderMap() {
        return new LinkedHashMap();
    }

    static <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    static <E> Set<E> newSet() {
        return new HashSet();
    }

    static <E> Set<E> newSet(Collection<E> collection) {
        return new HashSet<E>(collection);
    }

    static <E> List<E> newList() {
        return new ArrayList();
    }

    static <E> List<E> newList(Collection<E> collection) {
        return new ArrayList<E>(collection);
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static int hashCode(String[] stringArray, Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = objectArray[i];
            int n2 = object == null ? 0 : (object instanceof Object[] ? Arrays.deepHashCode((Object[])object) : (object.getClass().isArray() ? Arrays.deepHashCode(new Object[]{object}) - 31 : object.hashCode()));
            n += stringArray[i].toLowerCase().hashCode() ^ n2;
        }
        return n;
    }

    private static boolean wildmatch(String string, String string2, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = -1;
        block4: while (true) {
            if (n3 < n4) {
                char c = string2.charAt(n3);
                switch (c) {
                    case '?': {
                        if (n == n2) break;
                        ++n;
                        ++n3;
                        continue block4;
                    }
                    case '*': {
                        n5 = ++n3;
                        n6 = n;
                        continue block4;
                    }
                    default: {
                        if (n < n2 && string.charAt(n) == c) {
                            ++n;
                            ++n3;
                            continue block4;
                        } else {
                            break;
                        }
                    }
                }
            } else if (n == n2) {
                return true;
            }
            if (n5 < 0 || n6 == n2) {
                return false;
            }
            n3 = n5;
            n = ++n6;
        }
    }

    public static boolean wildmatch(String string, String string2) {
        return Util.wildmatch(string, string2, 0, string.length(), 0, string2.length());
    }

    public static boolean wildpathmatch(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        while (true) {
            int n7;
            int n8 = string.indexOf("//", n3);
            int n9 = string2.indexOf("//", n4);
            if (n8 == -1 && n9 == -1) {
                return Util.wildmatch(string, string2, n3, n, n4, n2);
            }
            if (n8 == -1) {
                return false;
            }
            if (n9 == n4 + 2 && string2.charAt(n4) == '*' && string2.charAt(n4 + 1) == '*') {
                n3 = n8 + NAMESPACE_SEPARATOR_LENGTH;
                n5 = n4 = n9 + NAMESPACE_SEPARATOR_LENGTH;
                n6 = n3;
                continue;
            }
            int n10 = n9 > -1 ? n9 + NAMESPACE_SEPARATOR_LENGTH : n2;
            int n11 = n7 = n8 > -1 ? n8 + NAMESPACE_SEPARATOR_LENGTH : n;
            if (!Util.wildmatch(string, string2, n3, n7, n4, n10)) {
                if (n5 < 0) {
                    return false;
                }
                n3 = string.indexOf("//", n6);
                if (n3 == -1) {
                    return false;
                }
                n6 = n3 += NAMESPACE_SEPARATOR_LENGTH;
                n4 = n5;
                continue;
            }
            if (n9 == -1 && n5 == -1) {
                return n8 + NAMESPACE_SEPARATOR_LENGTH == n;
            }
            n3 = n8 + NAMESPACE_SEPARATOR_LENGTH;
            n4 = n9 == -1 ? n4 : n9 + NAMESPACE_SEPARATOR_LENGTH;
        }
    }

    public static boolean isDomainSelected(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("null");
        }
        return Util.wildpathmatch(string, string2);
    }

    public static Set<ObjectName> filterMatchingNames(ObjectName objectName, Set<ObjectName> set) {
        if (objectName == null || set.isEmpty() || ObjectName.WILDCARD.equals(objectName)) {
            return set;
        }
        Set<ObjectName> set2 = Util.equivalentEmptySet(set);
        for (ObjectName objectName2 : set) {
            if (!objectName.apply(objectName2)) continue;
            set2.add(objectName2);
        }
        return set2;
    }

    public static Set<ObjectInstance> filterMatchingInstances(ObjectName objectName, Set<ObjectInstance> set) {
        if (objectName == null || set.isEmpty() || ObjectName.WILDCARD.equals(objectName)) {
            return set;
        }
        Set<ObjectInstance> set2 = Util.equivalentEmptySet(set);
        for (ObjectInstance objectInstance : set) {
            if (objectInstance == null || !objectName.apply(objectInstance.getObjectName())) continue;
            set2.add(objectInstance);
        }
        return set2;
    }

    public static ClassLoaderRepository getSingleClassLoaderRepository(ClassLoader classLoader) {
        return new SingleClassLoaderRepository(classLoader);
    }

    public static String getMBeanServerSecurityName(MBeanServer mBeanServer) {
        try {
            String string = (String)mBeanServer.getAttribute(MBeanServerDelegate.DELEGATE_NAME, "MBeanServerId");
            String string2 = Util.extractMBeanServerName(string);
            if (string2.length() == 0) {
                return "default";
            }
            return string2;
        }
        catch (Exception exception) {
            Util.logshort("Failed to retrieve MBeanServerName for server, using \"*\"", exception);
            return "*";
        }
    }

    public static String extractMBeanServerName(String string) {
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.indexOf(";mbeanServerName=");
        if (n2 < 0) {
            return "";
        }
        int n3 = string.indexOf(";", n = n2 + ";mbeanServerName=".length());
        return string.substring(n, n3 < 0 ? string.length() : n3);
    }

    public static String insertMBeanServerName(String string, String string2) {
        String string3 = Util.extractMBeanServerName(string);
        if (string3.length() > 0 && string3.equals(Util.checkServerName(string2))) {
            return string;
        }
        if (string3.length() > 0 && !Util.isMBeanServerNameUndefined(string3)) {
            throw new IllegalArgumentException("MBeanServerName already defined");
        }
        if (Util.isMBeanServerNameUndefined(string2)) {
            return string;
        }
        return string + ";mbeanServerName=" + Util.checkServerName(string2);
    }

    public static boolean isMBeanServerNameUndefined(String string) {
        return string == null || "default".equals(string);
    }

    public static String checkServerName(String string) {
        if ("".equals(string)) {
            throw new IllegalArgumentException("\"\" is not a valid MBean server name");
        }
        if ("-".equals(string)) {
            throw new IllegalArgumentException("\"-\" is not a valid MBean server name");
        }
        if (Util.isMBeanServerNameUndefined(string)) {
            return "default";
        }
        for (char c : ILLEGAL_MBEANSERVER_NAME_CHARS) {
            if (string.indexOf(c) < 0) continue;
            throw new IllegalArgumentException("invalid character in MBeanServer name: " + c);
        }
        return string;
    }

    public static String getMBeanServerSecurityName(MBeanServerDelegate mBeanServerDelegate) {
        try {
            String string = mBeanServerDelegate.getMBeanServerName();
            if (Util.isMBeanServerNameUndefined(string)) {
                return "default";
            }
            return string;
        }
        catch (Exception exception) {
            Util.logshort("Failed to retrieve MBeanServerName from delegate, using \"*\"", exception);
            return "*";
        }
    }

    private static void logshort(String string, Throwable throwable) {
        if (JmxProperties.MISC_LOGGER.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.append("\nCaused By: ").append(String.valueOf(throwable));
            } while ((throwable = throwable.getCause()) != null);
            JmxProperties.MISC_LOGGER.fine(stringBuilder.toString());
        }
    }

    public static <T> Set<T> cloneSet(Set<T> set) {
        if (set instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)set;
            set = new TreeSet<T>(sortedSet.comparator());
            set.addAll(sortedSet);
        } else {
            set = new HashSet<T>(set);
        }
        return set;
    }

    public static <T> Set<T> equivalentEmptySet(Set<T> set) {
        if (set instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)set;
            set = new TreeSet<T>(sortedSet.comparator());
        } else {
            set = new HashSet<T>();
        }
        return set;
    }

    public static RuntimeException newRuntimeIOException(IOException iOException) {
        String string = "Communication failed with underlying resource: " + iOException.getMessage();
        return new RuntimeException(string, iOException);
    }

    private static final class SingleClassLoaderRepository
    implements ClassLoaderRepository {
        private final ClassLoader singleLoader;

        SingleClassLoaderRepository(ClassLoader classLoader) {
            this.singleLoader = classLoader;
        }

        ClassLoader getSingleClassLoader() {
            return this.singleLoader;
        }

        private Class<?> loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
            return Class.forName(string, false, classLoader);
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            return this.loadClass(string, this.getSingleClassLoader());
        }

        @Override
        public Class<?> loadClassWithout(ClassLoader classLoader, String string) throws ClassNotFoundException {
            ClassLoader classLoader2 = this.getSingleClassLoader();
            if (classLoader != null && classLoader.equals(classLoader2)) {
                throw new ClassNotFoundException(string);
            }
            return this.loadClass(string, classLoader2);
        }

        @Override
        public Class<?> loadClassBefore(ClassLoader classLoader, String string) throws ClassNotFoundException {
            return this.loadClassWithout(classLoader, string);
        }
    }
}

