/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelOscillatorStream;
import com.sun.media.sound.ModelWavetable;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class ModelByteBufferWavetable
implements ModelWavetable {
    private float loopStart = -1.0f;
    private float loopLength = -1.0f;
    private ModelByteBuffer buffer;
    private ModelByteBuffer buffer8 = null;
    private AudioFormat format = null;
    private float pitchcorrection = 0.0f;
    private float attenuation = 0.0f;
    private int loopType = 0;

    public ModelByteBufferWavetable(ModelByteBuffer modelByteBuffer) {
        this.buffer = modelByteBuffer;
    }

    public ModelByteBufferWavetable(ModelByteBuffer modelByteBuffer, float f) {
        this.buffer = modelByteBuffer;
        this.pitchcorrection = f;
    }

    public ModelByteBufferWavetable(ModelByteBuffer modelByteBuffer, AudioFormat audioFormat) {
        this.format = audioFormat;
        this.buffer = modelByteBuffer;
    }

    public ModelByteBufferWavetable(ModelByteBuffer modelByteBuffer, AudioFormat audioFormat, float f) {
        this.format = audioFormat;
        this.buffer = modelByteBuffer;
        this.pitchcorrection = f;
    }

    public void set8BitExtensionBuffer(ModelByteBuffer modelByteBuffer) {
        this.buffer8 = modelByteBuffer;
    }

    public ModelByteBuffer get8BitExtensionBuffer() {
        return this.buffer8;
    }

    public ModelByteBuffer getBuffer() {
        return this.buffer;
    }

    public AudioFormat getFormat() {
        if (this.format == null) {
            if (this.buffer == null) {
                return null;
            }
            InputStream inputStream = this.buffer.getInputStream();
            AudioFormat audioFormat = null;
            try {
                audioFormat = AudioSystem.getAudioFileFormat(inputStream).getFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return audioFormat;
        }
        return this.format;
    }

    @Override
    public AudioFloatInputStream openStream() {
        if (this.buffer == null) {
            return null;
        }
        if (this.format == null) {
            InputStream inputStream = this.buffer.getInputStream();
            AudioInputStream audioInputStream = null;
            try {
                audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            }
            catch (Exception exception) {
                return null;
            }
            return AudioFloatInputStream.getInputStream(audioInputStream);
        }
        if (this.buffer.array() == null) {
            return AudioFloatInputStream.getInputStream(new AudioInputStream(this.buffer.getInputStream(), this.format, this.buffer.capacity()));
        }
        if (this.buffer8 != null && (this.format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || this.format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED))) {
            Buffer8PlusInputStream buffer8PlusInputStream = new Buffer8PlusInputStream();
            AudioFormat audioFormat = new AudioFormat(this.format.getEncoding(), this.format.getSampleRate(), this.format.getSampleSizeInBits() + 8, this.format.getChannels(), this.format.getFrameSize() + 1 * this.format.getChannels(), this.format.getFrameRate(), this.format.isBigEndian());
            AudioInputStream audioInputStream = new AudioInputStream(buffer8PlusInputStream, audioFormat, this.buffer.capacity() / (long)this.format.getFrameSize());
            return AudioFloatInputStream.getInputStream(audioInputStream);
        }
        return AudioFloatInputStream.getInputStream(this.format, this.buffer.array(), (int)this.buffer.arrayOffset(), (int)this.buffer.capacity());
    }

    @Override
    public int getChannels() {
        return this.getFormat().getChannels();
    }

    @Override
    public ModelOscillatorStream open(float f) {
        return null;
    }

    @Override
    public float getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(float f) {
        this.attenuation = f;
    }

    @Override
    public float getLoopLength() {
        return this.loopLength;
    }

    public void setLoopLength(float f) {
        this.loopLength = f;
    }

    @Override
    public float getLoopStart() {
        return this.loopStart;
    }

    public void setLoopStart(float f) {
        this.loopStart = f;
    }

    public void setLoopType(int n) {
        this.loopType = n;
    }

    @Override
    public int getLoopType() {
        return this.loopType;
    }

    @Override
    public float getPitchcorrection() {
        return this.pitchcorrection;
    }

    public void setPitchcorrection(float f) {
        this.pitchcorrection = f;
    }

    private class Buffer8PlusInputStream
    extends InputStream {
        private boolean bigendian;
        private int framesize_pc;
        int pos = 0;
        int pos2 = 0;
        int markpos = 0;
        int markpos2 = 0;

        public Buffer8PlusInputStream() {
            this.framesize_pc = ModelByteBufferWavetable.this.format.getFrameSize() / ModelByteBufferWavetable.this.format.getChannels();
            this.bigendian = ModelByteBufferWavetable.this.format.isBigEndian();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.available();
            if (n3 <= 0) {
                return -1;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            byte[] byArray2 = ModelByteBufferWavetable.this.buffer.array();
            byte[] byArray3 = ModelByteBufferWavetable.this.buffer8.array();
            this.pos = (int)((long)this.pos + ModelByteBufferWavetable.this.buffer.arrayOffset());
            this.pos2 = (int)((long)this.pos2 + ModelByteBufferWavetable.this.buffer8.arrayOffset());
            if (this.bigendian) {
                for (int i = 0; i < n2; i += this.framesize_pc + 1) {
                    System.arraycopy(byArray2, this.pos, byArray, i, this.framesize_pc);
                    System.arraycopy(byArray3, this.pos2, byArray, i + this.framesize_pc, 1);
                    this.pos += this.framesize_pc;
                    ++this.pos2;
                }
            } else {
                for (int i = 0; i < n2; i += this.framesize_pc + 1) {
                    System.arraycopy(byArray3, this.pos2, byArray, i, 1);
                    System.arraycopy(byArray2, this.pos, byArray, i + 1, this.framesize_pc);
                    this.pos += this.framesize_pc;
                    ++this.pos2;
                }
            }
            this.pos = (int)((long)this.pos - ModelByteBufferWavetable.this.buffer.arrayOffset());
            this.pos2 = (int)((long)this.pos2 - ModelByteBufferWavetable.this.buffer8.arrayOffset());
            return n2;
        }

        @Override
        public long skip(long l) throws IOException {
            int n = this.available();
            if (n <= 0) {
                return -1L;
            }
            if (l > (long)n) {
                l = n;
            }
            this.pos = (int)((long)this.pos + l / (long)(this.framesize_pc + 1) * (long)this.framesize_pc);
            this.pos2 = (int)((long)this.pos2 + l / (long)(this.framesize_pc + 1));
            return super.skip(l);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == -1) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int available() throws IOException {
            return (int)ModelByteBufferWavetable.this.buffer.capacity() + (int)ModelByteBufferWavetable.this.buffer8.capacity() - this.pos - this.pos2;
        }

        @Override
        public synchronized void mark(int n) {
            this.markpos = this.pos;
            this.markpos2 = this.pos2;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.pos = this.markpos;
            this.pos2 = this.markpos2;
        }
    }
}

