/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import com.sun.media.sound.SoftChannel;
import com.sun.media.sound.SoftChorus;
import com.sun.media.sound.SoftControl;
import com.sun.media.sound.SoftLimiter;
import com.sun.media.sound.SoftReverb;
import com.sun.media.sound.SoftSynthesizer;
import com.sun.media.sound.SoftTuning;
import com.sun.media.sound.SoftVoice;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.AudioInputStream;

public class SoftMainMixer {
    public static final int CHANNEL_LEFT = 0;
    public static final int CHANNEL_RIGHT = 1;
    public static final int CHANNEL_MONO = 2;
    public static final int CHANNEL_EFFECT1 = 3;
    public static final int CHANNEL_EFFECT2 = 4;
    public static final int CHANNEL_EFFECT3 = 5;
    public static final int CHANNEL_EFFECT4 = 6;
    public static final int CHANNEL_LEFT_DRY = 10;
    public static final int CHANNEL_RIGHT_DRY = 11;
    public static final int CHANNEL_SCRATCH1 = 12;
    public static final int CHANNEL_SCRATCH2 = 13;
    public static final int CHANNEL_CHANNELMIXER_LEFT = 14;
    public static final int CHANNEL_CHANNELMIXER_RIGHT = 15;
    public static final int CHANNEL_CHANNELMIXER_MONO = 16;
    protected boolean active_sensing_on = false;
    private long msec_last_activity = -1L;
    private boolean pusher_silent = false;
    private int pusher_silent_count = 0;
    private long msec_pos = 0L;
    protected boolean readfully = true;
    private Object control_mutex;
    private SoftSynthesizer synth;
    private int nrofchannels = 2;
    private SoftVoice[] voicestatus = null;
    private SoftAudioBuffer[] buffers;
    private SoftReverb reverb;
    private SoftAudioProcessor chorus;
    private SoftAudioProcessor agc;
    private long msec_buffer_len = 0L;
    protected TreeMap<Long, Object> midimessages = new TreeMap();
    double last_volume_left = 1.0;
    double last_volume_right = 1.0;
    private double[] co_master_balance = new double[1];
    private double[] co_master_volume = new double[1];
    private double[] co_master_coarse_tuning = new double[1];
    private double[] co_master_fine_tuning = new double[1];
    private AudioInputStream ais;
    private Set<ModelChannelMixer> registeredMixers = null;
    private Set<ModelChannelMixer> stoppedMixers = null;
    private ModelChannelMixer[] cur_registeredMixers = null;
    protected SoftControl co_master = new SoftControl(){
        double[] balance;
        double[] volume;
        double[] coarse_tuning;
        double[] fine_tuning;
        {
            this.balance = SoftMainMixer.this.co_master_balance;
            this.volume = SoftMainMixer.this.co_master_volume;
            this.coarse_tuning = SoftMainMixer.this.co_master_coarse_tuning;
            this.fine_tuning = SoftMainMixer.this.co_master_fine_tuning;
        }

        @Override
        public double[] get(int n, String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("balance")) {
                return this.balance;
            }
            if (string.equals("volume")) {
                return this.volume;
            }
            if (string.equals("coarse_tuning")) {
                return this.coarse_tuning;
            }
            if (string.equals("fine_tuning")) {
                return this.fine_tuning;
            }
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSystemExclusiveMessage(byte[] byArray) {
        Object object = this.synth.control_mutex;
        synchronized (object) {
            int n;
            SoftChannel[] softChannelArray;
            int n2;
            Object object2;
            int n3;
            int n4;
            int n5;
            this.activity();
            if ((byArray[1] & 0xFF) == 126 && ((n5 = byArray[2] & 0xFF) == 127 || n5 == this.synth.getDeviceID())) {
                n4 = byArray[3] & 0xFF;
                block2 : switch (n4) {
                    case 8: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 1: {
                                object2 = this.synth.getTuning(new Patch(0, byArray[5] & 0xFF));
                                ((SoftTuning)object2).load(byArray);
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                object2 = this.synth.getTuning(new Patch(byArray[5] & 0xFF, byArray[6] & 0xFF));
                                ((SoftTuning)object2).load(byArray);
                                break;
                            }
                            case 8: 
                            case 9: {
                                object2 = new SoftTuning(byArray);
                                n2 = (byArray[5] & 0xFF) * 16384 + (byArray[6] & 0xFF) * 128 + (byArray[7] & 0xFF);
                                softChannelArray = this.synth.channels;
                                for (n = 0; n < softChannelArray.length; ++n) {
                                    if ((n2 & 1 << n) == 0) continue;
                                    softChannelArray[n].tuning = object2;
                                }
                                break block2;
                            }
                        }
                        break;
                    }
                    case 9: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 1: {
                                this.synth.setGeneralMidiMode(1);
                                this.reset();
                                break block2;
                            }
                            case 2: {
                                this.synth.setGeneralMidiMode(0);
                                this.reset();
                                break block2;
                            }
                            case 3: {
                                this.synth.setGeneralMidiMode(2);
                                this.reset();
                                break block2;
                            }
                        }
                        break;
                    }
                    case 10: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 1: {
                                if (this.synth.getGeneralMidiMode() == 0) {
                                    this.synth.setGeneralMidiMode(1);
                                }
                                this.synth.voice_allocation_mode = 1;
                                this.reset();
                                break block2;
                            }
                            case 2: {
                                this.synth.setGeneralMidiMode(0);
                                this.synth.voice_allocation_mode = 0;
                                this.reset();
                                break block2;
                            }
                            case 3: {
                                this.synth.voice_allocation_mode = 0;
                                break block2;
                            }
                            case 4: {
                                this.synth.voice_allocation_mode = 1;
                                break block2;
                            }
                        }
                        break;
                    }
                }
            }
            if ((byArray[1] & 0xFF) == 127 && ((n5 = byArray[2] & 0xFF) == 127 || n5 == this.synth.getDeviceID())) {
                n4 = byArray[3] & 0xFF;
                block23 : switch (n4) {
                    case 4: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                int n6 = (byArray[5] & 0x7F) + (byArray[6] & 0x7F) * 128;
                                if (n3 == 1) {
                                    this.setVolume(n6);
                                    break block23;
                                }
                                if (n3 == 2) {
                                    this.setBalance(n6);
                                    break block23;
                                }
                                if (n3 == 3) {
                                    this.setFineTuning(n6);
                                    break block23;
                                }
                                if (n3 != 4) break;
                                this.setCoarseTuning(n6);
                                break block23;
                            }
                            case 5: {
                                int n7;
                                n2 = 5;
                                int n8 = byArray[n2++] & 0xFF;
                                n = byArray[n2++] & 0xFF;
                                int n9 = byArray[n2++] & 0xFF;
                                int[] nArray = new int[n8];
                                for (n7 = 0; n7 < n8; ++n7) {
                                    int n10 = byArray[n2++] & 0xFF;
                                    int n11 = byArray[n2++] & 0xFF;
                                    nArray[n7] = n10 * 128 + n11;
                                }
                                n7 = (byArray.length - 1 - n2) / (n + n9);
                                long[] lArray = new long[n7];
                                long[] lArray2 = new long[n7];
                                for (int i = 0; i < n7; ++i) {
                                    int n12;
                                    lArray2[i] = 0L;
                                    for (n12 = 0; n12 < n; ++n12) {
                                        lArray[i] = lArray[i] * 128L + (long)(byArray[n2++] & 0xFF);
                                    }
                                    for (n12 = 0; n12 < n9; ++n12) {
                                        lArray2[i] = lArray2[i] * 128L + (long)(byArray[n2++] & 0xFF);
                                    }
                                }
                                this.globalParameterControlChange(nArray, lArray, lArray2);
                                break block23;
                            }
                        }
                        break;
                    }
                    case 8: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 2: {
                                object2 = this.synth.getTuning(new Patch(0, byArray[5] & 0xFF));
                                ((SoftTuning)object2).load(byArray);
                                SoftVoice[] softVoiceArray = this.synth.getVoices();
                                for (int i = 0; i < softVoiceArray.length; ++i) {
                                    if (!softVoiceArray[i].active || softVoiceArray[i].tuning != object2) continue;
                                    softVoiceArray[i].updateTuning((SoftTuning)object2);
                                }
                                break block23;
                            }
                            case 7: {
                                object2 = this.synth.getTuning(new Patch(byArray[5] & 0xFF, byArray[6] & 0xFF));
                                ((SoftTuning)object2).load(byArray);
                                SoftVoice[] softVoiceArray = this.synth.getVoices();
                                for (int i = 0; i < softVoiceArray.length; ++i) {
                                    if (!softVoiceArray[i].active || softVoiceArray[i].tuning != object2) continue;
                                    softVoiceArray[i].updateTuning((SoftTuning)object2);
                                }
                                break block23;
                            }
                            case 8: 
                            case 9: {
                                object2 = new SoftTuning(byArray);
                                n2 = (byArray[5] & 0xFF) * 16384 + (byArray[6] & 0xFF) * 128 + (byArray[7] & 0xFF);
                                softChannelArray = this.synth.channels;
                                for (n = 0; n < softChannelArray.length; ++n) {
                                    if ((n2 & 1 << n) == 0) continue;
                                    softChannelArray[n].tuning = object2;
                                }
                                SoftVoice[] softVoiceArray = this.synth.getVoices();
                                for (int i = 0; i < softVoiceArray.length; ++i) {
                                    if (!softVoiceArray[i].active || (n2 & 1 << softVoiceArray[i].channel) == 0) continue;
                                    softVoiceArray[i].updateTuning((SoftTuning)object2);
                                }
                                break block23;
                            }
                        }
                        break;
                    }
                    case 9: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 1: {
                                object2 = new int[(byArray.length - 7) / 2];
                                int[] nArray = new int[(byArray.length - 7) / 2];
                                int n13 = 0;
                                for (n = 6; n < byArray.length - 1; n += 2) {
                                    object2[n13] = byArray[n] & 0xFF;
                                    nArray[n13] = byArray[n + 1] & 0xFF;
                                    ++n13;
                                }
                                n = byArray[5] & 0xFF;
                                SoftChannel softChannel = this.synth.channels[n];
                                softChannel.mapChannelPressureToDestination((int[])object2, nArray);
                                break block23;
                            }
                            case 2: {
                                object2 = new int[(byArray.length - 7) / 2];
                                int[] nArray = new int[(byArray.length - 7) / 2];
                                int n14 = 0;
                                for (n = 6; n < byArray.length - 1; n += 2) {
                                    object2[n14] = byArray[n] & 0xFF;
                                    nArray[n14] = byArray[n + 1] & 0xFF;
                                    ++n14;
                                }
                                n = byArray[5] & 0xFF;
                                SoftChannel softChannel = this.synth.channels[n];
                                softChannel.mapPolyPressureToDestination((int[])object2, nArray);
                                break block23;
                            }
                            case 3: {
                                object2 = new int[(byArray.length - 7) / 2];
                                int[] nArray = new int[(byArray.length - 7) / 2];
                                int n15 = 0;
                                for (n = 7; n < byArray.length - 1; n += 2) {
                                    object2[n15] = byArray[n] & 0xFF;
                                    nArray[n15] = byArray[n + 1] & 0xFF;
                                    ++n15;
                                }
                                n = byArray[5] & 0xFF;
                                SoftChannel softChannel = this.synth.channels[n];
                                int n16 = byArray[6] & 0xFF;
                                softChannel.mapControlToDestination(n16, (int[])object2, nArray);
                                break block23;
                            }
                        }
                        break;
                    }
                    case 10: {
                        n3 = byArray[4] & 0xFF;
                        switch (n3) {
                            case 1: {
                                int n17 = byArray[5] & 0xFF;
                                n2 = byArray[6] & 0xFF;
                                softChannelArray = this.synth.channels[n17];
                                for (n = 7; n < byArray.length - 1; n += 2) {
                                    int n18 = byArray[n] & 0xFF;
                                    int n19 = byArray[n + 1] & 0xFF;
                                    softChannelArray.controlChangePerNote(n2, n18, n19);
                                }
                                break block23;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private void processMessages(long l) {
        Iterator<Map.Entry<Long, Object>> iterator = this.midimessages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Object> entry = iterator.next();
            if (entry.getKey() > l + 100L) {
                return;
            }
            this.processMessage(entry.getValue());
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void processAudioBuffers() {
        int n;
        ModelChannelMixer[] modelChannelMixerArray;
        double d;
        double d2;
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].clear();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            double d3;
            this.processMessages(this.msec_pos);
            if (this.active_sensing_on && this.msec_pos - this.msec_last_activity > 1000000L) {
                this.active_sensing_on = false;
                for (SoftChannel object2 : this.synth.channels) {
                    object2.allSoundOff();
                }
            }
            for (int i = 0; i < this.voicestatus.length; ++i) {
                if (!this.voicestatus[i].active) continue;
                this.voicestatus[i].processControlLogic();
            }
            this.msec_pos += this.msec_buffer_len;
            d2 = d3 = this.co_master_volume[0];
            d = d3;
            double d4 = this.co_master_balance[0];
            if (d4 > 0.5) {
                d2 *= (1.0 - d4) * 2.0;
            } else {
                d *= d4 * 2.0;
            }
            this.chorus.processControlLogic();
            this.reverb.processControlLogic();
            this.agc.processControlLogic();
            if (this.cur_registeredMixers == null && this.registeredMixers != null) {
                this.cur_registeredMixers = new ModelChannelMixer[this.registeredMixers.size()];
                this.registeredMixers.toArray(this.cur_registeredMixers);
            }
            if ((modelChannelMixerArray = this.cur_registeredMixers) != null && modelChannelMixerArray.length == 0) {
                modelChannelMixerArray = null;
            }
        }
        if (modelChannelMixerArray != null) {
            object = this.buffers[0];
            SoftAudioBuffer softAudioBuffer = this.buffers[1];
            SoftAudioBuffer softAudioBuffer2 = this.buffers[2];
            this.buffers[0] = this.buffers[14];
            this.buffers[1] = this.buffers[15];
            this.buffers[2] = this.buffers[16];
            int n2 = this.buffers[0].getSize();
            float[][] n10 = new float[this.nrofchannels][];
            n10[0] = this.buffers[0].array();
            if (this.nrofchannels != 1) {
                n10[1] = this.buffers[1].array();
            }
            float[][] fArrayArray = new float[this.nrofchannels][];
            fArrayArray[0] = ((SoftAudioBuffer)object).array();
            if (this.nrofchannels != 1) {
                fArrayArray[1] = softAudioBuffer.array();
            }
            for (ModelChannelMixer modelChannelMixer : modelChannelMixerArray) {
                int n3;
                float[] fArray;
                float[] fArray2;
                int n4;
                int n5;
                for (n5 = 0; n5 < n10.length; ++n5) {
                    Arrays.fill(n10[n5], 0.0f);
                }
                this.buffers[2].clear();
                n5 = 0;
                for (n4 = 0; n4 < this.voicestatus.length; ++n4) {
                    if (!this.voicestatus[n4].active || this.voicestatus[n4].channelmixer != modelChannelMixer) continue;
                    this.voicestatus[n4].processAudioLogic(this.buffers);
                    n5 = 1;
                }
                if (!modelChannelMixer.process(n10, 0, n2)) {
                    Object object2 = this.control_mutex;
                    synchronized (object2) {
                        this.registeredMixers.remove(modelChannelMixer);
                        this.cur_registeredMixers = null;
                    }
                }
                if (!this.buffers[2].isSilent()) {
                    float[] fArray3 = this.buffers[2].array();
                    fArray2 = this.buffers[0].array();
                    if (this.nrofchannels != 1) {
                        fArray = this.buffers[1].array();
                        n3 = 0;
                        while (n3 < n2) {
                            float f = fArray3[n3];
                            int n6 = n3;
                            fArray2[n6] = fArray2[n6] + f;
                            int n7 = n3++;
                            fArray[n7] = fArray[n7] + f;
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            int n8 = i;
                            fArray2[n8] = fArray2[n8] + fArray3[i];
                        }
                    }
                }
                for (n4 = 0; n4 < n10.length; ++n4) {
                    fArray2 = n10[n4];
                    fArray = fArrayArray[n4];
                    for (n3 = 0; n3 < n2; ++n3) {
                        int n9 = n3;
                        fArray[n9] = fArray[n9] + fArray2[n3];
                    }
                }
                if (n5 != 0) continue;
                Object object3 = this.control_mutex;
                synchronized (object3) {
                    if (this.stoppedMixers != null && this.stoppedMixers.contains(modelChannelMixer)) {
                        this.stoppedMixers.remove(modelChannelMixer);
                        modelChannelMixer.stop();
                    }
                }
            }
            this.buffers[0] = object;
            this.buffers[1] = softAudioBuffer;
            this.buffers[2] = softAudioBuffer2;
        }
        for (int i = 0; i < this.voicestatus.length; ++i) {
            if (!this.voicestatus[i].active || this.voicestatus[i].channelmixer != null) continue;
            this.voicestatus[i].processAudioLogic(this.buffers);
        }
        if (!this.buffers[2].isSilent()) {
            float[] fArray = this.buffers[2].array();
            float[] fArray3 = this.buffers[0].array();
            n = this.buffers[0].getSize();
            if (this.nrofchannels != 1) {
                void var10_29;
                float[] fArray4 = this.buffers[1].array();
                boolean n17 = false;
                while (var10_29 < n) {
                    float f = fArray[var10_29];
                    void v4 = var10_29;
                    fArray3[v4] = fArray3[v4] + f;
                    void v5 = var10_29++;
                    fArray4[v5] = fArray4[v5] + f;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n10 = i;
                    fArray3[n10] = fArray3[n10] + fArray[i];
                }
            }
        }
        if (this.synth.chorus_on) {
            this.chorus.processAudio();
        }
        if (this.synth.reverb_on) {
            this.reverb.processAudio();
        }
        if (this.nrofchannels == 1) {
            d2 = (d2 + d) / 2.0;
        }
        if (this.last_volume_left != d2 || this.last_volume_right != d) {
            float[] fArray = this.buffers[0].array();
            float[] fArray5 = this.buffers[1].array();
            n = this.buffers[0].getSize();
            float f = (float)(this.last_volume_left * this.last_volume_left);
            float f2 = (float)((d2 * d2 - (double)f) / (double)n);
            int n11 = 0;
            while (n11 < n) {
                int n12 = n11++;
                fArray[n12] = fArray[n12] * (f += f2);
            }
            if (this.nrofchannels != 1) {
                f = (float)(this.last_volume_right * this.last_volume_right);
                f2 = (float)((d * d - (double)f) / (double)n);
                n11 = 0;
                while (n11 < n) {
                    f += f2;
                    int n13 = n11++;
                    fArray5[n13] = (float)((double)fArray5[n13] * d);
                }
            }
            this.last_volume_left = d2;
            this.last_volume_right = d;
        } else if (d2 != 1.0 || d != 1.0) {
            void var10_32;
            float[] fArray = this.buffers[0].array();
            float[] fArray6 = this.buffers[1].array();
            n = this.buffers[0].getSize();
            float f = (float)(d2 * d2);
            boolean bl = false;
            while (var10_32 < n) {
                void v9 = var10_32++;
                fArray[v9] = fArray[v9] * f;
            }
            if (this.nrofchannels != 1) {
                void var10_34;
                f = (float)(d * d);
                boolean bl2 = false;
                while (var10_34 < n) {
                    void v10 = var10_34++;
                    fArray6[v10] = fArray6[v10] * f;
                }
            }
        }
        if (this.buffers[0].isSilent() && this.buffers[1].isSilent()) {
            ++this.pusher_silent_count;
            if (this.pusher_silent_count > 5) {
                this.pusher_silent_count = 0;
                Object object8 = this.control_mutex;
                synchronized (object8) {
                    this.pusher_silent = true;
                    if (this.synth.weakstream != null) {
                        this.synth.weakstream.setInputStream(null);
                    }
                }
            }
        } else {
            this.pusher_silent_count = 0;
        }
        if (this.synth.agc_on) {
            this.agc.processAudio();
        }
    }

    public void activity() {
        this.msec_last_activity = this.msec_pos;
        if (this.pusher_silent) {
            this.pusher_silent = false;
            if (this.synth.weakstream != null) {
                this.synth.weakstream.setInputStream(this.ais);
            }
        }
    }

    public void stopMixer(ModelChannelMixer modelChannelMixer) {
        if (this.stoppedMixers == null) {
            this.stoppedMixers = new HashSet<ModelChannelMixer>();
        }
        this.stoppedMixers.add(modelChannelMixer);
    }

    public void registerMixer(ModelChannelMixer modelChannelMixer) {
        if (this.registeredMixers == null) {
            this.registeredMixers = new HashSet<ModelChannelMixer>();
        }
        this.registeredMixers.add(modelChannelMixer);
        this.cur_registeredMixers = null;
    }

    public SoftMainMixer(SoftSynthesizer softSynthesizer) {
        this.synth = softSynthesizer;
        this.msec_pos = 0L;
        this.co_master_balance[0] = 0.5;
        this.co_master_volume[0] = 1.0;
        this.co_master_coarse_tuning[0] = 0.5;
        this.co_master_fine_tuning[0] = 0.5;
        this.msec_buffer_len = (long)(1000000.0 / (double)softSynthesizer.getControlRate());
        this.nrofchannels = softSynthesizer.getFormat().getChannels();
        int n = (int)(softSynthesizer.getFormat().getSampleRate() / softSynthesizer.getControlRate());
        this.control_mutex = softSynthesizer.control_mutex;
        this.buffers = new SoftAudioBuffer[17];
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new SoftAudioBuffer(n, softSynthesizer.getFormat());
        }
        this.voicestatus = softSynthesizer.getVoices();
        this.reverb = new SoftReverb();
        this.chorus = new SoftChorus();
        this.agc = new SoftLimiter();
        float f = softSynthesizer.getFormat().getSampleRate();
        float f2 = softSynthesizer.getControlRate();
        this.reverb.init(f, f2);
        this.chorus.init(f, f2);
        this.agc.init(f, f2);
        this.reverb.setLightMode(softSynthesizer.reverb_light);
        this.reverb.setMixMode(true);
        this.chorus.setMixMode(true);
        this.agc.setMixMode(false);
        this.chorus.setInput(0, this.buffers[4]);
        this.chorus.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.chorus.setOutput(1, this.buffers[1]);
        }
        this.chorus.setOutput(2, this.buffers[3]);
        this.reverb.setInput(0, this.buffers[3]);
        this.reverb.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.reverb.setOutput(1, this.buffers[1]);
        }
        this.agc.setInput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.agc.setInput(1, this.buffers[1]);
        }
        this.agc.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.agc.setOutput(1, this.buffers[1]);
        }
        InputStream inputStream = new InputStream(){
            private SoftAudioBuffer[] buffers;
            private int nrofchannels;
            private int buffersize;
            private byte[] bbuffer;
            private int bbuffer_pos;
            private byte[] single;
            {
                this.buffers = SoftMainMixer.this.buffers;
                this.nrofchannels = SoftMainMixer.this.synth.getFormat().getChannels();
                this.buffersize = this.buffers[0].getSize();
                this.bbuffer = new byte[this.buffersize * (SoftMainMixer.this.synth.getFormat().getSampleSizeInBits() / 8) * this.nrofchannels];
                this.bbuffer_pos = 0;
                this.single = new byte[1];
            }

            public void fillBuffer() {
                SoftMainMixer.this.processAudioBuffers();
                for (int i = 0; i < this.nrofchannels; ++i) {
                    this.buffers[i].get(this.bbuffer, i);
                }
                this.bbuffer_pos = 0;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) {
                int n3 = this.bbuffer.length;
                int n4 = n + n2;
                int n5 = n;
                byte[] byArray2 = this.bbuffer;
                while (n < n4) {
                    if (this.available() == 0) {
                        this.fillBuffer();
                        continue;
                    }
                    int n6 = this.bbuffer_pos;
                    while (n < n4 && n6 < n3) {
                        byArray[n++] = byArray2[n6++];
                    }
                    this.bbuffer_pos = n6;
                    if (SoftMainMixer.this.readfully) continue;
                    return n - n5;
                }
                return n2;
            }

            @Override
            public int read() throws IOException {
                int n = this.read(this.single);
                if (n == -1) {
                    return -1;
                }
                return this.single[0] & 0xFF;
            }

            @Override
            public int available() {
                return this.bbuffer.length - this.bbuffer_pos;
            }

            @Override
            public void close() {
                SoftMainMixer.this.synth.close();
            }
        };
        this.ais = new AudioInputStream(inputStream, softSynthesizer.getFormat(), -1L);
    }

    public AudioInputStream getInputStream() {
        return this.ais;
    }

    public void reset() {
        SoftChannel[] softChannelArray = this.synth.channels;
        for (int i = 0; i < softChannelArray.length; ++i) {
            softChannelArray[i].allSoundOff();
            softChannelArray[i].resetAllControllers(true);
            if (this.synth.getGeneralMidiMode() == 2) {
                if (i == 9) {
                    softChannelArray[i].programChange(0, 15360);
                    continue;
                }
                softChannelArray[i].programChange(0, 15488);
                continue;
            }
            softChannelArray[i].programChange(0, 0);
        }
        this.setVolume(16383);
        this.setBalance(8192);
        this.setCoarseTuning(8192);
        this.setFineTuning(8192);
        this.globalParameterControlChange(new int[]{129}, new long[]{0L}, new long[]{4L});
        this.globalParameterControlChange(new int[]{130}, new long[]{0L}, new long[]{2L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_volume[0] = (double)n / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalance(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_balance[0] = (double)n / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFineTuning(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_fine_tuning[0] = (double)n / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoarseTuning(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_coarse_tuning[0] = (double)n / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVolume() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_volume[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBalance() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_balance[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFineTuning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_fine_tuning[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCoarseTuning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_coarse_tuning[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void globalParameterControlChange(int[] nArray, long[] lArray, long[] lArray2) {
        if (nArray.length == 0) {
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            int n;
            if (nArray[0] == 129) {
                for (n = 0; n < lArray2.length; ++n) {
                    this.reverb.globalParameterControlChange(nArray, lArray[n], lArray2[n]);
                }
            }
            if (nArray[0] == 130) {
                for (n = 0; n < lArray2.length; ++n) {
                    this.chorus.globalParameterControlChange(nArray, lArray[n], lArray2[n]);
                }
            }
        }
    }

    public void processMessage(Object object) {
        if (object instanceof byte[]) {
            this.processMessage((byte[])object);
        }
        if (object instanceof MidiMessage) {
            this.processMessage((MidiMessage)object);
        }
    }

    public void processMessage(MidiMessage midiMessage) {
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            this.processMessage(shortMessage.getChannel(), shortMessage.getCommand(), shortMessage.getData1(), shortMessage.getData2());
            return;
        }
        this.processMessage(midiMessage.getMessage());
    }

    public void processMessage(byte[] byArray) {
        int n = 0;
        if (byArray.length > 0) {
            n = byArray[0] & 0xFF;
        }
        if (n == 240) {
            this.processSystemExclusiveMessage(byArray);
            return;
        }
        int n2 = n & 0xF0;
        int n3 = n & 0xF;
        int n4 = byArray.length > 1 ? byArray[1] & 0xFF : 0;
        int n5 = byArray.length > 2 ? byArray[2] & 0xFF : 0;
        this.processMessage(n3, n2, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(int n, int n2, int n3, int n4) {
        SoftChannel[] softChannelArray = this.synth.control_mutex;
        synchronized (this.synth.control_mutex) {
            this.activity();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (n2 == 240) {
                int n5 = n2 | n;
                switch (n5) {
                    case 254: {
                        Object object = this.synth.control_mutex;
                        synchronized (object) {
                            this.active_sensing_on = true;
                            break;
                        }
                    }
                }
                return;
            }
            softChannelArray = this.synth.channels;
            if (n >= softChannelArray.length) {
                return;
            }
            SoftChannel softChannel = softChannelArray[n];
            switch (n2) {
                case 144: {
                    softChannel.noteOn(n3, n4);
                    break;
                }
                case 128: {
                    softChannel.noteOff(n3, n4);
                    break;
                }
                case 160: {
                    softChannel.setPolyPressure(n3, n4);
                    break;
                }
                case 176: {
                    softChannel.controlChange(n3, n4);
                    break;
                }
                case 192: {
                    softChannel.programChange(n3);
                    break;
                }
                case 208: {
                    softChannel.setChannelPressure(n3);
                    break;
                }
                case 224: {
                    softChannel.setPitchBend(n3 + n4 * 128);
                    break;
                }
            }
            return;
        }
    }

    public long getMicrosecondPosition() {
        return this.msec_pos;
    }

    public void close() {
    }
}

