/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.internal.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionAddressingConstants;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndpointReferenceUtil {
    private static boolean w3cMetadataWritten = false;

    public static <T extends EndpointReference> T transform(Class<T> clazz, @NotNull EndpointReference epr) {
        assert (epr != null);
        if (clazz.isAssignableFrom(W3CEndpointReference.class)) {
            if (epr instanceof W3CEndpointReference) {
                return (T)epr;
            }
            if (epr instanceof MemberSubmissionEndpointReference) {
                return (T)EndpointReferenceUtil.toW3CEpr((MemberSubmissionEndpointReference)epr);
            }
        } else if (clazz.isAssignableFrom(MemberSubmissionEndpointReference.class)) {
            if (epr instanceof W3CEndpointReference) {
                return (T)EndpointReferenceUtil.toMSEpr((W3CEndpointReference)epr);
            }
            if (epr instanceof MemberSubmissionEndpointReference) {
                return (T)epr;
            }
        }
        throw new WebServiceException("Unknwon EndpointReference: " + epr.getClass());
    }

    private static W3CEndpointReference toW3CEpr(MemberSubmissionEndpointReference msEpr) {
        StreamWriterBufferCreator writer = new StreamWriterBufferCreator();
        w3cMetadataWritten = false;
        try {
            writer.writeStartDocument();
            writer.writeStartElement(AddressingVersion.W3C.getPrefix(), "EndpointReference", AddressingVersion.W3C.nsUri);
            writer.writeNamespace(AddressingVersion.W3C.getPrefix(), AddressingVersion.W3C.nsUri);
            writer.writeStartElement(AddressingVersion.W3C.getPrefix(), "Address", AddressingVersion.W3C.nsUri);
            writer.writeCharacters(msEpr.addr.uri);
            writer.writeEndElement();
            if (msEpr.referenceProperties != null && msEpr.referenceProperties.elements.size() > 0 || msEpr.referenceParameters != null && msEpr.referenceParameters.elements.size() > 0) {
                writer.writeStartElement(AddressingVersion.W3C.getPrefix(), "ReferenceParameters", AddressingVersion.W3C.nsUri);
                if (msEpr.referenceProperties != null) {
                    for (Element e : msEpr.referenceProperties.elements) {
                        DOMUtil.serializeNode(e, writer);
                    }
                }
                if (msEpr.referenceParameters != null) {
                    for (Element e : msEpr.referenceParameters.elements) {
                        DOMUtil.serializeNode(e, writer);
                    }
                }
                writer.writeEndElement();
            }
            Element wsdlElement = null;
            if (msEpr.elements != null && msEpr.elements.size() > 0) {
                for (Element e : msEpr.elements) {
                    NodeList nl;
                    if (!e.getNamespaceURI().equals(MemberSubmissionAddressingConstants.MEX_METADATA.getNamespaceURI()) || !e.getLocalName().equals(MemberSubmissionAddressingConstants.MEX_METADATA.getLocalPart()) || (nl = e.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) == null) continue;
                    wsdlElement = (Element)nl.item(0);
                }
            }
            if (wsdlElement != null) {
                DOMUtil.serializeNode(wsdlElement, writer);
            }
            if (w3cMetadataWritten) {
                writer.writeEndElement();
            }
            if (msEpr.elements != null && msEpr.elements.size() > 0) {
                for (Element e : msEpr.elements) {
                    if (!e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || e.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                        // empty if block
                    }
                    DOMUtil.serializeNode(e, writer);
                }
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
        return new W3CEndpointReference(new XMLStreamBufferSource(writer.getXMLStreamBuffer()));
    }

    private static void writeW3CMetadata(StreamWriterBufferCreator writer) throws XMLStreamException {
        if (!w3cMetadataWritten) {
            writer.writeStartElement(AddressingVersion.W3C.getPrefix(), "Metadata", AddressingVersion.W3C.nsUri);
            w3cMetadataWritten = true;
        }
    }

    private static MemberSubmissionEndpointReference toMSEpr(W3CEndpointReference w3cEpr) {
        DOMResult result = new DOMResult();
        w3cEpr.writeTo(result);
        Node eprNode = result.getNode();
        Element e = DOMUtil.getFirstElementChild(eprNode);
        if (e == null) {
            return null;
        }
        MemberSubmissionEndpointReference msEpr = new MemberSubmissionEndpointReference();
        NodeList nodes = e.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() == 1) {
                Element child = (Element)nodes.item(i);
                if (child.getNamespaceURI().equals(AddressingVersion.W3C.nsUri) && child.getLocalName().equals("Address")) {
                    if (msEpr.addr == null) {
                        msEpr.addr = new MemberSubmissionEndpointReference.Address();
                    }
                    msEpr.addr.uri = XmlUtil.getTextForNode(child);
                    msEpr.addr.attributes = EndpointReferenceUtil.getAttributes(child);
                    continue;
                }
                if (child.getNamespaceURI().equals(AddressingVersion.W3C.nsUri) && child.getLocalName().equals("ReferenceParameters")) {
                    NodeList refParams = child.getChildNodes();
                    for (int j = 0; j < refParams.getLength(); ++j) {
                        if (refParams.item(j).getNodeType() != 1) continue;
                        if (msEpr.referenceParameters == null) {
                            msEpr.referenceParameters = new MemberSubmissionEndpointReference.Elements();
                            msEpr.referenceParameters.elements = new ArrayList<Element>();
                        }
                        msEpr.referenceParameters.elements.add((Element)refParams.item(j));
                    }
                    continue;
                }
                if (child.getNamespaceURI().equals(AddressingVersion.W3C.nsUri) && child.getLocalName().equals("Metadata")) {
                    NodeList metadata = child.getChildNodes();
                    for (int j = 0; j < metadata.getLength(); ++j) {
                        String ns;
                        String name;
                        String prefix;
                        Node node = metadata.item(j);
                        if (node.getNodeType() != 1) continue;
                        Element elm = (Element)node;
                        if (elm.getNamespaceURI().equals(AddressingVersion.W3C.wsdlNsUri) && elm.getLocalName().equals("ServiceName")) {
                            msEpr.serviceName = new MemberSubmissionEndpointReference.ServiceNameType();
                            msEpr.serviceName.portName = elm.getAttribute("EndpointName");
                            String service = elm.getTextContent();
                            prefix = XmlUtil.getPrefix(service);
                            name = XmlUtil.getLocalPart(service);
                            if (name == null) continue;
                            if (prefix != null) {
                                ns = elm.lookupNamespaceURI(prefix);
                                if (ns != null) {
                                    msEpr.serviceName.name = new QName(ns, name, prefix);
                                }
                            } else {
                                msEpr.serviceName.name = new QName(null, name);
                            }
                            msEpr.serviceName.attributes = EndpointReferenceUtil.getAttributes(elm);
                            continue;
                        }
                        if (elm.getNamespaceURI().equals(AddressingVersion.W3C.wsdlNsUri) && elm.getLocalName().equals("InterfaceName")) {
                            msEpr.portTypeName = new MemberSubmissionEndpointReference.AttributedQName();
                            String portType = elm.getTextContent();
                            prefix = XmlUtil.getPrefix(portType);
                            name = XmlUtil.getLocalPart(portType);
                            if (name == null) continue;
                            if (prefix != null) {
                                ns = elm.lookupNamespaceURI(prefix);
                                if (ns != null) {
                                    msEpr.portTypeName.name = new QName(ns, name, prefix);
                                }
                            } else {
                                msEpr.portTypeName.name = new QName(null, name);
                            }
                            msEpr.portTypeName.attributes = EndpointReferenceUtil.getAttributes(elm);
                            continue;
                        }
                        if (elm.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") && elm.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                            Document doc = DOMUtil.createDom();
                            Element mexEl = doc.createElementNS(MemberSubmissionAddressingConstants.MEX_METADATA.getNamespaceURI(), MemberSubmissionAddressingConstants.MEX_METADATA.getPrefix() + ":" + MemberSubmissionAddressingConstants.MEX_METADATA.getLocalPart());
                            Element metadataEl = doc.createElementNS(MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getNamespaceURI(), MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getPrefix() + ":" + MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getLocalPart());
                            metadataEl.setAttribute("Dialect", "http://schemas.xmlsoap.org/wsdl/");
                            metadataEl.appendChild(elm);
                            mexEl.appendChild(metadataEl);
                            continue;
                        }
                        if (msEpr.elements == null) {
                            msEpr.elements = new ArrayList<Element>();
                        }
                        msEpr.elements.add(elm);
                    }
                    continue;
                }
                if (msEpr.elements == null) {
                    msEpr.elements = new ArrayList<Element>();
                }
                msEpr.elements.add(child);
                continue;
            }
            if (nodes.item(i).getNodeType() != 2) continue;
            Node n = nodes.item(i);
            if (msEpr.attributes != null) continue;
            msEpr.attributes = new HashMap<QName, String>();
            String prefix = EndpointReferenceUtil.fixNull(n.getPrefix());
            String ns = EndpointReferenceUtil.fixNull(n.getNamespaceURI());
            String localName = n.getLocalName();
            msEpr.attributes.put(new QName(ns, localName, prefix), n.getNodeValue());
        }
        return msEpr;
    }

    private static Map<QName, String> getAttributes(Node node) {
        HashMap<QName, String> attribs = null;
        NamedNodeMap nm = node.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            if (attribs == null) {
                attribs = new HashMap<QName, String>();
            }
            Node n = nm.item(i);
            String prefix = EndpointReferenceUtil.fixNull(n.getPrefix());
            String ns = EndpointReferenceUtil.fixNull(n.getNamespaceURI());
            String localName = n.getLocalName();
            if (prefix.equals("xmlns") || prefix.length() == 0 && localName.equals("xmlns") || localName.equals("EndpointName")) continue;
            attribs.put(new QName(ns, localName, prefix), n.getNodeValue());
        }
        return attribs;
    }

    @NotNull
    private static String fixNull(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

