/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.sei.DispatchException;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import com.sun.xml.internal.ws.util.QNameMap;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

final class PayloadQNameBasedDispatcher
implements EndpointMethodDispatcher {
    private static final Logger LOGGER = Logger.getLogger(PayloadQNameBasedDispatcher.class.getName());
    private static final String EMPTY_PAYLOAD_LOCAL = "";
    private static final String EMPTY_PAYLOAD_NSURI = "";
    private static final QName EMPTY_PAYLOAD = new QName("", "");
    private final QNameMap<EndpointMethodHandler> methodHandlers = new QNameMap();
    private final QNameMap<List<String>> unique = new QNameMap();
    private final WSBinding binding;

    public PayloadQNameBasedDispatcher(AbstractSEIModelImpl model, WSBinding binding, SEIInvokerTube invokerTube) {
        QName name;
        this.binding = binding;
        for (JavaMethodImpl javaMethodImpl : model.getJavaMethods()) {
            List<String> methods;
            name = javaMethodImpl.getRequestPayloadName();
            if (name == null) {
                name = EMPTY_PAYLOAD;
            }
            if ((methods = this.unique.get(name)) == null) {
                methods = new ArrayList<String>();
                this.unique.put(name, methods);
            }
            methods.add(javaMethodImpl.getMethod().getName());
        }
        for (QNameMap.Entry entry : this.unique.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            LOGGER.warning(ServerMessages.NON_UNIQUE_DISPATCH_QNAME(entry.getValue(), entry.createQName()));
        }
        for (JavaMethodImpl javaMethodImpl : model.getJavaMethods()) {
            name = javaMethodImpl.getRequestPayloadName();
            if (name == null) {
                name = EMPTY_PAYLOAD;
            }
            if (this.unique.get(name).size() != 1) continue;
            this.methodHandlers.put(name, new EndpointMethodHandler(invokerTube, javaMethodImpl, binding));
        }
    }

    @Override
    @Nullable
    public EndpointMethodHandler getEndpointMethodHandler(Packet request) throws DispatchException {
        String nsUri;
        Message message = request.getMessage();
        String localPart = message.getPayloadLocalPart();
        if (localPart == null) {
            localPart = "";
            nsUri = "";
        } else {
            nsUri = message.getPayloadNamespaceURI();
            if (nsUri == null) {
                nsUri = "";
            }
        }
        EndpointMethodHandler mh = this.methodHandlers.get(nsUri, localPart);
        if (mh == null && !this.unique.containsKey(nsUri, localPart)) {
            String dispatchKey = "{" + nsUri + "}" + localPart;
            String faultString = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(dispatchKey);
            throw new DispatchException(SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), faultString, this.binding.getSOAPVersion().faultCodeClient));
        }
        return mh;
    }
}

