/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BetweenQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -2933597532866307444L;
    private ValueExp exp1;
    private ValueExp exp2;
    private ValueExp exp3;

    public BetweenQueryExp() {
    }

    public BetweenQueryExp(ValueExp valueExp, ValueExp valueExp2, ValueExp valueExp3) {
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
        this.exp3 = valueExp3;
    }

    public ValueExp getCheckedValue() {
        return this.exp1;
    }

    public ValueExp getLowerBound() {
        return this.exp2;
    }

    public ValueExp getUpperBound() {
        return this.exp3;
    }

    @Override
    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(objectName);
        ValueExp valueExp2 = this.exp2.apply(objectName);
        ValueExp valueExp3 = this.exp3.apply(objectName);
        boolean bl = valueExp instanceof NumericValueExp;
        if (bl) {
            if (((NumericValueExp)valueExp).isLong()) {
                long l = ((NumericValueExp)valueExp).longValue();
                long l2 = ((NumericValueExp)valueExp2).longValue();
                long l3 = ((NumericValueExp)valueExp3).longValue();
                return l2 <= l && l <= l3;
            }
            double d = ((NumericValueExp)valueExp).doubleValue();
            double d2 = ((NumericValueExp)valueExp2).doubleValue();
            double d3 = ((NumericValueExp)valueExp3).doubleValue();
            return d2 <= d && d <= d3;
        }
        String string = ((StringValueExp)valueExp).getValue();
        String string2 = ((StringValueExp)valueExp2).getValue();
        String string3 = ((StringValueExp)valueExp3).getValue();
        return string2.compareTo(string) <= 0 && string.compareTo(string3) <= 0;
    }

    public String toString() {
        return "(" + this.exp1 + ") between (" + this.exp2 + ") and (" + this.exp3 + ")";
    }

    @Override
    String toQueryString() {
        return this.exp1 + " between " + this.exp2 + " and " + this.exp3;
    }
}

