/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.JTextComponent;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static String newline = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("close"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOptionPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.optionPane = (JOptionPane)jComponent;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
        LookAndFeel.installProperty(this.optionPane, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.optionPane);
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container container = this.createSeparator();
        if (container != null) {
            this.optionPane.add(container);
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.handler = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, inputMap);
        LazyActionMap.installLazyActionMap(this.optionPane, BasicOptionPaneUI.class, "OptionPane.actionMap");
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    InputMap getInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])DefaultLookup.get(this.optionPane, this, "OptionPane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.optionPane, objectArray);
        }
        return null;
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent == this.optionPane) {
            Dimension dimension = this.getMinimumOptionPaneSize();
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager != null) {
                Dimension dimension2 = layoutManager.preferredLayoutSize(jComponent);
                if (dimension != null) {
                    return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
                }
                return dimension2;
            }
            return dimension;
        }
        return null;
    }

    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        Border border = (Border)DefaultLookup.get(this.optionPane, this, "OptionPane.messageAreaBorder");
        if (border != null) {
            jPanel.setBorder(border);
        }
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setName("OptionPane.body");
        jPanel3.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            serializable = new JPanel();
            serializable.setName("OptionPane.separator");
            serializable.setPreferredSize(new Dimension(15, 1));
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).anchor = DefaultLookup.getInt(this.optionPane, this, "OptionPane.messageAnchor", 10);
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        this.addIcon(jPanel);
        return jPanel;
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            if (object instanceof JScrollPane || object instanceof JPanel) {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
            } else {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                this.addMessageComponents(container, gridBagConstraints, object2, n, false);
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            this.configureMessageLabel(jLabel);
            this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
        } else {
            String string = object.toString();
            int n2 = string.length();
            if (n2 <= 0) {
                return;
            }
            int n3 = 0;
            int n4 = string.indexOf(newline);
            if (n4 >= 0) {
                n3 = newline.length();
            } else {
                n4 = string.indexOf("\r\n");
                if (n4 >= 0) {
                    n3 = 2;
                } else {
                    n4 = string.indexOf(10);
                    if (n4 >= 0) {
                        n3 = 1;
                    }
                }
            }
            if (n4 >= 0) {
                if (n4 == 0) {
                    JPanel jPanel = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            Font font = this.getFont();
                            if (font != null) {
                                return new Dimension(1, font.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    };
                    jPanel.setName("OptionPane.break");
                    this.addMessageComponents(container, gridBagConstraints, jPanel, n, true);
                } else {
                    this.addMessageComponents(container, gridBagConstraints, string.substring(0, n4), n, false);
                }
                this.addMessageComponents(container, gridBagConstraints, string.substring(n4 + n3), n, false);
            } else if (n2 > n) {
                Box box = Box.createVerticalBox();
                box.setName("OptionPane.verticalBox");
                this.burstStringInto(box, string, n);
                this.addMessageComponents(container, gridBagConstraints, box, n, true);
            } else {
                JLabel jLabel = new JLabel(string, 10);
                jLabel.setName("OptionPane.label");
                this.configureMessageLabel(jLabel);
                this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
            }
        }
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent jComponent;
                JComponent jComponent2;
                Object object = this.optionPane.getMessage();
                Object[] objectArray = this.optionPane.getSelectionValues();
                Object object2 = this.optionPane.getInitialSelectionValue();
                if (objectArray != null) {
                    if (objectArray.length < 20) {
                        jComponent2 = new JComboBox();
                        jComponent2.setName("OptionPane.comboBox");
                        int n = objectArray.length;
                        for (int i = 0; i < n; ++i) {
                            ((JComboBox)jComponent2).addItem(objectArray[i]);
                        }
                        if (object2 != null) {
                            ((JComboBox)jComponent2).setSelectedItem(object2);
                        }
                        this.inputComponent = jComponent2;
                        jComponent = jComponent2;
                    } else {
                        jComponent2 = new JList(objectArray);
                        JScrollPane jScrollPane = new JScrollPane(jComponent2);
                        jScrollPane.setName("OptionPane.scrollPane");
                        jComponent2.setName("OptionPane.list");
                        ((JList)jComponent2).setVisibleRowCount(10);
                        ((JList)jComponent2).setSelectionMode(0);
                        if (object2 != null) {
                            ((JList)jComponent2).setSelectedValue(object2, true);
                        }
                        jComponent2.addMouseListener(this.getHandler());
                        jComponent = jScrollPane;
                        this.inputComponent = jComponent2;
                    }
                } else {
                    jComponent2 = new MultiplexingTextField(20);
                    jComponent2.setName("OptionPane.textField");
                    ((MultiplexingTextField)jComponent2).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (object2 != null) {
                        String string = object2.toString();
                        ((JTextComponent)jComponent2).setText(string);
                        ((JTextComponent)jComponent2).setSelectionStart(0);
                        ((JTextComponent)jComponent2).setSelectionEnd(string.length());
                    }
                    ((JTextField)jComponent2).addActionListener(this.getHandler());
                    jComponent = this.inputComponent = jComponent2;
                }
                jComponent2 = object == null ? new Object[]{jComponent} : new Object[]{object, jComponent};
                return jComponent2;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setName("OptionPane.iconLabel");
            jLabel.setVerticalAlignment(1);
            container.add((Component)jLabel, "Before");
        }
    }

    protected Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = this.getIconForType(this.optionPane.getMessageType());
        }
        return icon;
    }

    protected Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        String string = null;
        switch (n) {
            case 0: {
                string = "OptionPane.errorIcon";
                break;
            }
            case 1: {
                string = "OptionPane.informationIcon";
                break;
            }
            case 2: {
                string = "OptionPane.warningIcon";
                break;
            }
            case 3: {
                string = "OptionPane.questionIcon";
            }
        }
        if (string != null) {
            return (Icon)DefaultLookup.get(this.optionPane, this, string);
        }
        return null;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    protected void burstStringInto(Container container, String string, int n) {
        int n2 = string.length();
        if (n2 <= 0) {
            return;
        }
        if (n2 > n) {
            int n3 = string.lastIndexOf(32, n);
            if (n3 <= 0) {
                n3 = string.indexOf(32, n);
            }
            if (n3 > 0 && n3 < n2) {
                this.burstStringInto(container, string.substring(0, n3), n);
                this.burstStringInto(container, string.substring(n3 + 1), n);
                return;
            }
        }
        JLabel jLabel = new JLabel(string, 2);
        jLabel.setName("OptionPane.label");
        this.configureMessageLabel(jLabel);
        container.add(jLabel);
    }

    protected Container createSeparator() {
        return null;
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        Border border = (Border)DefaultLookup.get(this.optionPane, this, "OptionPane.buttonAreaBorder");
        jPanel.setName("OptionPane.buttonArea");
        if (border != null) {
            jPanel.setBorder(border);
        }
        jPanel.setLayout(new ButtonAreaLayout(DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.sameSizeButtons", true), DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonPadding", 6), DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonOrientation", 0), DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.isYesLast", false)));
        this.addButtonComponents(jPanel, this.getButtons(), this.getInitialValueIndex());
        return jPanel;
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            for (int i = 0; i < n2; ++i) {
                JButton jButton;
                Component component;
                Object object = objectArray[i];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof ButtonFactory ? ((ButtonFactory)object).createButton() : (object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString()));
                    jButton.setName("OptionPane.button");
                    jButton.setMultiClickThreshhold(DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonClickThreshhold", 0));
                    this.configureButton(jButton);
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(i);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[i] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (i != n) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        JButton jButton;
                        JRootPane jRootPane;
                        if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && (jRootPane = SwingUtilities.getRootPane(jButton = (JButton)hierarchyEvent.getComponent())) != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }
                });
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllWidths(bl && bl2);
            if (DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.setButtonMargin", true) && bl && bl2) {
                int n4 = n2 <= 2 ? 8 : 4;
                for (int i = 0; i < n2; ++i) {
                    JButton jButton = jButtonArray[i];
                    jButton.setMargin(new Insets(2, n4, 2, n4));
                }
            }
        }
    }

    protected ActionListener createButtonActionListener(int n) {
        return new ButtonActionListener(n);
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                int n = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                int n2 = DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonMinimumWidth", -1);
                Object[] objectArray2 = n == 0 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.yesIcon"), n2), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.noIcon"), n2)} : (n == 1 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.yesIcon"), n2), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.noIcon"), n2), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.cancelIcon"), n2)} : (n == 2 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.okIcon"), n2), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.cancelIcon"), n2)} : new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.okIcon"), n2)}));
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    private int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIManager.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                return 0;
            }
            if (object != null) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!objectArray[i].equals(object)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    @Override
    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane jRootPane;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (jRootPane = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                jRootPane.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    @Override
    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    private void configureMessageLabel(JLabel jLabel) {
        Font font;
        Color color = (Color)DefaultLookup.get(this.optionPane, this, "OptionPane.messageForeground");
        if (color != null) {
            jLabel.setForeground(color);
        }
        if ((font = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.messageFont")) != null) {
            jLabel.setFont(font);
        }
    }

    private void configureButton(JButton jButton) {
        Font font = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    static {
        if (newline == null) {
            newline = "\n";
        }
    }

    private static class ButtonFactory {
        private String text;
        private int mnemonic;
        private Icon icon;
        private int minimumWidth = -1;

        ButtonFactory(String string, int n, Icon icon, int n2) {
            this.text = string;
            this.mnemonic = n;
            this.icon = icon;
            this.minimumWidth = n2;
        }

        JButton createButton() {
            JButton jButton = this.minimumWidth > 0 ? new ConstrainedButton(this.text, this.minimumWidth) : new JButton(this.text);
            if (this.icon != null) {
                jButton.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                jButton.setMnemonic(this.mnemonic);
            }
            return jButton;
        }

        private static class ConstrainedButton
        extends JButton {
            int minimumWidth;

            ConstrainedButton(String string, int n) {
                super(string);
                this.minimumWidth = n;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = Math.max(dimension.width, this.minimumWidth);
                return dimension;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, this.minimumWidth);
                return dimension;
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CLOSE = "close";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getName() == CLOSE) {
                JOptionPane jOptionPane = (JOptionPane)actionEvent.getSource();
                jOptionPane.setValue(-1);
            }
        }
    }

    private static class MultiplexingTextField
    extends JTextField {
        private KeyStroke[] strokes;

        MultiplexingTextField(int n) {
            super(n);
        }

        void setKeyStrokes(KeyStroke[] keyStrokeArray) {
            this.strokes = keyStrokeArray;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            if (bl2 && n != 2) {
                for (int i = this.strokes.length - 1; i >= 0; --i) {
                    if (!this.strokes[i].equals(keyStroke)) continue;
                    return false;
                }
            }
            return bl2;
        }
    }

    private class Handler
    implements ActionListener,
    MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicOptionPaneUI.this.optionPane.setInputValue(((JTextField)actionEvent.getSource()).getText());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                BasicOptionPaneUI.this.optionPane.setInputValue(jList.getModel().getElementAt(n));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicOptionPaneUI.this.optionPane) {
                Object object;
                if ("ancestor" == propertyChangeEvent.getPropertyName()) {
                    object = (JOptionPane)propertyChangeEvent.getSource();
                    boolean bl = propertyChangeEvent.getOldValue() == null;
                    switch (((JOptionPane)object).getMessageType()) {
                        case -1: {
                            if (!bl) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.informationSound");
                            break;
                        }
                        case 3: {
                            if (!bl) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.questionSound");
                            break;
                        }
                        case 1: {
                            if (!bl) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.informationSound");
                            break;
                        }
                        case 2: {
                            if (!bl) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.warningSound");
                            break;
                        }
                        case 0: {
                            if (!bl) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.errorSound");
                            break;
                        }
                        default: {
                            System.err.println("Undefined JOptionPane type: " + ((JOptionPane)object).getMessageType());
                        }
                    }
                }
                if ((object = propertyChangeEvent.getPropertyName()) == "options" || object == "initialValue" || object == "icon" || object == "messageType" || object == "optionType" || object == "message" || object == "selectionValues" || object == "initialSelectionValue" || object == "wantsInput") {
                    BasicOptionPaneUI.this.uninstallComponents();
                    BasicOptionPaneUI.this.installComponents();
                    BasicOptionPaneUI.this.optionPane.validate();
                } else if (object == "componentOrientation") {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JOptionPane jOptionPane = (JOptionPane)propertyChangeEvent.getSource();
                    if (componentOrientation != propertyChangeEvent.getOldValue()) {
                        jOptionPane.applyComponentOrientation(componentOrientation);
                    }
                }
            }
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int n) {
            this.buttonIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicOptionPaneUI.this.optionPane != null) {
                int n = BasicOptionPaneUI.this.optionPane.getOptionType();
                Object[] objectArray = BasicOptionPaneUI.this.optionPane.getOptions();
                if (BasicOptionPaneUI.this.inputComponent != null && (objectArray != null || n == -1 || (n == 0 || n == 1 || n == 2) && this.buttonIndex == 0)) {
                    BasicOptionPaneUI.this.resetInputValue();
                }
                if (objectArray == null) {
                    if (n == 2 && this.buttonIndex == 1) {
                        BasicOptionPaneUI.this.optionPane.setValue(2);
                    } else {
                        BasicOptionPaneUI.this.optionPane.setValue(this.buttonIndex);
                    }
                } else {
                    BasicOptionPaneUI.this.optionPane.setValue(objectArray[this.buttonIndex]);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicOptionPaneUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllWidths;
        protected int padding;
        protected boolean centersChildren;
        private int orientation;
        private boolean reverseButtons;
        private boolean useOrientation;

        public ButtonAreaLayout(boolean bl, int n) {
            this.syncAllWidths = bl;
            this.padding = n;
            this.centersChildren = true;
            this.useOrientation = false;
        }

        ButtonAreaLayout(boolean bl, int n, int n2, boolean bl2) {
            this(bl, n);
            this.useOrientation = true;
            this.orientation = n2;
            this.reverseButtons = bl2;
        }

        public void setSyncAllWidths(boolean bl) {
            this.syncAllWidths = bl;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
            this.useOrientation = false;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        private int getOrientation(Container container) {
            if (!this.useOrientation) {
                return 0;
            }
            if (container.getComponentOrientation().isLeftToRight()) {
                return this.orientation;
            }
            switch (this.orientation) {
                case 2: {
                    return 4;
                }
                case 4: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            return 2;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n;
                int n2 = componentArray.length;
                Insets insets = container.getInsets();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                boolean bl = container.getComponentOrientation().isLeftToRight();
                boolean bl2 = bl ? this.reverseButtons : !this.reverseButtons;
                for (n = 0; n < n2; ++n) {
                    Dimension dimension = componentArray[n].getPreferredSize();
                    n3 = Math.max(n3, dimension.width);
                    n4 = Math.max(n4, dimension.height);
                    n5 += dimension.width;
                }
                if (this.getSyncAllWidths()) {
                    n5 = n3 * n2;
                }
                n5 += (n2 - 1) * this.padding;
                switch (this.getOrientation(container)) {
                    case 2: {
                        n6 = insets.left;
                        break;
                    }
                    case 4: {
                        n6 = container.getWidth() - insets.right - n5;
                        break;
                    }
                    case 0: {
                        if (this.getCentersChildren() || n2 < 2) {
                            n6 = (container.getWidth() - n5) / 2;
                            break;
                        }
                        n6 = insets.left;
                        n7 = this.getSyncAllWidths() ? (container.getWidth() - insets.left - insets.right - n5) / (n2 - 1) + n3 : (container.getWidth() - insets.left - insets.right - n5) / (n2 - 1);
                    }
                }
                for (n = 0; n < n2; ++n) {
                    int n8 = bl2 ? n2 - n - 1 : n;
                    Dimension dimension = componentArray[n8].getPreferredSize();
                    if (this.getSyncAllWidths()) {
                        componentArray[n8].setBounds(n6, insets.top, n3, n4);
                    } else {
                        componentArray[n8].setBounds(n6, insets.top, dimension.width, dimension.height);
                    }
                    if (n7 != 0) {
                        n6 += n7;
                        continue;
                    }
                    n6 += componentArray[n8].getWidth() + this.padding;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = insets.top + insets.bottom;
                int n4 = insets.left + insets.right;
                if (this.syncAllWidths) {
                    int n5 = 0;
                    for (int i = 0; i < n; ++i) {
                        Dimension dimension = componentArray[i].getPreferredSize();
                        n2 = Math.max(n2, dimension.height);
                        n5 = Math.max(n5, dimension.width);
                    }
                    return new Dimension(n4 + n5 * n + (n - 1) * this.padding, n3 + n2);
                }
                int n6 = 0;
                for (int i = 0; i < n; ++i) {
                    Dimension dimension = componentArray[i].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n6 += dimension.width;
                }
                return new Dimension(n4 + (n6 += (n - 1) * this.padding), n3 + n2);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }
}

