/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentAccessor {
    private static Class componentClass;
    private static Field fieldX;
    private static Field fieldY;
    private static Field fieldWidth;
    private static Field fieldHeight;
    private static Method methodGetParentNoClientCode;
    private static Method methodGetFontNoClientCode;
    private static Method methodProcessEvent;
    private static Method methodEnableEvents;
    private static Field fieldParent;
    private static Field fieldBackground;
    private static Field fieldForeground;
    private static Field fieldFont;
    private static Field fieldPacked;
    private static Field fieldIgnoreRepaint;
    private static Field fieldPeer;
    private static Field fieldVisible;
    private static Method methodIsEnabledImpl;
    private static Method methodGetCursorNoClientCode;
    private static Method methodLocationNoClientCode;
    private static final Logger log;

    private ComponentAccessor() {
    }

    public static void setX(Component component, int n) {
        try {
            fieldX.setInt(component, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static void setY(Component component, int n) {
        try {
            fieldY.setInt(component, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static void setWidth(Component component, int n) {
        try {
            fieldWidth.setInt(component, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static void setHeight(Component component, int n) {
        try {
            fieldHeight.setInt(component, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static void setBounds(Component component, int n, int n2, int n3, int n4) {
        try {
            fieldX.setInt(component, n);
            fieldY.setInt(component, n2);
            fieldWidth.setInt(component, n3);
            fieldHeight.setInt(component, n4);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static int getX(Component component) {
        try {
            return fieldX.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return 0;
        }
    }

    public static int getY(Component component) {
        try {
            return fieldY.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return 0;
        }
    }

    public static int getWidth(Component component) {
        try {
            return fieldWidth.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return 0;
        }
    }

    public static int getHeight(Component component) {
        try {
            return fieldHeight.getInt(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return 0;
        }
    }

    public static boolean getIsPacked(Component component) {
        try {
            return fieldPacked.getBoolean(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return false;
        }
    }

    public static Container getParent_NoClientCode(Component component) {
        Container container = null;
        try {
            container = (Container)methodGetParentNoClientCode.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
        return container;
    }

    public static Font getFont_NoClientCode(Component component) {
        Font font = null;
        try {
            font = (Font)methodGetFontNoClientCode.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
        return font;
    }

    public static void processEvent(Component component, AWTEvent aWTEvent) {
        Object var2_2 = null;
        try {
            Object[] objectArray = new Object[]{aWTEvent};
            methodProcessEvent.invoke(component, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
    }

    public static void enableEvents(Component component, long l) {
        try {
            Object[] objectArray = new Object[]{l};
            methodEnableEvents.invoke(component, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
    }

    public static void setParent(Component component, Container container) {
        try {
            fieldParent.set(component, container);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static Color getForeground(Component component) {
        Color color = null;
        try {
            color = (Color)fieldForeground.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        return color;
    }

    public static Color getBackground(Component component) {
        Color color = null;
        try {
            color = (Color)fieldBackground.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        return color;
    }

    public static void setBackground(Component component, Color color) {
        try {
            fieldBackground.set(component, color);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static Font getFont(Component component) {
        Font font = null;
        try {
            font = (Font)fieldFont.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        return font;
    }

    public static ComponentPeer getPeer(Component component) {
        ComponentPeer componentPeer = null;
        try {
            componentPeer = (ComponentPeer)fieldPeer.get(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        return componentPeer;
    }

    public static void setPeer(Component component, ComponentPeer componentPeer) {
        try {
            fieldPeer.set(component, componentPeer);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
    }

    public static boolean getIgnoreRepaint(Component component) {
        try {
            return fieldIgnoreRepaint.getBoolean(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return false;
        }
    }

    public static boolean getVisible(Component component) {
        try {
            return fieldVisible.getBoolean(component);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
            return false;
        }
    }

    public static boolean isEnabledImpl(Component component) {
        boolean bl = true;
        try {
            bl = (Boolean)methodIsEnabledImpl.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
        return bl;
    }

    public static Cursor getCursor_NoClientCode(Component component) {
        Cursor cursor = null;
        try {
            cursor = (Cursor)methodGetCursorNoClientCode.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
        return cursor;
    }

    public static Point getLocation_NoClientCode(Component component) {
        Point point = null;
        try {
            point = (Point)methodLocationNoClientCode.invoke(component, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Component object", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.log(Level.FINE, "Unable to invoke on the Component object", invocationTargetException);
        }
        return point;
    }

    static {
        log = Logger.getLogger("sun.awt.ComponentAccessor");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    componentClass = Class.forName("java.awt.Component");
                    fieldX = componentClass.getDeclaredField("x");
                    fieldX.setAccessible(true);
                    fieldY = componentClass.getDeclaredField("y");
                    fieldY.setAccessible(true);
                    fieldWidth = componentClass.getDeclaredField("width");
                    fieldWidth.setAccessible(true);
                    fieldHeight = componentClass.getDeclaredField("height");
                    fieldHeight.setAccessible(true);
                    fieldForeground = componentClass.getDeclaredField("foreground");
                    fieldForeground.setAccessible(true);
                    fieldBackground = componentClass.getDeclaredField("background");
                    fieldBackground.setAccessible(true);
                    fieldFont = componentClass.getDeclaredField("font");
                    fieldFont.setAccessible(true);
                    methodGetParentNoClientCode = componentClass.getDeclaredMethod("getParent_NoClientCode", null);
                    methodGetParentNoClientCode.setAccessible(true);
                    methodGetFontNoClientCode = componentClass.getDeclaredMethod("getFont_NoClientCode", null);
                    methodGetFontNoClientCode.setAccessible(true);
                    Class[] classArray = new Class[]{AWTEvent.class};
                    methodProcessEvent = componentClass.getDeclaredMethod("processEvent", classArray);
                    methodProcessEvent.setAccessible(true);
                    Class[] classArray2 = new Class[]{Long.TYPE};
                    methodEnableEvents = componentClass.getDeclaredMethod("enableEvents", classArray2);
                    methodEnableEvents.setAccessible(true);
                    fieldParent = componentClass.getDeclaredField("parent");
                    fieldParent.setAccessible(true);
                    fieldPacked = componentClass.getDeclaredField("isPacked");
                    fieldPacked.setAccessible(true);
                    fieldIgnoreRepaint = componentClass.getDeclaredField("ignoreRepaint");
                    fieldIgnoreRepaint.setAccessible(true);
                    fieldPeer = componentClass.getDeclaredField("peer");
                    fieldPeer.setAccessible(true);
                    fieldVisible = componentClass.getDeclaredField("visible");
                    fieldVisible.setAccessible(true);
                    methodIsEnabledImpl = componentClass.getDeclaredMethod("isEnabledImpl", null);
                    methodIsEnabledImpl.setAccessible(true);
                    methodGetCursorNoClientCode = componentClass.getDeclaredMethod("getCursor_NoClientCode", null);
                    methodGetCursorNoClientCode.setAccessible(true);
                    methodLocationNoClientCode = componentClass.getDeclaredMethod("location_NoClientCode", null);
                    methodLocationNoClientCode.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    log.log(Level.FINE, "Unable to initialize ComponentAccessor", noSuchFieldException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.log(Level.FINE, "Unable to initialize ComponentAccessor", classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.log(Level.FINE, "Unable to initialize ComponentAccessor", noSuchMethodException);
                }
                return null;
            }
        });
    }
}

