/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsEnvironment;
import java.awt.peer.FontPeer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Locale;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontConfiguration;
import sun.awt.FontDescriptor;
import sun.awt.NativeLibLoader;
import sun.java2d.FontSupport;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected FontConfiguration fontConfig;
    protected FontDescriptor defaultFont;
    protected String familyName;
    private Object[] fontCache;
    protected static int FONTCACHESIZE;
    protected static int FONTCACHEMASK;
    protected static String osVersion;

    public PlatformFont(String string, int n) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            this.fontConfig = ((FontSupport)((Object)graphicsEnvironment)).getFontConfiguration();
        }
        if (this.fontConfig == null) {
            return;
        }
        this.familyName = string.toLowerCase(Locale.ENGLISH);
        if (!FontConfiguration.isLogicalFontFamilyName(this.familyName)) {
            this.familyName = this.fontConfig.getFallbackFamilyName(this.familyName, "sansserif");
        }
        this.componentFonts = this.fontConfig.getFontDescriptors(this.familyName, n);
        char c = this.getMissingGlyphCharacter();
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        for (int i = 0; i < this.componentFonts.length; ++i) {
            if (this.componentFonts[i].isExcluded(c) || !this.componentFonts[i].encoder.canEncode(c)) continue;
            this.defaultFont = this.componentFonts[i];
            this.defaultChar = c;
            break;
        }
    }

    protected abstract char getMissingGlyphCharacter();

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), true);
    }

    public CharsetString[] makeMultiCharsetString(String string, boolean bl) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), bl);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        return this.makeMultiCharsetString(cArray, n, n2, true);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2, boolean bl) {
        CharsetString[] charsetStringArray;
        int n3;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector<CharsetString> vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        boolean bl2 = false;
        FontDescriptor fontDescriptor = this.defaultFont;
        for (n3 = 0; n3 < this.componentFonts.length; ++n3) {
            if (this.componentFonts[n3].isExcluded(cArray[n]) || !this.componentFonts[n3].encoder.canEncode(cArray[n])) continue;
            fontDescriptor = this.componentFonts[n3];
            c = cArray[n];
            bl2 = true;
            break;
        }
        if (!bl && !bl2) {
            return null;
        }
        cArray2[0] = c;
        n3 = 0;
        for (int i = 1; i < n2; ++i) {
            char c2 = cArray[n + i];
            FontDescriptor fontDescriptor2 = this.defaultFont;
            c = this.defaultChar;
            bl2 = false;
            for (int j = 0; j < this.componentFonts.length; ++j) {
                if (this.componentFonts[j].isExcluded(c2) || !this.componentFonts[j].encoder.canEncode(c2)) continue;
                fontDescriptor2 = this.componentFonts[j];
                c = c2;
                bl2 = true;
                break;
            }
            if (!bl && !bl2) {
                return null;
            }
            cArray2[i] = c;
            if (fontDescriptor == fontDescriptor2) continue;
            if (vector == null) {
                vector = new Vector<CharsetString>(3);
            }
            vector.addElement(new CharsetString(cArray2, n3, i - n3, fontDescriptor));
            fontDescriptor = fontDescriptor2;
            fontDescriptor2 = this.defaultFont;
            n3 = i;
        }
        CharsetString charsetString = new CharsetString(cArray2, n3, n2 - n3, fontDescriptor);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{charsetString};
        } else {
            vector.addElement(charsetString);
            charsetStringArray = new CharsetString[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                charsetStringArray[i] = (CharsetString)vector.elementAt(i);
            }
        }
        return charsetStringArray;
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.fontConfig != null;
    }

    public Object[] makeConvertedMultiFontString(String string) {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length());
    }

    public Object[] makeConvertedMultiFontChars(char[] cArray, int n, int n2) {
        int n3;
        Object[] objectArray = new Object[2];
        byte[] byArray = null;
        int n4 = 0;
        int n5 = 0;
        FontDescriptor fontDescriptor = null;
        FontDescriptor fontDescriptor2 = null;
        int n6 = n + n2;
        if (n < 0 || n6 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 >= n6) {
            return null;
        }
        for (n3 = n; n3 < n6; ++n3) {
            Object[] objectArray2;
            char c = cArray[n3];
            int n7 = c & FONTCACHEMASK;
            PlatformFontCache platformFontCache = (PlatformFontCache)this.getFontCache()[n7];
            if (platformFontCache == null || platformFontCache.uniChar != c) {
                fontDescriptor = this.defaultFont;
                c = this.defaultChar;
                char c2 = cArray[n3];
                for (FontDescriptor fontDescriptor3 : this.componentFonts) {
                    fontDescriptor3.encoder.reset();
                    if (fontDescriptor3.isExcluded(c2) || !fontDescriptor3.encoder.canEncode(c2)) continue;
                    fontDescriptor = fontDescriptor3;
                    c = c2;
                    break;
                }
                try {
                    char[] cArray2 = new char[]{c};
                    platformFontCache = new PlatformFontCache();
                    if (fontDescriptor.useUnicode()) {
                        if (FontDescriptor.isLE) {
                            platformFontCache.bb.put((byte)(cArray2[0] & 0xFF));
                            platformFontCache.bb.put((byte)(cArray2[0] >> 8));
                        } else {
                            platformFontCache.bb.put((byte)(cArray2[0] >> 8));
                            platformFontCache.bb.put((byte)(cArray2[0] & 0xFF));
                        }
                    } else {
                        fontDescriptor.encoder.encode(CharBuffer.wrap(cArray2), platformFontCache.bb, true);
                    }
                    platformFontCache.fontDescriptor = fontDescriptor;
                    platformFontCache.uniChar = cArray[n3];
                    this.getFontCache()[n7] = platformFontCache;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    exception.printStackTrace();
                    return null;
                }
            }
            if (fontDescriptor2 != platformFontCache.fontDescriptor) {
                if (fontDescriptor2 != null) {
                    objectArray[n5++] = fontDescriptor2;
                    objectArray[n5++] = byArray;
                    if (byArray != null) {
                        byArray[0] = (byte)((n4 -= 4) >> 24);
                        byArray[1] = (byte)(n4 >> 16);
                        byArray[2] = (byte)(n4 >> 8);
                        byArray[3] = (byte)n4;
                    }
                    if (n5 >= objectArray.length) {
                        objectArray2 = new Object[objectArray.length * 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray = objectArray2;
                    }
                }
                byArray = platformFontCache.fontDescriptor.useUnicode() ? new byte[(n6 - n3 + 1) * (int)platformFontCache.fontDescriptor.unicodeEncoder.maxBytesPerChar() + 4] : new byte[(n6 - n3 + 1) * (int)platformFontCache.fontDescriptor.encoder.maxBytesPerChar() + 4];
                n4 = 4;
                fontDescriptor2 = platformFontCache.fontDescriptor;
            }
            objectArray2 = platformFontCache.bb.array();
            int n8 = platformFontCache.bb.position();
            if (n8 == 1) {
                byArray[n4++] = objectArray2[0];
                continue;
            }
            if (n8 == 2) {
                byArray[n4++] = objectArray2[0];
                byArray[n4++] = objectArray2[1];
                continue;
            }
            if (n8 == 3) {
                byArray[n4++] = objectArray2[0];
                byArray[n4++] = objectArray2[1];
                byArray[n4++] = objectArray2[2];
                continue;
            }
            if (n8 != 4) continue;
            byArray[n4++] = objectArray2[0];
            byArray[n4++] = objectArray2[1];
            byArray[n4++] = objectArray2[2];
            byArray[n4++] = objectArray2[3];
        }
        objectArray[n5++] = fontDescriptor2;
        objectArray[n5] = byArray;
        if (byArray != null) {
            byArray[0] = (byte)((n4 -= 4) >> 24);
            byArray[1] = (byte)(n4 >> 16);
            byArray[2] = (byte)(n4 >> 8);
            byArray[3] = (byte)n4;
        }
        return objectArray;
    }

    protected final Object[] getFontCache() {
        if (this.fontCache == null) {
            this.fontCache = new Object[FONTCACHESIZE];
        }
        return this.fontCache;
    }

    private static native void initIDs();

    static {
        NativeLibLoader.loadLibraries();
        PlatformFont.initIDs();
        FONTCACHESIZE = 256;
        FONTCACHEMASK = FONTCACHESIZE - 1;
    }

    class PlatformFontCache {
        char uniChar;
        FontDescriptor fontDescriptor;
        ByteBuffer bb = ByteBuffer.allocate(4);

        PlatformFontCache() {
        }
    }
}

