/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pisces.PiscesCache;

public class PiscesTileGenerator
implements AATileGenerator {
    public static final int TILE_SIZE = 32;
    PiscesCache cache;
    int x;
    int y;
    int maxalpha;
    byte[] alphaMap;
    static int prevMaxAlpha;
    static byte[] prevAlphaMap;

    public PiscesTileGenerator(PiscesCache piscesCache, int n) {
        this.cache = piscesCache;
        this.x = piscesCache.bboxX0;
        this.y = piscesCache.bboxY0;
        this.alphaMap = PiscesTileGenerator.getAlphaMap(n);
        this.maxalpha = n;
    }

    public static synchronized byte[] getAlphaMap(int n) {
        if (n != prevMaxAlpha) {
            int n2;
            prevAlphaMap = new byte[n + 300];
            int n3 = n >> 2;
            for (n2 = 0; n2 <= n; ++n2) {
                PiscesTileGenerator.prevAlphaMap[n2] = (byte)((n2 * 255 + n3) / n);
            }
            for (n2 = n; n2 < prevAlphaMap.length; ++n2) {
                PiscesTileGenerator.prevAlphaMap[n2] = -1;
            }
            prevMaxAlpha = n;
        }
        return prevAlphaMap;
    }

    public void getBbox(int[] nArray) {
        nArray[0] = this.cache.bboxX0;
        nArray[1] = this.cache.bboxY0;
        nArray[2] = this.cache.bboxX1;
        nArray[3] = this.cache.bboxY1;
    }

    @Override
    public int getTileWidth() {
        return 32;
    }

    @Override
    public int getTileHeight() {
        return 32;
    }

    @Override
    public int getTypicalAlpha() {
        return 128;
    }

    @Override
    public void nextTile() {
        if ((this.x += 32) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += 32;
        }
    }

    @Override
    public void getAlpha(byte[] byArray, int n, int n2) {
        int n3 = this.x;
        int n4 = n3 + 32;
        int n5 = this.y;
        int n6 = n5 + 32;
        if (n4 > this.cache.bboxX1) {
            n4 = this.cache.bboxX1;
        }
        if (n6 > this.cache.bboxY1) {
            n6 = this.cache.bboxY1;
        }
        n6 -= this.cache.bboxY0;
        int n7 = n;
        for (int i = n5 -= this.cache.bboxY0; i < n6; ++i) {
            int n8;
            int n9 = this.cache.rowOffsetsRLE[i];
            int n10 = this.cache.minTouched[i];
            if (n10 > n4) {
                n10 = n4;
            }
            if (n10 > n3) {
                for (n8 = n3; n8 < n10; ++n8) {
                    byArray[n7++] = 0;
                }
            }
            while (n10 < n4) {
                int n11 = 0;
                try {
                    n8 = this.alphaMap[this.cache.rowAARLE[n9] & 0xFF];
                    n11 = this.cache.rowAARLE[n9 + 1] & 0xFF;
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("maxalpha = " + this.maxalpha);
                    System.out.println("tile[" + n3 + ", " + n5 + " => " + n4 + ", " + n6 + "]");
                    System.out.println("cx = " + n10 + ", cy = " + i);
                    System.out.println("idx = " + n7 + ", pos = " + n9);
                    System.out.println("len = " + n11);
                    this.cache.print(System.out);
                    runtimeException.printStackTrace();
                    System.exit(1);
                    return;
                }
                if (n11 == 0) break;
                int n12 = n10;
                int n13 = n10 += n11;
                if (n12 < n3) {
                    n12 = n3;
                }
                if (n13 > n4) {
                    n13 = n4;
                }
                n11 = n13 - n12;
                while (--n11 >= 0) {
                    try {
                        byArray[n7++] = n8;
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("maxalpha = " + this.maxalpha);
                        System.out.println("tile[" + n3 + ", " + n5 + " => " + n4 + ", " + n6 + "]");
                        System.out.println("cx = " + n10 + ", cy = " + i);
                        System.out.println("idx = " + n7 + ", pos = " + n9);
                        System.out.println("rx0 = " + n12 + ", rx1 = " + n13);
                        System.out.println("len = " + n11);
                        this.cache.print(System.out);
                        runtimeException.printStackTrace();
                        System.exit(1);
                        return;
                    }
                }
                n9 += 2;
            }
            if (n10 < n3) {
                n10 = n3;
            }
            while (n10 < n4) {
                byArray[n7++] = 0;
                ++n10;
            }
            n7 += n2 - (n4 - n3);
        }
        this.nextTile();
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.substring(0, n2);
    }

    @Override
    public void dispose() {
    }
}

