/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.StandardWatchEventKind;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.List;
import sun.nio.fs.AbstractWatchService;

abstract class AbstractWatchKey
extends WatchKey {
    static final int MAX_EVENT_LIST_SIZE = 512;
    static final Event<Void> OVERFLOW_EVENT = new Event<Object>(StandardWatchEventKind.OVERFLOW, null);
    private final AbstractWatchService watcher;
    private State state;
    private List<WatchEvent<?>> events;

    protected AbstractWatchKey(AbstractWatchService abstractWatchService) {
        this.watcher = abstractWatchService;
        this.state = State.READY;
        this.events = new ArrayList();
    }

    final AbstractWatchService watcher() {
        return this.watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signal() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.READY) {
                this.state = State.SIGNALLED;
                this.watcher.enqueueKey(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signalEvent(WatchEvent.Kind<?> kind, Object object) {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            int n = this.events.size();
            if (n > 1) {
                boolean bl;
                WatchEvent<?> watchEvent;
                if (n >= 512) {
                    kind = StandardWatchEventKind.OVERFLOW;
                    object = null;
                }
                if (kind == (watchEvent = this.events.get(n - 1)).kind() && (bl = object == null ? watchEvent.context() == null : object.equals(watchEvent.context()))) {
                    ((Event)watchEvent).increment();
                    return;
                }
            }
            this.events.add(new Event<Object>(kind, object));
            this.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<WatchEvent<?>> pollEvents() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            List<WatchEvent<?>> list = this.events;
            this.events = new ArrayList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean reset() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.SIGNALLED && this.isValid()) {
                if (this.events.isEmpty()) {
                    this.state = State.READY;
                } else {
                    this.watcher.enqueueKey(this);
                }
            }
            return this.isValid();
        }
    }

    private static class Event<T>
    extends WatchEvent<T> {
        private final WatchEvent.Kind<T> kind;
        private final T context;
        private int count;

        Event(WatchEvent.Kind<T> kind, T t) {
            this.kind = kind;
            this.context = t;
            this.count = 1;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this.kind;
        }

        @Override
        public T context() {
            return this.context;
        }

        @Override
        public int count() {
            return this.count;
        }

        void increment() {
            ++this.count;
        }
    }

    private static enum State {
        READY,
        SIGNALLED;

    }
}

