/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class FileChooserDemo
extends JPanel
implements ActionListener {
    private static JFrame frame;
    private final Vector<SupportedLaF> supportedLaFs = new Vector();
    private JButton showButton;
    private JCheckBox showAllFilesFilterCheckBox;
    private JCheckBox showImageFilesFilterCheckBox;
    private JCheckBox showFullDescriptionCheckBox;
    private JCheckBox useFileViewCheckBox;
    private JCheckBox useFileSystemViewCheckBox;
    private JCheckBox accessoryCheckBox;
    private JCheckBox setHiddenCheckBox;
    private JCheckBox useEmbedInWizardCheckBox;
    private JCheckBox useControlsCheckBox;
    private JCheckBox enableDragCheckBox;
    private JRadioButton singleSelectionRadioButton;
    private JRadioButton multiSelectionRadioButton;
    private JRadioButton openRadioButton;
    private JRadioButton saveRadioButton;
    private JRadioButton customButton;
    private JComboBox lafComboBox;
    private JRadioButton justFilesRadioButton;
    private JRadioButton justDirectoriesRadioButton;
    private JRadioButton bothFilesAndDirectoriesRadioButton;
    private JTextField customField;
    private final ExampleFileView fileView;
    private final ExampleFileSystemView fileSystemView;
    private static final Dimension hpad10;
    private static final Dimension vpad20;
    private static final Dimension vpad7;
    private static final Dimension vpad4;
    private static final Insets insets;
    private final FilePreviewer previewer;
    private final JFileChooser chooser;

    public FileChooserDemo() {
        Object object;
        Object object2;
        Serializable serializable;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            try {
                serializable = Class.forName(lookAndFeelInfo.getClassName());
                object2 = (LookAndFeel)((Class)serializable).newInstance();
                if (!((LookAndFeel)object2).isSupportedLookAndFeel()) continue;
                object = lookAndFeelInfo.getName();
                this.supportedLaFs.add(new SupportedLaF((String)object, (LookAndFeel)object2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.chooser = new JFileChooser();
        this.previewer = new FilePreviewer(this.chooser);
        this.fileView = new ExampleFileView();
        this.fileView.putIcon("jpg", new ImageIcon(this.getClass().getResource("/resources/images/jpgIcon.jpg")));
        this.fileView.putIcon("gif", new ImageIcon(this.getClass().getResource("/resources/images/gifIcon.gif")));
        this.fileSystemView = new ExampleFileSystemView();
        OptionListener optionListener = new OptionListener();
        this.openRadioButton = new JRadioButton("Open");
        this.openRadioButton.setSelected(true);
        this.openRadioButton.addActionListener(optionListener);
        this.saveRadioButton = new JRadioButton("Save");
        this.saveRadioButton.addActionListener(optionListener);
        this.customButton = new JRadioButton("Custom");
        this.customButton.addActionListener(optionListener);
        this.customField = new JTextField(8){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width, this.getPreferredSize().height);
            }
        };
        this.customField.setText("Doit");
        this.customField.setAlignmentY(0.0f);
        this.customField.setEnabled(false);
        this.customField.addActionListener(optionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.openRadioButton);
        buttonGroup.add(this.saveRadioButton);
        buttonGroup.add(this.customButton);
        this.showAllFilesFilterCheckBox = new JCheckBox("Show \"All Files\" Filter");
        this.showAllFilesFilterCheckBox.addActionListener(optionListener);
        this.showAllFilesFilterCheckBox.setSelected(true);
        this.showImageFilesFilterCheckBox = new JCheckBox("Show JPG and GIF Filters");
        this.showImageFilesFilterCheckBox.addActionListener(optionListener);
        this.showImageFilesFilterCheckBox.setSelected(false);
        this.accessoryCheckBox = new JCheckBox("Show Preview");
        this.accessoryCheckBox.addActionListener(optionListener);
        this.accessoryCheckBox.setSelected(false);
        this.setHiddenCheckBox = new JCheckBox("Show Hidden Files");
        this.setHiddenCheckBox.addActionListener(optionListener);
        this.showFullDescriptionCheckBox = new JCheckBox("With File Extensions");
        this.showFullDescriptionCheckBox.addActionListener(optionListener);
        this.showFullDescriptionCheckBox.setSelected(true);
        this.showFullDescriptionCheckBox.setEnabled(false);
        this.useFileViewCheckBox = new JCheckBox("Use FileView");
        this.useFileViewCheckBox.addActionListener(optionListener);
        this.useFileViewCheckBox.setSelected(false);
        this.useFileSystemViewCheckBox = new JCheckBox("Use FileSystemView", false);
        this.useFileSystemViewCheckBox.addActionListener(optionListener);
        this.useEmbedInWizardCheckBox = new JCheckBox("Embed in Wizard");
        this.useEmbedInWizardCheckBox.addActionListener(optionListener);
        this.useEmbedInWizardCheckBox.setSelected(false);
        this.useControlsCheckBox = new JCheckBox("Show Control Buttons");
        this.useControlsCheckBox.addActionListener(optionListener);
        this.useControlsCheckBox.setSelected(true);
        this.enableDragCheckBox = new JCheckBox("Enable Dragging");
        this.enableDragCheckBox.addActionListener(optionListener);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.justFilesRadioButton = new JRadioButton("Just Select Files");
        this.justFilesRadioButton.setSelected(true);
        buttonGroup2.add(this.justFilesRadioButton);
        this.justFilesRadioButton.addActionListener(optionListener);
        this.justDirectoriesRadioButton = new JRadioButton("Just Select Directories");
        buttonGroup2.add(this.justDirectoriesRadioButton);
        this.justDirectoriesRadioButton.addActionListener(optionListener);
        this.bothFilesAndDirectoriesRadioButton = new JRadioButton("Select Files or Directories");
        buttonGroup2.add(this.bothFilesAndDirectoriesRadioButton);
        this.bothFilesAndDirectoriesRadioButton.addActionListener(optionListener);
        this.singleSelectionRadioButton = new JRadioButton("Single Selection", true);
        this.singleSelectionRadioButton.addActionListener(optionListener);
        this.multiSelectionRadioButton = new JRadioButton("Multi Selection");
        this.multiSelectionRadioButton.addActionListener(optionListener);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.singleSelectionRadioButton);
        buttonGroup3.add(this.multiSelectionRadioButton);
        this.showButton = new JButton("Show FileChooser");
        this.showButton.addActionListener(this);
        this.showButton.setMnemonic('s');
        this.lafComboBox = new JComboBox<SupportedLaF>(this.supportedLaFs);
        this.lafComboBox.setEditable(false);
        this.lafComboBox.addActionListener(optionListener);
        serializable = new InsetPanel(insets);
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Dialog Type"));
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        ((Container)serializable).add(Box.createRigidArea(vpad20));
        ((Container)serializable).add(this.openRadioButton);
        ((Container)serializable).add(Box.createRigidArea(vpad7));
        ((Container)serializable).add(this.saveRadioButton);
        ((Container)serializable).add(Box.createRigidArea(vpad7));
        ((Container)serializable).add(this.customButton);
        ((Container)serializable).add(Box.createRigidArea(vpad4));
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
        ((JComponent)object2).setAlignmentX(0.0f);
        ((Container)object2).add(Box.createRigidArea(hpad10));
        ((Container)object2).add(Box.createRigidArea(hpad10));
        ((Container)object2).add(this.customField);
        ((Container)serializable).add((Component)object2);
        ((Container)serializable).add(Box.createRigidArea(vpad20));
        ((Container)serializable).add(Box.createGlue());
        object = new InsetPanel(insets);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Filter Controls"));
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(Box.createRigidArea(vpad20));
        ((Container)object).add(this.showAllFilesFilterCheckBox);
        ((Container)object).add(Box.createRigidArea(vpad7));
        ((Container)object).add(this.showImageFilesFilterCheckBox);
        ((Container)object).add(Box.createRigidArea(vpad4));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(this.showFullDescriptionCheckBox);
        ((Container)object).add(jPanel);
        ((Container)object).add(Box.createRigidArea(vpad20));
        ((Container)object).add(Box.createGlue());
        InsetPanel insetPanel = new InsetPanel(insets);
        insetPanel.setBorder(BorderFactory.createTitledBorder("Display Options"));
        insetPanel.setLayout(new BoxLayout(insetPanel, 1));
        insetPanel.add(Box.createRigidArea(vpad20));
        insetPanel.add(this.setHiddenCheckBox);
        insetPanel.add(Box.createRigidArea(vpad7));
        insetPanel.add(this.useFileViewCheckBox);
        insetPanel.add(Box.createRigidArea(vpad7));
        insetPanel.add(this.useFileSystemViewCheckBox);
        insetPanel.add(Box.createRigidArea(vpad7));
        insetPanel.add(this.accessoryCheckBox);
        insetPanel.add(Box.createRigidArea(vpad7));
        insetPanel.add(this.useEmbedInWizardCheckBox);
        insetPanel.add(Box.createRigidArea(vpad7));
        insetPanel.add(this.useControlsCheckBox);
        insetPanel.add(Box.createRigidArea(vpad7));
        insetPanel.add(this.enableDragCheckBox);
        insetPanel.add(Box.createRigidArea(vpad20));
        insetPanel.add(Box.createGlue());
        InsetPanel insetPanel2 = new InsetPanel(insets);
        insetPanel2.setBorder(BorderFactory.createTitledBorder("File and Directory Options"));
        insetPanel2.setLayout(new BoxLayout(insetPanel2, 1));
        insetPanel2.add(Box.createRigidArea(vpad20));
        insetPanel2.add(this.justFilesRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad7));
        insetPanel2.add(this.justDirectoriesRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad7));
        insetPanel2.add(this.bothFilesAndDirectoriesRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad20));
        insetPanel2.add(this.singleSelectionRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad7));
        insetPanel2.add(this.multiSelectionRadioButton);
        insetPanel2.add(Box.createRigidArea(vpad20));
        insetPanel2.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Look and Feel: "));
        jPanel2.add(this.lafComboBox);
        jPanel2.add(this.showButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.add(Box.createRigidArea(vpad20));
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add((Component)serializable);
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add((Component)object);
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(insetPanel);
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(insetPanel2);
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(Box.createRigidArea(hpad10));
        this.add(jPanel3);
        this.add(Box.createRigidArea(vpad20));
        this.add(jPanel2);
        this.add(Box.createRigidArea(vpad20));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.customButton.isSelected()) {
            this.chooser.setApproveButtonText(this.customField.getText());
        }
        if (this.chooser.isMultiSelectionEnabled()) {
            this.chooser.setSelectedFiles(null);
        } else {
            this.chooser.setSelectedFile(null);
        }
        JComponent jComponent = this.chooser.getAccessory();
        if (jComponent != null) {
            ((FilePreviewer)jComponent).loadImage(null);
        }
        if (this.useEmbedInWizardCheckBox.isSelected()) {
            WizardDialog wizardDialog = new WizardDialog(frame, true);
            wizardDialog.setVisible(true);
            wizardDialog.dispose();
            return;
        }
        int n = this.chooser.showDialog(frame, null);
        if (n == 0) {
            JOptionPane.showMessageDialog(frame, this.getResultString());
        } else if (n == 1) {
            JOptionPane.showMessageDialog(frame, "User cancelled operation. No file was chosen.");
        } else if (n == -1) {
            JOptionPane.showMessageDialog(frame, "An error occured. No file was chosen.");
        } else {
            JOptionPane.showMessageDialog(frame, "Unknown operation occured.");
        }
    }

    private void resetFileFilters(boolean bl, boolean bl2) {
        this.chooser.resetChoosableFileFilters();
        if (bl) {
            FileFilter fileFilter = this.createFileFilter("JPEG Compressed Image Files", bl2, "jpg");
            FileFilter fileFilter2 = this.createFileFilter("GIF Image Files", bl2, "gif");
            FileFilter fileFilter3 = this.createFileFilter("JPEG and GIF Image Files", bl2, "jpg", "gif");
            this.chooser.addChoosableFileFilter(fileFilter3);
            this.chooser.addChoosableFileFilter(fileFilter);
            this.chooser.addChoosableFileFilter(fileFilter2);
        }
    }

    private FileFilter createFileFilter(String string, boolean bl, String ... stringArray) {
        if (bl) {
            string = this.createFileNameFilterDescriptionFromExtensions(string, stringArray);
        }
        return new FileNameExtensionFilter(string, stringArray);
    }

    private String createFileNameFilterDescriptionFromExtensions(String string, String[] stringArray) {
        String string2 = string == null ? "(" : string + " (";
        string2 = string2 + "." + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + ", .";
            string2 = string2 + stringArray[i];
        }
        string2 = string2 + ")";
        return string2;
    }

    private String getResultString() {
        String string;
        String string2 = this.chooser.getFileFilter().getDescription();
        String string3 = null;
        boolean bl = this.chooser.getFileSelectionMode() == 1;
        boolean bl2 = this.chooser.isMultiSelectionEnabled();
        if (bl2) {
            File[] fileArray = this.chooser.getSelectedFiles();
            if (fileArray != null && fileArray.length > 0) {
                string3 = "";
                for (File file : fileArray) {
                    string3 = string3 + "<br>" + file.getPath();
                }
            }
        } else {
            File file = this.chooser.getSelectedFile();
            if (file != null) {
                string3 = "<br>" + file.getPath();
            }
        }
        if (string3 != null) {
            string3 = string3.replace(" ", "&nbsp;");
            string2 = string2.replace(" ", "&nbsp;");
            string = "<html>You chose " + (bl2 ? "these" : "this") + " " + (bl ? (bl2 ? "directories" : "directory") : (bl2 ? "files" : "file")) + ": <code>" + string3 + "</code><br><br>with filter: <br><code>" + string2;
        } else {
            string = "Nothing was chosen";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        FileChooserDemo fileChooserDemo = new FileChooserDemo();
        frame = new JFrame("FileChooserDemo");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add("Center", fileChooserDemo);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        hpad10 = new Dimension(10, 1);
        vpad20 = new Dimension(1, 20);
        vpad7 = new Dimension(1, 7);
        vpad4 = new Dimension(1, 4);
        insets = new Insets(5, 10, 0, 10);
    }

    private static class InsetPanel
    extends JPanel {
        Insets i;

        InsetPanel(Insets insets) {
            this.i = insets;
        }

        @Override
        public Insets getInsets() {
            return this.i;
        }
    }

    private class FilePreviewer
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail = null;

        public FilePreviewer(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(100, 50));
            jFileChooser.addPropertyChangeListener(this);
        }

        public void loadImage(File file) {
            ImageIcon imageIcon;
            this.thumbnail = file == null ? null : ((imageIcon = new ImageIcon(file.getPath())).getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1)) : imageIcon);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "SelectedFileChangedProperty" && this.isShowing()) {
                this.loadImage((File)propertyChangeEvent.getNewValue());
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.thumbnail != null) {
                int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.thumbnail.paintIcon(this, graphics, n, n2);
            }
        }
    }

    private class OptionListener
    implements ActionListener {
        private OptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            boolean bl = false;
            if (jComponent instanceof JToggleButton) {
                bl = ((JToggleButton)jComponent).isSelected();
            }
            if (jComponent == FileChooserDemo.this.openRadioButton) {
                FileChooserDemo.this.chooser.setDialogType(0);
                FileChooserDemo.this.customField.setEnabled(false);
                FileChooserDemo.this.repaint();
            } else if (jComponent == FileChooserDemo.this.useEmbedInWizardCheckBox) {
                FileChooserDemo.this.useControlsCheckBox.setEnabled(!bl);
                FileChooserDemo.this.useControlsCheckBox.setSelected(!bl);
                FileChooserDemo.this.chooser.setControlButtonsAreShown(!bl);
            } else if (jComponent == FileChooserDemo.this.useControlsCheckBox) {
                FileChooserDemo.this.chooser.setControlButtonsAreShown(bl);
            } else if (jComponent == FileChooserDemo.this.enableDragCheckBox) {
                FileChooserDemo.this.chooser.setDragEnabled(bl);
            } else if (jComponent == FileChooserDemo.this.saveRadioButton) {
                FileChooserDemo.this.chooser.setDialogType(1);
                FileChooserDemo.this.customField.setEnabled(false);
                FileChooserDemo.this.repaint();
            } else if (jComponent == FileChooserDemo.this.customButton || jComponent == FileChooserDemo.this.customField) {
                FileChooserDemo.this.customField.setEnabled(true);
                FileChooserDemo.this.chooser.setDialogType(2);
                FileChooserDemo.this.repaint();
            } else if (jComponent == FileChooserDemo.this.showAllFilesFilterCheckBox) {
                FileChooserDemo.this.chooser.setAcceptAllFileFilterUsed(bl);
            } else if (jComponent == FileChooserDemo.this.showImageFilesFilterCheckBox) {
                FileChooserDemo.this.resetFileFilters(bl, FileChooserDemo.this.showFullDescriptionCheckBox.isSelected());
                FileChooserDemo.this.showFullDescriptionCheckBox.setEnabled(bl);
            } else if (jComponent == FileChooserDemo.this.setHiddenCheckBox) {
                FileChooserDemo.this.chooser.setFileHidingEnabled(!bl);
            } else if (jComponent == FileChooserDemo.this.accessoryCheckBox) {
                if (bl) {
                    FileChooserDemo.this.chooser.setAccessory(FileChooserDemo.this.previewer);
                } else {
                    FileChooserDemo.this.chooser.setAccessory(null);
                }
            } else if (jComponent == FileChooserDemo.this.useFileViewCheckBox) {
                if (bl) {
                    FileChooserDemo.this.chooser.setFileView(FileChooserDemo.this.fileView);
                } else {
                    FileChooserDemo.this.chooser.setFileView(null);
                }
            } else if (jComponent == FileChooserDemo.this.useFileSystemViewCheckBox) {
                if (bl) {
                    FileChooserDemo.this.chooser.setFileSystemView(FileChooserDemo.this.fileSystemView);
                } else {
                    FileChooserDemo.this.chooser.setFileSystemView(FileSystemView.getFileSystemView());
                }
            } else if (jComponent == FileChooserDemo.this.showFullDescriptionCheckBox) {
                FileChooserDemo.this.resetFileFilters(FileChooserDemo.this.showImageFilesFilterCheckBox.isSelected(), bl);
            } else if (jComponent == FileChooserDemo.this.justFilesRadioButton) {
                FileChooserDemo.this.chooser.setFileSelectionMode(0);
            } else if (jComponent == FileChooserDemo.this.justDirectoriesRadioButton) {
                FileChooserDemo.this.chooser.setFileSelectionMode(1);
            } else if (jComponent == FileChooserDemo.this.bothFilesAndDirectoriesRadioButton) {
                FileChooserDemo.this.chooser.setFileSelectionMode(2);
            } else if (jComponent == FileChooserDemo.this.singleSelectionRadioButton) {
                if (bl) {
                    FileChooserDemo.this.chooser.setMultiSelectionEnabled(false);
                }
            } else if (jComponent == FileChooserDemo.this.multiSelectionRadioButton) {
                if (bl) {
                    FileChooserDemo.this.chooser.setMultiSelectionEnabled(true);
                }
            } else if (jComponent == FileChooserDemo.this.lafComboBox) {
                SupportedLaF supportedLaF = (SupportedLaF)FileChooserDemo.this.lafComboBox.getSelectedItem();
                LookAndFeel lookAndFeel = supportedLaF.laf;
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                    SwingUtilities.updateComponentTreeUI(frame);
                    if (FileChooserDemo.this.chooser != null) {
                        SwingUtilities.updateComponentTreeUI(FileChooserDemo.this.chooser);
                    }
                    frame.pack();
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    ((DefaultComboBoxModel)FileChooserDemo.this.lafComboBox.getModel()).removeElement(supportedLaF);
                }
            }
        }
    }

    private class WizardDialog
    extends JDialog
    implements ActionListener {
        CardLayout cardLayout;
        JPanel cardPanel;
        JLabel messageLabel;
        JButton backButton;
        JButton nextButton;
        JButton closeButton;

        WizardDialog(JFrame jFrame, boolean bl) {
            super(jFrame, "Embedded JFileChooser Demo", bl);
            this.cardLayout = new CardLayout();
            this.cardPanel = new JPanel(this.cardLayout);
            this.getContentPane().add((Component)this.cardPanel, "Center");
            this.messageLabel = new JLabel("", 0);
            this.cardPanel.add((Component)FileChooserDemo.this.chooser, "fileChooser");
            this.cardPanel.add((Component)this.messageLabel, "label");
            this.cardLayout.show(this.cardPanel, "fileChooser");
            FileChooserDemo.this.chooser.addActionListener(this);
            JPanel jPanel = new JPanel();
            this.backButton = new JButton("< Back");
            this.nextButton = new JButton("Next >");
            this.closeButton = new JButton("Close");
            jPanel.add(this.backButton);
            jPanel.add(this.nextButton);
            jPanel.add(this.closeButton);
            this.getContentPane().add((Component)jPanel, "South");
            this.backButton.setEnabled(false);
            this.getRootPane().setDefaultButton(this.nextButton);
            this.backButton.addActionListener(this);
            this.nextButton.addActionListener(this);
            this.closeButton.addActionListener(this);
            this.pack();
            this.setLocationRelativeTo(jFrame);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object == this.backButton) {
                this.back();
            } else if (object == this.nextButton) {
                FileChooserUI fileChooserUI = FileChooserDemo.this.chooser.getUI();
                if (fileChooserUI instanceof BasicFileChooserUI) {
                    ((BasicFileChooserUI)fileChooserUI).getApproveSelectionAction().actionPerformed(null);
                } else {
                    this.next();
                }
            } else if (object == this.closeButton) {
                this.close();
            } else if (string == "ApproveSelection") {
                this.next();
            } else if (string == "CancelSelection") {
                this.close();
            }
        }

        private void back() {
            this.backButton.setEnabled(false);
            this.nextButton.setEnabled(true);
            this.cardLayout.show(this.cardPanel, "fileChooser");
            this.getRootPane().setDefaultButton(this.nextButton);
            FileChooserDemo.this.chooser.requestFocus();
        }

        private void next() {
            this.backButton.setEnabled(true);
            this.nextButton.setEnabled(false);
            this.messageLabel.setText(FileChooserDemo.this.getResultString());
            this.cardLayout.show(this.cardPanel, "label");
            this.getRootPane().setDefaultButton(this.closeButton);
            this.closeButton.requestFocus();
        }

        private void close() {
            this.setVisible(false);
        }

        @Override
        public void dispose() {
            FileChooserDemo.this.chooser.removeActionListener(this);
            this.cardPanel.remove(FileChooserDemo.this.chooser);
            FileChooserDemo.this.chooser.setVisible(true);
            super.dispose();
        }
    }

    private static class SupportedLaF {
        private final String name;
        private final LookAndFeel laf;

        SupportedLaF(String string, LookAndFeel lookAndFeel) {
            this.name = string;
            this.laf = lookAndFeel;
        }

        public String toString() {
            return this.name;
        }
    }
}

