/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Location;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.GUI;
import com.sun.tools.example.debug.gui.MonitorListModel;
import com.sun.tools.example.debug.gui.OutputSink;
import com.sun.tools.example.debug.gui.SourceManager;
import java.io.PrintWriter;

public class Environment {
    private SourceManager sourceManager;
    private ClassManager classManager = new ClassManager(this);
    private ContextManager contextManager;
    private MonitorListModel monitorListModel;
    private ExecutionManager runtime = new ExecutionManager();
    private PrintWriter typeScript;
    private boolean verbose;

    public Environment() {
        this.sourceManager = new SourceManager(this);
        this.contextManager = new ContextManager(this);
        this.monitorListModel = new MonitorListModel(this);
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public ClassManager getClassManager() {
        return this.classManager;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public MonitorListModel getMonitorListModel() {
        return this.monitorListModel;
    }

    public ExecutionManager getExecutionManager() {
        return this.runtime;
    }

    public void terminate() {
        System.exit(0);
    }

    public void setTypeScript(PrintWriter printWriter) {
        this.typeScript = printWriter;
    }

    public void error(String string) {
        if (this.typeScript != null) {
            this.typeScript.println(string);
        } else {
            System.out.println(string);
        }
    }

    public void failure(String string) {
        if (this.typeScript != null) {
            this.typeScript.println(string);
        } else {
            System.out.println(string);
        }
    }

    public void notice(String string) {
        if (this.typeScript != null) {
            this.typeScript.println(string);
        } else {
            System.out.println(string);
        }
    }

    public OutputSink getOutputSink() {
        return new OutputSink(this.typeScript);
    }

    public void viewSource(String string) {
        GUI.srcTool.showSourceFile(string);
    }

    public void viewLocation(Location location) {
        GUI.srcTool.showSourceForLocation(location);
    }

    public boolean getVerboseFlag() {
        return this.verbose;
    }

    public void setVerboseFlag(boolean bl) {
        this.verbose = bl;
    }
}

