/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import sun.jvm.hotspot.bugspot.BugSpotAgent;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.runtime.VM;

public abstract class Tool
implements Runnable {
    private BugSpotAgent agent;
    private int debugeeType;
    protected static final int DEBUGEE_PID = 0;
    protected static final int DEBUGEE_CORE = 1;
    protected static final int DEBUGEE_REMOTE = 2;

    public String getName() {
        return this.getClass().getName();
    }

    protected boolean needsJavaPrefix() {
        return true;
    }

    protected boolean requiresVM() {
        return true;
    }

    protected void setAgent(BugSpotAgent a) {
        this.agent = a;
    }

    protected void setDebugeeType(int dt) {
        this.debugeeType = dt;
    }

    protected BugSpotAgent getAgent() {
        return this.agent;
    }

    protected int getDebugeeType() {
        return this.debugeeType;
    }

    protected void printUsage() {
        String name = null;
        name = this.needsJavaPrefix() ? "java " + this.getName() : this.getName();
        System.out.println("Usage: " + name + " [option] <pid>");
        System.out.println("\t\t(to connect to a live java process)");
        System.out.println("   or " + name + " [option] <executable> <core>");
        System.out.println("\t\t(to connect to a core file)");
        System.out.println("   or " + name + " [option] [server_id@]<remote server IP or hostname>");
        System.out.println("\t\t(to connect to a remote debug server)");
        System.out.println();
        System.out.println("where option must be one of:");
        this.printFlagsUsage();
    }

    protected void printFlagsUsage() {
        System.out.println("    -h | -help\tto print this help message");
    }

    protected void usage() {
        this.printUsage();
        System.exit(1);
    }

    protected void stop() {
        if (this.agent != null) {
            this.agent.detach();
            System.exit(0);
        }
    }

    protected void start(String[] args) {
        if (args.length < 1 || args.length > 2) {
            this.usage();
        }
        if (args[0].startsWith("-")) {
            this.usage();
        }
        PrintStream err = System.err;
        int pid = 0;
        String coreFileName = null;
        String executableName = null;
        String remoteServer = null;
        switch (args.length) {
            case 1: {
                try {
                    pid = Integer.parseInt(args[0]);
                    this.debugeeType = 0;
                }
                catch (NumberFormatException e) {
                    remoteServer = args[0];
                    this.debugeeType = 2;
                }
                break;
            }
            case 2: {
                executableName = args[0];
                coreFileName = args[1];
                this.debugeeType = 1;
                break;
            }
            default: {
                this.usage();
            }
        }
        this.agent = new BugSpotAgent();
        try {
            switch (this.debugeeType) {
                case 0: {
                    err.println("Attaching to process ID " + pid + ", please wait...");
                    this.agent.attach(pid);
                    break;
                }
                case 1: {
                    err.println("Attaching to core " + coreFileName + " from executable " + executableName + ", please wait...");
                    this.agent.attach(executableName, coreFileName);
                    break;
                }
                case 2: {
                    err.println("Attaching to remote server " + remoteServer + ", please wait...");
                    this.agent.attach(remoteServer);
                }
            }
        }
        catch (DebuggerException e) {
            switch (this.debugeeType) {
                case 0: {
                    err.print("Error attaching to process: ");
                    break;
                }
                case 1: {
                    err.print("Error attaching to core file: ");
                    break;
                }
                case 2: {
                    err.print("Error attaching to remote server: ");
                }
            }
            if (e.getMessage() != null) {
                err.print(e.getMessage());
            }
            err.println();
            System.exit(1);
        }
        err.println("Debugger attached successfully.");
        boolean isJava = this.agent.isJavaMode();
        if (isJava) {
            VM vm = VM.getVM();
            if (vm.isCore()) {
                err.println("Core build detected.");
            } else if (vm.isClientCompiler()) {
                err.println("Client compiler detected.");
            } else if (vm.isServerCompiler()) {
                err.println("Server compiler detected.");
            } else {
                throw new RuntimeException("Fatal error: should have been able to detect core/C1/C2 build");
            }
            String version = vm.getVMRelease();
            if (version != null) {
                err.print("JVM version is ");
                err.println(version);
            }
            this.run();
        } else if (this.requiresVM()) {
            err.println(this.getName() + " requires a java VM process/core!");
        } else {
            this.run();
        }
    }
}

