/*
 * Decompiled with CFR 0.152.
 */
package jeoip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import jeoip.Continent;
import jeoip.Countries;
import jeoip.Country;

public class JeoIP {
    private final boolean DEBUG = false;
    public static final String DEFAULT_DIR = "/usr/local/share/examples/GeoIP/";
    public static final String DB = "GeoIP.dat";
    private final long COUNTRY_BEGIN = 0xFFFF00L;
    private final String dbFullPath;
    private RandomAccessFile dbIO;
    private final long databaseSegments = 0xFFFF00L;
    private final int recordLength = 3;

    public JeoIP(String string) throws IOException {
        this.dbFullPath = string + "/" + DB;
        File file = new File(this.dbFullPath);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("File not readable: " + this.dbFullPath);
        }
        this.dbIO = new RandomAccessFile(file, "r");
    }

    public JeoIP() throws IOException {
        this(DEFAULT_DIR);
    }

    public void close() throws IOException {
        this.dbIO.close();
        this.dbIO = null;
    }

    public String getCountryName(String string) throws IOException {
        Country country = Countries.getCountry((int)this.ipToCountryCode(string));
        return country != null ? country.name : null;
    }

    public String getCountryCode2(String string) throws IOException {
        Country country = Countries.getCountry((int)this.ipToCountryCode(string));
        return country != null ? country.name : null;
    }

    public String getCountryCode3(String string) throws IOException {
        Country country = Countries.getCountry((int)this.ipToCountryCode(string));
        return country != null ? country.name : null;
    }

    public Continent getContinent(String string) {
        throw new IllegalArgumentException("Not written yet, sorry.");
    }

    public static int ipAddrToNum(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.toString());
        }
    }

    private long ipToCountryCode(int n) throws IOException {
        if (this.dbIO == null) {
            throw new IOException("file has been closed");
        }
        int[] nArray = new int[6];
        long l = 0L;
        long l2 = 0L;
        for (int i = 31; i >= 0; --i) {
            long l3 = 6L * l;
            this.dbIO.seek(l3);
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = this.dbIO.readUnsignedByte();
            }
            l2 = (n & 1 << i) != 0 ? (long)nArray[3] << 0 | (long)nArray[4] << 8 | (long)nArray[5] << 16 : (long)nArray[0] << 0 | (long)nArray[1] << 8 | (long)nArray[2] << 16;
            if (l2 >= 0xFFFF00L) {
                return l2 - 0xFFFF00L;
            }
            l = l2;
        }
        System.err.printf("Error grubbing around in database for ip = %x - database may be corrupt?%n", n);
        return 0L;
    }

    private long ipToCountryCode(String string) throws IOException {
        return this.ipToCountryCode(JeoIP.ipAddrToNum(string));
    }
}

