/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line"), "alignline", I18n.tr("Move the selected nodes in to a line."), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Line")), 76, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Node> itnodes = new LinkedList<Node>();
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Node)) continue;
            nodes.add((Node)osm);
            itnodes.add((Node)osm);
        }
        if (nodes.size() == 0 && sel.size() == 1) {
            for (OsmPrimitive osm : sel) {
                if (!(osm instanceof Way)) continue;
                nodes.addAll(((Way)osm).getNodes());
                itnodes.addAll(((Way)osm).getNodes());
            }
        }
        if (nodes.size() < 3) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least three nodes."), I18n.tr("Information"), 1);
            return;
        }
        double distance = 0.0;
        Node nodea = null;
        Node nodeb = null;
        for (Node n : nodes) {
            itnodes.remove(n);
            for (Node m : itnodes) {
                double dist = Math.sqrt(n.getEastNorth().distance(m.getEastNorth()));
                if (!(dist > distance)) continue;
                nodea = n;
                nodeb = m;
                distance = dist;
            }
        }
        nodes.remove(nodea);
        nodes.remove(nodeb);
        double ax = nodea.getEastNorth().east();
        double ay = nodea.getEastNorth().north();
        double bx = nodeb.getEastNorth().east();
        double by = nodeb.getEastNorth().north();
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Node n : nodes) {
            double nx = n.getEastNorth().east();
            double ny = n.getEastNorth().north();
            if (ax == bx) {
                nx = ax;
            } else if (ay == by) {
                ny = ay;
            } else {
                double m1 = (by - ay) / (bx - ax);
                double c1 = ay - ax * m1;
                double m2 = -1.0 / m1;
                double c2 = n.getEastNorth().north() - n.getEastNorth().east() * m2;
                nx = (c2 - c1) / (m1 - m2);
                ny = m1 * nx + c1;
            }
            cmds.add(new MoveCommand(n, nx - n.getEastNorth().east(), ny - n.getEastNorth().north()));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Line"), cmds));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

