/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.CloseChangesetDialog;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class CloseChangesetAction
extends JosmAction {
    public CloseChangesetAction() {
        super(I18n.tr("Close open changesets"), "closechangeset", I18n.tr("Closes open changesets"), Shortcut.registerShortcut("system:closechangeset", I18n.tr("File: {0}", I18n.tr("Closes open changesets")), 81, 15), true);
    }

    public void actionPerformed(ActionEvent e) {
        Main.worker.submit(new DownloadOpenChangesetsTask());
    }

    protected void onPostDownloadOpenChangesets(DownloadOpenChangesetsTask task) {
        if (task.isCancelled() || task.getLastException() != null) {
            return;
        }
        List<Changeset> openChangesets = task.getChangesets();
        if (openChangesets.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no open changesets"), I18n.tr("No open changesets"), 1);
            return;
        }
        CloseChangesetDialog dialog = new CloseChangesetDialog();
        dialog.setChangesets(openChangesets);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Collection<Changeset> changesetsToClose = dialog.getSelectedChangesets();
        CloseChangesetTask closeChangesetTask = new CloseChangesetTask(changesetsToClose);
        Main.worker.submit(closeChangesetTask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DownloadOpenChangesetsTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private OsmServerChangesetReader reader;
        private List<Changeset> changesets;
        private Exception lastException;
        private UserInfo userInfo;

        public DownloadOpenChangesetsTask() {
            super(I18n.tr("Downloading open changesets ...", false));
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
            this.reader.cancel();
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DownloadOpenChangesetsTask.this.lastException != null) {
                        ExceptionDialogUtil.explainException(DownloadOpenChangesetsTask.this.lastException);
                    }
                    CloseChangesetAction.this.onPostDownloadOpenChangesets(DownloadOpenChangesetsTask.this);
                }
            });
        }

        protected UserInfo fetchUserInfo() throws OsmTransferException {
            OsmServerUserInfoReader reader = new OsmServerUserInfoReader();
            return reader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.userInfo = this.fetchUserInfo();
                if (this.cancelled) {
                    return;
                }
                this.reader = new OsmServerChangesetReader();
                ChangesetQuery query = new ChangesetQuery().forUser(this.userInfo.getId()).beingOpen();
                this.changesets = this.reader.queryChangesets(query, this.getProgressMonitor().createSubTaskMonitor(1, false));
            }
            catch (Exception e) {
                if (this.cancelled) {
                    return;
                }
                this.lastException = e;
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public List<Changeset> getChangesets() {
            return this.changesets;
        }

        public Exception getLastException() {
            return this.lastException;
        }
    }
}

