/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxExporter;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.NMEAImporter;
import org.openstreetmap.josm.io.OsmBzip2Exporter;
import org.openstreetmap.josm.io.OsmBzip2Importer;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmGzipExporter;
import org.openstreetmap.josm.io.OsmGzipImporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFileFilter
extends FileFilter {
    public static ArrayList<FileImporter> importers = new ArrayList<FileImporter>(Arrays.asList(new OsmImporter(), new OsmGzipImporter(), new OsmBzip2Importer(), new GpxImporter(), new NMEAImporter(), new AllFormatsImporter()));
    public static ArrayList<FileExporter> exporters = new ArrayList<FileExporter>(Arrays.asList(new GpxExporter(), new OsmExporter(), new OsmGzipExporter(), new OsmBzip2Exporter()));
    private final String extensions;
    private final String description;
    private final String defaultExtension;

    protected static void sort(List<ExtensionFileFilter> filters) {
        Collections.sort(filters, new Comparator<ExtensionFileFilter>(){
            private AllFormatsImporter all = new AllFormatsImporter();

            @Override
            public int compare(ExtensionFileFilter o1, ExtensionFileFilter o2) {
                if (o1.getDescription().equals(this.all.filter.getDescription())) {
                    return 1;
                }
                if (o2.getDescription().equals(this.all.filter.getDescription())) {
                    return -1;
                }
                return o1.getDescription().compareTo(o2.getDescription());
            }
        });
    }

    public static List<ExtensionFileFilter> getImportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> filters = new LinkedList<ExtensionFileFilter>();
        for (FileImporter importer : importers) {
            if (filters.contains(importer.filter)) continue;
            filters.add(importer.filter);
        }
        ExtensionFileFilter.sort(filters);
        return filters;
    }

    public static List<ExtensionFileFilter> getExportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> filters = new LinkedList<ExtensionFileFilter>();
        for (FileExporter exporter : exporters) {
            if (filters.contains(exporter.filter)) continue;
            filters.add(exporter.filter);
        }
        ExtensionFileFilter.sort(filters);
        return filters;
    }

    public static ExtensionFileFilter getDefaultImportExtensionFileFilter(String extension) {
        if (extension == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileImporter importer : importers) {
            if (!extension.equals(importer.filter.getDefaultExtension())) continue;
            return importer.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static ExtensionFileFilter getDefaultExportExtensionFileFilter(String extension) {
        if (extension == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileExporter exporter : exporters) {
            if (!extension.equals(exporter.filter.getDefaultExtension())) continue;
            return exporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static void applyChoosableImportFileFilters(JFileChooser fileChooser, String extension) {
        for (ExtensionFileFilter filter : ExtensionFileFilter.getImportExtensionFileFilters()) {
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setFileFilter(ExtensionFileFilter.getDefaultImportExtensionFileFilter(extension));
    }

    public static void applyChoosableExportFileFilters(JFileChooser fileChooser, String extension) {
        for (ExtensionFileFilter filter : ExtensionFileFilter.getExportExtensionFileFilters()) {
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setFileFilter(ExtensionFileFilter.getDefaultExportExtensionFileFilter(extension));
    }

    public ExtensionFileFilter(String extension, String defaultExtension, String description) {
        this.extensions = extension;
        this.defaultExtension = defaultExtension;
        this.description = description;
    }

    public boolean acceptName(String filename) {
        String name = filename.toLowerCase();
        for (String ext : this.extensions.split(",")) {
            if (!name.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        return this.acceptName(pathname.getName());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultExtension == null ? 0 : this.defaultExtension.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionFileFilter other = (ExtensionFileFilter)obj;
        if (this.defaultExtension == null ? other.defaultExtension != null : !this.defaultExtension.equals(other.defaultExtension)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions));
    }

    public static class AllFormatsImporter
    extends FileImporter {
        public AllFormatsImporter() {
            super(new ExtensionFileFilter("osm,xml,osm.gz,osm.bz2,osm.bz,gpx,gpx.gz,nmea,nme,nma,txt,wms", "", I18n.tr("All Formats") + " (*.gpx *.osm *.nmea ...)"));
        }

        public boolean acceptFile(File pathname) {
            return false;
        }
    }
}

