/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RenameLayerAction
extends AbstractAction {
    private File file;
    private Layer layer;

    public RenameLayerAction(File file, Layer layer) {
        super(I18n.tr("Rename layer"), ImageProvider.get("dialogs", "edit"));
        this.file = file;
        this.layer = layer;
        this.putValue("help", "Action/LayerRename");
    }

    public void actionPerformed(ActionEvent e) {
        Box panel = Box.createVerticalBox();
        final JTextField name = new JTextField(this.layer.getName());
        panel.add(name);
        JCheckBox filerename = new JCheckBox(I18n.tr("Also rename the file"));
        if (Main.applet) {
            filerename.setEnabled(false);
            filerename.setSelected(false);
        } else {
            panel.add(filerename);
            filerename.setEnabled(this.file != null);
        }
        if (filerename.isEnabled()) {
            filerename.setSelected(Main.pref.getBoolean("layer.rename-file", true));
        }
        JOptionPane optionPane = new JOptionPane(panel, 3, 2){

            public void selectInitialValue() {
                name.requestFocusInWindow();
                name.selectAll();
            }
        };
        JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr("Rename layer"));
        dlg.setModal(true);
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            return;
        }
        String nameText = name.getText();
        if (filerename.isEnabled()) {
            Main.pref.put("layer.rename-file", filerename.isSelected());
            if (filerename.isSelected()) {
                File newFile;
                String newname = nameText;
                if (newname.indexOf("/") == -1 && newname.indexOf("\\") == -1) {
                    newname = this.file.getParent() + File.separator + newname;
                }
                String oldname = this.file.getName();
                if (name.getText().indexOf(46) == -1 && oldname.indexOf(46) >= 0) {
                    newname = newname + oldname.substring(oldname.lastIndexOf(46));
                }
                if (this.file.renameTo(newFile = new File(newname))) {
                    this.layer.setAssociatedFile(newFile);
                    nameText = newFile.getName();
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not rename file ''{0}''", this.file.getPath()), I18n.tr("Error"), 0);
                    return;
                }
            }
        }
        this.layer.setName(nameText);
        Main.parent.repaint();
    }
}

