/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadReferrersAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.actions.upload.UploadParameterHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmChangesetCloseException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadAction
extends JosmAction {
    private static Logger logger = Logger.getLogger(UploadAction.class.getName());
    private static final LinkedList<UploadHook> uploadHooks = new LinkedList();

    public static void registerUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        if (!uploadHooks.contains(hook)) {
            uploadHooks.add(0, hook);
        }
    }

    public static void unregisterUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        if (uploadHooks.contains(hook)) {
            uploadHooks.remove(hook);
        }
    }

    public UploadAction() {
        super(I18n.tr("Upload data"), "upload", I18n.tr("Upload all changes in the current data layer to the OSM server"), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data")), 85, 8), true);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public boolean checkPreUploadConditions(OsmDataLayer layer) {
        return this.checkPreUploadConditions(layer, new APIDataSet(layer.data));
    }

    public boolean checkPreUploadConditions(OsmDataLayer layer, APIDataSet apiData) {
        ConflictCollection conflicts = layer.getConflicts();
        if (conflicts != null && !conflicts.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>There are unresolved conflicts in layer ''{0}''.<br>You have to resolve them first.</html>", layer.getName()), I18n.tr("Warning"), 2);
            return false;
        }
        for (UploadHook hook : uploadHooks) {
            if (hook.checkUpload(apiData)) continue;
            return false;
        }
        return true;
    }

    public void uploadData(OsmDataLayer layer, APIDataSet apiData) {
        if (apiData.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."), I18n.tr("Warning"), 1);
            return;
        }
        if (!this.checkPreUploadConditions(layer, apiData)) {
            return;
        }
        Main.worker.execute(this.createUploadTask(layer, apiData.getPrimitives(), UploadDialog.getUploadDialog().getChangeset(), UploadDialog.getUploadDialog().isDoCloseAfterUpload()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first."), I18n.tr("Warning"), 2);
            return;
        }
        APIDataSet apiData = new APIDataSet(Main.main.getCurrentDataSet());
        this.uploadData(Main.map.mapView.getEditLayer(), apiData);
    }

    protected void synchronizePrimitive(OsmPrimitiveType type, long id) {
        Main.worker.execute(new UpdatePrimitiveTask(type, id));
    }

    protected void synchronizeDataSet() {
        UpdateDataAction act = new UpdateDataAction();
        act.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected void handleUploadConflictForKnownConflict(OsmPrimitiveType primitiveType, long id, String serverVersion, String myVersion) {
        String lbl = "";
        switch (primitiveType) {
            case NODE: {
                lbl = I18n.tr("Synchronize node {0} only", id);
                break;
            }
            case WAY: {
                lbl = I18n.tr("Synchronize way {0} only", id);
                break;
            }
            case RELATION: {
                lbl = I18n.tr("Synchronize relation {0} only", id);
            }
        }
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(lbl, ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset"), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), null, null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br>The conflict is caused by the <strong>{0}</strong> with id <strong>{1}</strong>,<br>the server has version {2}, your version is {3}.<br><br>Click <strong>{4}</strong> to synchronize the conflicting primitive only.<br>Click <strong>{5}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{6}</strong> to abort and continue editing.<br></html>", I18n.tr(primitiveType.getAPIName()), id, serverVersion, myVersion, spec[0].text, spec[1].text, spec[2].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Conflicts detected"), 0, null, spec, spec[0], "/Concepts/Conflict");
        switch (ret) {
            case 0: {
                this.synchronizePrimitive(primitiveType, id);
                break;
            }
            case 1: {
                this.synchronizeDataSet();
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void handleUploadConflictForUnknownConflict() {
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Synchronize entire dataset"), ImageProvider.get("updatedata"), null, null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), null, null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br><br>Click <strong>{0}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{1}</strong> to abort and continue editing.<br></html>", spec[0].text, spec[1].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Conflicts detected"), 0, null, spec, spec[0], "Concepts/Conflict");
        if (ret == 0) {
            this.synchronizeDataSet();
        }
    }

    protected void handleUploadConflictForClosedChangeset(long changsetId, Date d) {
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because you''ve been using<br>changeset {0} which was already closed at {1}.<br>Please upload again with a new or an existing open changeset.</html>", changsetId, new SimpleDateFormat().format(d));
        JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Changeset closed"), 0);
    }

    protected void handleUploadConflictForNodeStillInUse(long nodeId, long wayId) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Prepare conflict resolution"), ImageProvider.get("ok"), I18n.tr("Click to download all parent ways for node {0}", nodeId), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), I18n.tr("Click to cancel and to resume editing the map", nodeId), null)};
        String msg = I18n.tr("<html>Uploading <strong>failed</strong> because you tried to delete node {0} which is still in use in way {1}.<br><br>Click <strong>{2}</strong> to download all parent ways of node {0}.<br>If necessary JOSM will create conflicts which you can resolve in the Conflict Resolution Dialog.</html>", nodeId, wayId, options[0].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Node still in use"), 0, null, options, options[0], "/Action/Upload#NodeStillInUseInWay");
        if (ret != 0) {
            return;
        }
        DownloadReferrersAction.downloadReferrers(Main.map.mapView.getEditLayer(), nodeId, OsmPrimitiveType.NODE);
    }

    protected void handleUploadConflict(OsmApiException e) {
        String pattern = "Version mismatch: Provided (\\d+), server had: (\\d+) of (\\S+) (\\d+)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForKnownConflict(OsmPrimitiveType.from(m.group(3)), Long.parseLong(m.group(4)), m.group(2), m.group(1));
            return;
        }
        pattern = "The changeset (\\d+) was closed at (.*)";
        p = Pattern.compile(pattern);
        m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForClosedChangeset(Long.parseLong(m.group(1)), DateUtils.fromString(m.group(2)));
            return;
        }
        pattern = "Node (\\d+) is still used by way (\\d+).";
        p = Pattern.compile(pattern);
        m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForNodeStillInUse(Long.parseLong(m.group(1)), Long.parseLong(m.group(2)));
            return;
        }
        logger.warning(I18n.tr("Warning: error header \"{0}\" did not match with an expected pattern", e.getErrorHeader()));
        this.handleUploadConflictForUnknownConflict();
    }

    protected void handlePreconditionFailed(OsmApiException e) {
        String pattern = "Precondition failed: Node (\\d+) is still used by way (\\d+).";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(e.getErrorHeader());
        if (m.matches()) {
            this.handleUploadConflictForNodeStillInUse(Long.parseLong(m.group(1)), Long.parseLong(m.group(2)));
            return;
        }
        logger.warning(I18n.tr("Warning: error header \"{0}\" did not match with an expected pattern", e.getErrorHeader()));
        ExceptionDialogUtil.explainPreconditionFailed(e);
    }

    protected void handleGoneForKnownPrimitive(OsmPrimitiveType primitiveType, long id) {
        UpdateSelectionAction act = new UpdateSelectionAction();
        act.handlePrimitiveGoneException(id, primitiveType);
    }

    protected void handleGone(OsmApiPrimitiveGoneException e) {
        if (e.isKnownPrimitive()) {
            this.handleGoneForKnownPrimitive(e.getPrimitiveType(), e.getPrimitiveId());
        } else {
            ExceptionDialogUtil.explainGoneForUnknownPrimitive(e);
        }
    }

    protected void handleFailedUpload(Exception e) {
        if (e instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
            return;
        }
        if (e instanceof OsmChangesetCloseException) {
            ExceptionDialogUtil.explainOsmChangesetCloseException((OsmChangesetCloseException)e);
            return;
        }
        if (e instanceof OsmApiPrimitiveGoneException) {
            this.handleGone((OsmApiPrimitiveGoneException)e);
            return;
        }
        if (e instanceof OsmApiException) {
            OsmApiException ex = (OsmApiException)e;
            if (ex.getResponseCode() == 409) {
                this.handleUploadConflict(ex);
                return;
            }
            if (ex.getResponseCode() == 412) {
                this.handlePreconditionFailed(ex);
                return;
            }
            if (ex.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(ex);
                return;
            }
            ex.printStackTrace();
            String msg = I18n.tr("<html>Uploading <strong>failed</strong>.<br>{0}</html>", ex.getDisplayMessage());
            JOptionPane.showMessageDialog(Main.map, msg, I18n.tr("Upload to OSM API failed"), 0);
            return;
        }
        ExceptionDialogUtil.explainException(e);
    }

    public UploadPrimitivesTask createUploadTask(OsmDataLayer layer, Collection<OsmPrimitive> toUpload, Changeset changeset, boolean closeChangesetAfterUpload) {
        return new UploadPrimitivesTask(layer, toUpload, changeset, closeChangesetAfterUpload);
    }

    static {
        uploadHooks.add(new ApiPreconditionCheckerHook());
        uploadHooks.add(new RelationUploadOrderHook());
        uploadHooks.add(new UploadParameterHook());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UploadPrimitivesTask
    extends PleaseWaitRunnable {
        private boolean uploadCancelled;
        private Exception lastException;
        private Collection<OsmPrimitive> toUpload;
        private OsmServerWriter writer;
        private OsmDataLayer layer;
        private Changeset changeset;
        private boolean closeChangesetAfterUpload;
        private HashSet<OsmPrimitive> processedPrimitives;

        private UploadPrimitivesTask(OsmDataLayer layer, Collection<OsmPrimitive> toUpload, Changeset changeset, boolean closeChangesetAfterUpload) {
            super(I18n.tr("Uploading data for layer ''{0}''", layer.getName()), false);
            this.uploadCancelled = false;
            this.lastException = null;
            this.toUpload = toUpload;
            this.layer = layer;
            this.changeset = changeset;
            this.closeChangesetAfterUpload = closeChangesetAfterUpload;
            this.processedPrimitives = new HashSet();
        }

        protected OsmPrimitive getPrimitive(OsmPrimitiveType type, long id) {
            for (OsmPrimitive p : this.toUpload) {
                if (!OsmPrimitiveType.from(p).equals((Object)type) || p.getId() != id) continue;
                return p;
            }
            return null;
        }

        protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException e, ProgressMonitor monitor) throws OsmTransferException {
            if (!e.isKnownPrimitive()) {
                throw e;
            }
            OsmPrimitive p = this.getPrimitive(e.getPrimitiveType(), e.getPrimitiveId());
            if (p == null) {
                throw e;
            }
            if (p.isDeleted()) {
                System.out.println(I18n.tr("Warning: primitive ''{0}'' is already deleted on the server. Skipping this primitive and retrying to upload.", p.getDisplayName(DefaultNameFormatter.getInstance())));
                this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                this.processedPrimitives.add(p);
                this.toUpload.removeAll(this.processedPrimitives);
                return;
            }
            throw e;
        }

        @Override
        protected void realRun() throws SAXException, IOException {
            this.writer = new OsmServerWriter();
            try {
                while (true) {
                    try {
                        ProgressMonitor monitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                        this.writer.uploadOsm(this.layer.data.version, this.toUpload, this.changeset, monitor);
                        this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    }
                    catch (OsmApiPrimitiveGoneException e) {
                        this.recoverFromGoneOnServer(e, this.getProgressMonitor());
                        continue;
                    }
                    break;
                }
                if (this.closeChangesetAfterUpload && this.changeset != null && this.changeset.getId() > 0L) {
                    OsmApi.getOsmApi().closeChangeset(this.changeset, this.progressMonitor.createSubTaskMonitor(0, false));
                }
            }
            catch (Exception e) {
                if (this.uploadCancelled) {
                    System.out.println("Ignoring exception caught because upload is cancelled. Exception is: " + e.toString());
                    return;
                }
                this.lastException = e;
            }
        }

        @Override
        protected void finish() {
            if (this.uploadCancelled) {
                return;
            }
            this.layer.cleanupAfterUpload(this.processedPrimitives);
            DataSet.fireSelectionChanged(this.layer.data.getSelected());
            this.layer.fireDataChange();
            if (this.lastException != null) {
                UploadAction.this.handleFailedUpload(this.lastException);
            }
            this.layer.onPostUploadToServer();
            UploadDialog.getUploadDialog().setOrUpdateChangeset(this.changeset);
        }

        @Override
        protected void cancel() {
            this.uploadCancelled = true;
            if (this.writer != null) {
                this.writer.cancel();
            }
        }
    }

    class UpdatePrimitiveTask
    extends PleaseWaitRunnable {
        private boolean uploadCancelled;
        private boolean uploadFailed;
        private Exception lastException;
        private long id;
        private OsmPrimitiveType type;

        public UpdatePrimitiveTask(OsmPrimitiveType type, long id) {
            super(I18n.tr("Updating primitive"), false);
            this.uploadCancelled = false;
            this.uploadFailed = false;
            this.lastException = null;
            this.id = id;
            this.type = type;
        }

        protected void realRun() throws SAXException, IOException {
            try {
                UpdateSelectionAction act = new UpdateSelectionAction();
                act.updatePrimitive(this.type, this.id);
            }
            catch (Exception sxe) {
                if (this.uploadCancelled) {
                    System.out.println("Ignoring exception caught because upload is canceled. Exception is: " + sxe.toString());
                    return;
                }
                this.uploadFailed = true;
                this.lastException = sxe;
            }
        }

        protected void finish() {
            if (this.uploadFailed) {
                UploadAction.this.handleFailedUpload(this.lastException);
            }
        }

        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.uploadCancelled = true;
        }
    }
}

