/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UploadSelectionDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadSelectionAction
extends JosmAction {
    private static Logger logger = Logger.getLogger(UploadSelectionAction.class.getName());

    public UploadSelectionAction() {
        super(I18n.tr("Upload selection"), "uploadselection", I18n.tr("Upload all changes in the current selection to the OSM server."), null, true);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    protected Set<OsmPrimitive> getDeletedPrimitives(DataSet ds) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : ds.nodes) {
            if (!osmPrimitive.isDeleted() || osmPrimitive.isNew() || !osmPrimitive.isVisible() || !osmPrimitive.isModified()) continue;
            ret.add(osmPrimitive);
        }
        for (OsmPrimitive osmPrimitive : ds.ways) {
            if (!osmPrimitive.isDeleted() || osmPrimitive.isNew() || !osmPrimitive.isVisible() || !osmPrimitive.isModified()) continue;
            ret.add(osmPrimitive);
        }
        for (OsmPrimitive osmPrimitive : ds.relations) {
            if (!osmPrimitive.isDeleted() || osmPrimitive.isNew() || !osmPrimitive.isVisible() || !osmPrimitive.isModified()) continue;
            ret.add(osmPrimitive);
        }
        return ret;
    }

    protected Set<OsmPrimitive> getModifiedPrimitives(Collection<OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (OsmPrimitive p : primitives) {
            if (p.isNew()) {
                ret.add(p);
                continue;
            }
            if (!p.isVisible() || !p.isModified() || p.incomplete) continue;
            ret.add(p);
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        UploadHullBuilder builder = new UploadHullBuilder();
        UploadSelectionDialog dialog = new UploadSelectionDialog();
        Set<OsmPrimitive> modifiedCandidates = this.getModifiedPrimitives(this.getEditLayer().data.getSelected());
        Set<OsmPrimitive> deletedCandiates = this.getDeletedPrimitives(this.getEditLayer().data);
        if (modifiedCandidates.isEmpty() && deletedCandiates.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."), I18n.tr("Warning"), 1);
            return;
        }
        dialog.populate(modifiedCandidates, deletedCandiates);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Set<OsmPrimitive> toUpload = builder.build(dialog.getSelectedPrimitives());
        if (toUpload.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."), I18n.tr("Warning"), 1);
            return;
        }
        this.uploadPrimitives(this.getEditLayer(), toUpload);
    }

    protected boolean hasPrimitivesToDelete(Collection<OsmPrimitive> primitives) {
        for (OsmPrimitive p : primitives) {
            if (!p.isDeleted() || !p.isModified() || p.isNew()) continue;
            return true;
        }
        return false;
    }

    public void uploadPrimitives(OsmDataLayer layer, Collection<OsmPrimitive> toUpload) {
        if (toUpload == null || toUpload.isEmpty()) {
            return;
        }
        UploadHullBuilder builder = new UploadHullBuilder();
        if (this.hasPrimitivesToDelete(toUpload = builder.build(toUpload))) {
            Main.worker.submit(new DeletedParentsChecker(layer, toUpload));
        } else {
            this.processPostParentChecker(layer, toUpload);
        }
    }

    protected void processPostParentChecker(OsmDataLayer layer, Collection<OsmPrimitive> toUpload) {
        APIDataSet ds = new APIDataSet(toUpload);
        UploadAction action = new UploadAction();
        action.uploadData(layer, ds);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DeletedParentsChecker
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Exception lastException;
        private Collection<OsmPrimitive> toUpload;
        private OsmDataLayer layer;
        private OsmServerBackreferenceReader reader;

        public DeletedParentsChecker(OsmDataLayer layer, Collection<OsmPrimitive> toUpload) {
            super(I18n.tr("Checking parents for deleted objects"));
            this.toUpload = toUpload;
            this.layer = layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            DeletedParentsChecker deletedParentsChecker = this;
            synchronized (deletedParentsChecker) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionUtil.explainException(this.lastException);
                return;
            }
            Runnable r = new Runnable(){

                public void run() {
                    UploadSelectionAction.this.processPostParentChecker(DeletedParentsChecker.this.layer, DeletedParentsChecker.this.toUpload);
                }
            };
            SwingUtilities.invokeLater(r);
        }

        protected Set<OsmPrimitive> getPrimitivesToCheckForParents() {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : this.toUpload) {
                if (!p.isDeleted() || p.isNew()) continue;
                ret.add(p);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                Stack<OsmPrimitive> toCheck = new Stack<OsmPrimitive>();
                toCheck.addAll(this.getPrimitivesToCheckForParents());
                HashSet<OsmPrimitive> checked = new HashSet<OsmPrimitive>();
                while (!toCheck.isEmpty()) {
                    if (this.canceled) {
                        return;
                    }
                    OsmPrimitive current = (OsmPrimitive)toCheck.pop();
                    DeletedParentsChecker deletedParentsChecker = this;
                    synchronized (deletedParentsChecker) {
                        this.reader = new OsmServerBackreferenceReader(current);
                    }
                    this.getProgressMonitor().subTask(I18n.tr("Reading parents of ''{0}''", current.getDisplayName(DefaultNameFormatter.getInstance())));
                    DataSet ds = this.reader.parseOsm(this.getProgressMonitor().createSubTaskMonitor(1, false));
                    DeletedParentsChecker deletedParentsChecker2 = this;
                    synchronized (deletedParentsChecker2) {
                        this.reader = null;
                    }
                    checked.add(current);
                    this.getProgressMonitor().subTask(I18n.tr("Checking for deleted parents in the local dataset"));
                    for (OsmPrimitive p : ds.allPrimitives()) {
                        if (this.canceled) {
                            return;
                        }
                        OsmPrimitive myDeletedParent = this.layer.data.getPrimitiveById(p.getId(), OsmPrimitiveType.from(p));
                        if (myDeletedParent == null || !myDeletedParent.isDeleted()) continue;
                        if (!this.toUpload.contains(myDeletedParent)) {
                            this.toUpload.add(myDeletedParent);
                        }
                        if (checked.contains(myDeletedParent)) continue;
                        toCheck.push(myDeletedParent);
                    }
                }
            }
            catch (Exception e) {
                if (this.canceled) {
                    return;
                }
                this.lastException = e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UploadHullBuilder
    implements Visitor {
        private Set<OsmPrimitive> hull = new HashSet<OsmPrimitive>();

        @Override
        public void visit(Node n) {
            if (n.isNew() || (n.isModified() || n.isDeleted()) && n.isVisible()) {
                this.hull.add(n);
            }
        }

        @Override
        public void visit(Way w) {
            if (w.isNew() || (w.isModified() || w.isDeleted()) && w.isVisible()) {
                this.hull.add(w);
                for (Node n : w.getNodes()) {
                    n.visit(this);
                }
            }
        }

        @Override
        public void visit(Relation r) {
            if (r.isNew() || (r.isModified() || r.isDeleted()) && r.isVisible()) {
                this.hull.add(r);
                for (OsmPrimitive p : r.getMemberPrimitives()) {
                    if (!p.isNew()) continue;
                    p.visit(this);
                }
            }
        }

        @Override
        public void visit(Changeset cs) {
        }

        public Set<OsmPrimitive> build(Collection<OsmPrimitive> base) throws IllegalArgumentException {
            if (base == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "base"));
            }
            this.hull = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : base) {
                p.visit(this);
            }
            return this.hull;
        }
    }
}

