/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements AWTEventListener {
    private boolean drawTargetCursor;
    private MouseEvent oldEvent = null;
    private Cursors currCursor = Cursors.none;

    public DeleteAction(MapFrame mapFrame) {
        super(I18n.tr("Delete Mode"), "delete", I18n.tr("Delete nodes or ways."), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete")), 68, 3), mapFrame, ImageProvider.getCursor("normal", "delete"));
    }

    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetCursor = Main.pref.getBoolean("draw.target-cursor", true);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.currCursor = Cursors.none;
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.doActionPerformed(e);
    }

    public void doActionPerformed(ActionEvent e) {
        boolean alt;
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean bl = alt = (e.getModifiers() & 0x28) != 0;
        Command c = ctrl ? DeleteCommand.deleteWithReferences(this.getEditLayer(), this.getCurrentDataSet().getSelected()) : DeleteCommand.delete(this.getEditLayer(), this.getCurrentDataSet().getSelected(), !alt);
        if (c != null) {
            Main.main.undoRedo.add(c);
        }
        this.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
        Main.map.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.oldEvent = e;
        this.updateCursor(e, e.getModifiers());
    }

    private void updateCursor(MouseEvent e, int modifiers) {
        if (!Main.map.mapView.isActiveLayerVisible() || e == null) {
            return;
        }
        Command c = this.buildDeleteCommands(e, modifiers, true);
        if (c == null) {
            this.setCursor(Cursors.none);
            return;
        }
        HashSet<OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> mods = new HashSet<OsmPrimitive>();
        c.fillModifiedData(mods, prims, prims);
        if (prims.size() == 0 && mods.size() == 0) {
            this.setCursor(Cursors.none);
            return;
        }
        if (prims.size() == 0) {
            this.setCursor(Cursors.segment);
        } else if (prims.size() == 1 && prims.toArray()[0] instanceof Node) {
            this.setCursor(Cursors.node);
        } else if (prims.size() == 1 && prims.toArray()[0] instanceof Way) {
            this.setCursor(Cursors.way_only);
        } else {
            boolean ctrl;
            boolean bl = ctrl = (modifiers & 2) != 0;
            if (ctrl) {
                this.setCursor(Cursors.way_node_only);
            } else {
                this.setCursor(Cursors.way_normal);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Command c = this.buildDeleteCommands(e, e.getModifiers(), false);
        if (c != null) {
            Main.main.undoRedo.add(c);
        }
        this.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: don't delete unused nodes when deleting a way. Ctrl: delete referring objects.");
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer layer, Relation toDelete) {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        if (toDelete == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "toDelete"));
        }
        Command cmd = DeleteCommand.delete(layer, Collections.singleton(toDelete));
        if (cmd != null) {
            Main.main.undoRedo.add(cmd);
            RelationDialogManager.getRelationDialogManager().close(layer, toDelete);
            layer.fireDataChange();
        }
    }

    private Command buildDeleteCommands(MouseEvent e, int modifiers, boolean silent) {
        boolean ctrl = (modifiers & 2) != 0;
        boolean shift = (modifiers & 1) != 0;
        boolean alt = (modifiers & 0x28) != 0;
        Node sel = Main.map.mapView.getNearestNode(e.getPoint());
        Command c = null;
        if (sel == null) {
            WaySegment ws = Main.map.mapView.getNearestWaySegment(e.getPoint());
            if (ws != null) {
                c = shift ? DeleteCommand.deleteWaySegment(this.getEditLayer(), ws) : (ctrl ? DeleteCommand.deleteWithReferences(this.getEditLayer(), Collections.singleton(ws.way), true) : DeleteCommand.delete(this.getEditLayer(), Collections.singleton(ws.way), !alt, silent));
            }
        } else {
            c = ctrl ? DeleteCommand.deleteWithReferences(this.getEditLayer(), Collections.singleton(sel)) : DeleteCommand.delete(this.getEditLayer(), Collections.singleton(sel), !alt, silent);
        }
        return c;
    }

    private void setCursor(final Cursors c) {
        if (this.currCursor.equals((Object)c) || !this.drawTargetCursor && this.currCursor.equals((Object)Cursors.none)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!(Main.map.mapMode instanceof DeleteAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(c.cursor());
                }
            });
            this.currCursor = c;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void eventDispatched(AWTEvent e) {
        this.updateCursor(this.oldEvent, ((InputEvent)e).getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Cursors {
        none,
        node,
        segment,
        way_node_only,
        way_normal,
        way_only;

        private Cursor c = null;

        public Cursor cursor() {
            if (this.c == null) {
                String nm = "delete_" + this.name().toLowerCase();
                nm = nm.equals("delete_none") ? "delete" : nm;
                this.c = ImageProvider.getCursor("normal", nm);
            }
            return this.c;
        }
    }
}

