/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmIdReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class SelectionWebsiteLoader
extends PleaseWaitRunnable {
    public final URL url;
    public Collection<OsmPrimitive> sel;
    private final SearchAction.SearchMode mode;
    private OsmIdReader idReader = new OsmIdReader();

    public SelectionWebsiteLoader(String urlStr, SearchAction.SearchMode mode) {
        super(I18n.tr("Load Selection"));
        this.mode = mode;
        URL u = null;
        try {
            u = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.url = u;
    }

    protected void realRun() {
        this.progressMonitor.setTicksCount(2);
        this.sel = this.mode != SearchAction.SearchMode.remove ? new LinkedList() : Main.main.getCurrentDataSet().allNonDeletedPrimitives();
        try {
            URLConnection con = this.url.openConnection();
            this.progressMonitor.subTask(I18n.tr("Contact {0}...", this.url.getHost()));
            ProgressInputStream in = new ProgressInputStream(con, this.progressMonitor.createSubTaskMonitor(1, true));
            this.progressMonitor.subTask(I18n.tr("Downloading..."));
            Map<Long, String> ids = this.idReader.parseIds(in);
            for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
                if (!ids.containsKey(osm.getId()) || !osm.getClass().getName().toLowerCase().endsWith(ids.get(osm.getId()))) continue;
                if (this.mode == SearchAction.SearchMode.remove) {
                    this.sel.remove(osm);
                    continue;
                }
                this.sel.add(osm);
            }
            this.progressMonitor.worked(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read from URL: \"{0}\"", this.url), I18n.tr("Error"), 0);
        }
        catch (SAXException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Parsing error in URL: \"{0}\"", this.url), I18n.tr("Error"), 0);
        }
        catch (OsmTransferException e) {
            e.printStackTrace();
            if (e.getCause() != null) {
                if (e.getCause() instanceof IOException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read from URL: \"{0}\"", this.url), I18n.tr("Error"), 0);
                } else if (e.getCause() instanceof SAXException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Parsing error in URL: \"{0}\"", this.url), I18n.tr("Error"), 0);
                }
            }
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while communicating with server.", this.url), I18n.tr("Error"), 0);
        }
    }

    protected void cancel() {
        this.sel = null;
        this.idReader.cancel();
    }

    protected void finish() {
        if (this.sel != null) {
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }
}

