/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPrimitivesCommand
extends Command {
    private final List<PrimitiveData> data = new ArrayList<PrimitiveData>();

    public AddPrimitivesCommand(List<PrimitiveData> data) {
        this.data.addAll(data);
    }

    @Override
    public boolean executeCommand() {
        ArrayList<OsmPrimitive> createdPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
        for (PrimitiveData pd : this.data) {
            createdPrimitives.add(this.getLayer().data.getPrimitiveById(pd.getId(), OsmPrimitiveType.fromData(pd), true));
        }
        for (int i = 0; i < createdPrimitives.size(); ++i) {
            ((OsmPrimitive)createdPrimitives.get(i)).load(this.data.get(i), this.getLayer().data);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        for (PrimitiveData p : this.data) {
            this.getLayer().data.removePrimitive(p.getId(), OsmPrimitiveType.fromData(p));
        }
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Added {0} objects", this.data.size()), null, 0));
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }
}

