/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayNodesConflictResolverCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(WayNodesConflictResolverCommand.class.getName());
    private Conflict<Way> conflict;
    private final List<Node> mergedNodeList;

    public WayNodesConflictResolverCommand(Way my, Way their, List<Node> mergedNodeList) {
        this.conflict = new Conflict<Way>(my, their);
        this.mergedNodeList = mergedNodeList;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve conflicts in node list of way {0}", this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (Node n : this.mergedNodeList) {
            if (this.getLayer().data.nodes.contains(n)) continue;
            logger.warning(I18n.tr("Main dataset does not include node {0}", n.toString()));
        }
        this.conflict.getMy().setNodes(this.mergedNodeList);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }
}

