/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static PrefixSuffixSwitcher[] prefixSuffixSwitchers = new PrefixSuffixSwitcher[]{new PrefixSuffixSwitcher("left", "right"), new PrefixSuffixSwitcher("forward", "backward"), new PrefixSuffixSwitcher("forwards", "backwards")};

    @Override
    public Collection<Command> execute(Way oldway, Way way) throws UserCancelException {
        HashMap<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
        primitives.add(way);
        primitives.addAll(way.getNodes());
        for (OsmPrimitive primitive : primitives) {
            tagCorrectionsMap.put(primitive, new ArrayList());
            Iterator<String> i$ = primitive.keySet().iterator();
            while (i$.hasNext()) {
                String newValue;
                String value;
                String newKey;
                String key;
                block10: {
                    PrefixSuffixSwitcher prefixSuffixSwitcher;
                    block8: {
                        block9: {
                            newKey = key = i$.next();
                            newValue = value = primitive.get(key);
                            if (!key.equals("oneway")) break block8;
                            if (!value.equals("-1")) break block9;
                            newValue = "yes";
                            break block10;
                        }
                        Boolean boolValue = OsmUtils.getOsmBoolean(value);
                        if (boolValue == null || !boolValue.booleanValue()) break block10;
                        newValue = "-1";
                        break block10;
                    }
                    PrefixSuffixSwitcher[] arr$ = prefixSuffixSwitchers;
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$ && key.equals(newKey = (prefixSuffixSwitcher = arr$[i$2]).apply(key)); ++i$2) {
                    }
                }
                if (key.equals(newKey) && value.equals(newValue)) continue;
                ((List)tagCorrectionsMap.get(primitive)).add(new TagCorrection(key, value, newKey, newValue));
            }
        }
        HashMap<OsmPrimitive, List<RoleCorrection>> roleCorrectionMap = new HashMap<OsmPrimitive, List<RoleCorrection>>();
        roleCorrectionMap.put(way, new ArrayList());
        for (Relation relation : Main.main.getCurrentDataSet().relations) {
            int position = 0;
            for (RelationMember member : relation.getMembers()) {
                if (!member.getMember().hasEqualSemanticAttributes(oldway) || !member.hasRole()) {
                    ++position;
                    continue;
                }
                boolean found = false;
                String newRole = null;
                for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                    newRole = prefixSuffixSwitcher.apply(member.getRole());
                    if (newRole.equals(member.getRole())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    ((List)roleCorrectionMap.get(way)).add(new RoleCorrection(relation, position, member, newRole));
                }
                ++position;
            }
        }
        return this.applyCorrections(tagCorrectionsMap, roleCorrectionMap, I18n.tr("When reversing this way, the following changes to properties of the way and its nodes are suggested in order to maintain data consistency."));
    }

    private static class PrefixSuffixSwitcher {
        private final String a;
        private final String b;
        private final Pattern startPattern;
        private final Pattern endPattern;
        private final String SEPARATOR = "[:_]?";

        public PrefixSuffixSwitcher(String a, String b) {
            this.a = a;
            this.b = b;
            this.startPattern = Pattern.compile("^(" + a + "|" + b + ")(" + "[:_]?" + "|$)", 2);
            this.endPattern = Pattern.compile("^.*[:_]?(" + a + "|" + b + ")$", 2);
        }

        public String apply(String text) {
            Matcher m = this.startPattern.matcher(text);
            if (!m.lookingAt()) {
                m = this.endPattern.matcher(text);
            }
            if (m.lookingAt()) {
                String leftRight = m.group(1).toLowerCase();
                StringBuilder result = new StringBuilder();
                result.append(text.substring(0, m.start(1)));
                result.append(leftRight.equals(this.a) ? this.b : this.a);
                result.append(text.substring(m.end(1)));
                return result.toString();
            }
            return text;
        }
    }
}

