/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeRelationMemberRoleCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.Correction;
import org.openstreetmap.josm.corrector.CorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.RoleCorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrectionTable;
import org.openstreetmap.josm.corrector.TagCorrectionTableModel;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagCorrector<P extends OsmPrimitive> {
    private String[] applicationOptions = new String[]{I18n.tr("Apply selected changes"), I18n.tr("Don't apply changes"), I18n.tr("Cancel")};

    public abstract Collection<Command> execute(P var1, P var2) throws UserCancelException;

    protected Collection<Command> applyCorrections(Map<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap, Map<OsmPrimitive, List<RoleCorrection>> roleCorrectionMap, String description) throws UserCancelException {
        boolean hasCorrections = false;
        for (List<TagCorrection> list : tagCorrectionsMap.values()) {
            if (list.isEmpty()) continue;
            hasCorrections = true;
            break;
        }
        if (!hasCorrections) {
            for (List<Correction> list : roleCorrectionMap.values()) {
                if (list.isEmpty()) continue;
                hasCorrections = true;
                break;
            }
        }
        if (hasCorrections) {
            JScrollPane scrollPane;
            CorrectionTable table;
            JLabel primitiveLabel;
            ArrayList<Command> commands = new ArrayList<Command>();
            HashMap<OsmPrimitive, TagCorrectionTable> hashMap = new HashMap<OsmPrimitive, TagCorrectionTable>();
            HashMap<OsmPrimitive, TagCorrectionTable> roleTableMap = new HashMap<OsmPrimitive, TagCorrectionTable>();
            JPanel p = new JPanel(new GridBagLayout());
            JMultilineLabel label1 = new JMultilineLabel(description);
            label1.setMaxWidth(600);
            p.add((Component)label1, GBC.eop().anchor(10));
            JMultilineLabel label2 = new JMultilineLabel(I18n.tr("Please select which property changes you want to apply."));
            label2.setMaxWidth(600);
            p.add((Component)label2, GBC.eop().anchor(10));
            for (OsmPrimitive primitive : tagCorrectionsMap.keySet()) {
                List<TagCorrection> tagCorrections = tagCorrectionsMap.get(primitive);
                if (tagCorrections.isEmpty()) continue;
                JLabel propertiesLabel = new JLabel(I18n.tr("Properties of "));
                p.add((Component)propertiesLabel, GBC.std());
                primitiveLabel = new JLabel(primitive.getDisplayName(DefaultNameFormatter.getInstance()) + ":", ImageProvider.get(OsmPrimitiveType.from(primitive)), 2);
                p.add((Component)primitiveLabel, GBC.eol());
                table = new TagCorrectionTable(tagCorrections);
                scrollPane = new JScrollPane(table);
                p.add((Component)scrollPane, GBC.eop().fill(2));
                hashMap.put(primitive, (TagCorrectionTable)table);
            }
            for (OsmPrimitive primitive : roleCorrectionMap.keySet()) {
                List<RoleCorrection> roleCorrections = roleCorrectionMap.get(primitive);
                if (roleCorrections.isEmpty()) continue;
                JLabel rolesLabel = new JLabel(I18n.tr("Roles in relations referring to"));
                p.add((Component)rolesLabel, GBC.std());
                primitiveLabel = new JLabel(primitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(primitive)), 2);
                p.add((Component)primitiveLabel, GBC.eol());
                table = new RoleCorrectionTable(roleCorrections);
                scrollPane = new JScrollPane(table);
                p.add((Component)scrollPane, GBC.eop().fill(2));
                roleTableMap.put(primitive, (TagCorrectionTable)table);
            }
            int answer = JOptionPane.showOptionDialog(Main.parent, p, I18n.tr("Automatic tag correction"), 1, -1, null, this.applicationOptions, this.applicationOptions[0]);
            if (answer == 0) {
                for (OsmPrimitive primitive : tagCorrectionsMap.keySet()) {
                    List<TagCorrection> tagCorrections = tagCorrectionsMap.get(primitive);
                    OsmPrimitive clone = null;
                    if (primitive instanceof Way) {
                        clone = new Way((Way)primitive);
                    } else if (primitive instanceof Node) {
                        clone = new Node((Node)primitive);
                    } else if (primitive instanceof Relation) {
                        clone = new Relation((Relation)primitive);
                    }
                    HashSet<String> keysChanged = new HashSet<String>();
                    for (int i = 0; i < tagCorrections.size(); ++i) {
                        if (!((TagCorrectionTableModel)((TagCorrectionTable)hashMap.get(primitive)).getCorrectionTableModel()).getApply(i)) continue;
                        TagCorrection tagCorrection = tagCorrections.get(i);
                        if (tagCorrection.isKeyChanged() && !keysChanged.contains(tagCorrection.oldKey)) {
                            clone.remove(tagCorrection.oldKey);
                        }
                        clone.put(tagCorrection.newKey, tagCorrection.newValue);
                        keysChanged.add(tagCorrection.newKey);
                    }
                    if (keysChanged.isEmpty()) continue;
                    commands.add(new ChangeCommand(primitive, clone));
                }
                for (OsmPrimitive primitive : roleCorrectionMap.keySet()) {
                    List<RoleCorrection> roleCorrections = roleCorrectionMap.get(primitive);
                    for (int i = 0; i < roleCorrections.size(); ++i) {
                        RoleCorrection roleCorrection = roleCorrections.get(i);
                        if (!((RoleCorrectionTableModel)((RoleCorrectionTable)roleTableMap.get(primitive)).getCorrectionTableModel()).getApply(i)) continue;
                        commands.add(new ChangeRelationMemberRoleCommand(roleCorrection.relation, roleCorrection.position, roleCorrection.newRole));
                    }
                }
            } else if (answer != 1) {
                throw new UserCancelException();
            }
            return commands;
        }
        return Collections.emptyList();
    }
}

