/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIDataSet {
    private LinkedList<OsmPrimitive> toAdd = new LinkedList();
    private LinkedList<OsmPrimitive> toUpdate = new LinkedList();
    private LinkedList<OsmPrimitive> toDelete = new LinkedList();

    public APIDataSet() {
    }

    public void init(DataSet ds) {
        if (ds == null) {
            return;
        }
        this.toAdd.clear();
        this.toUpdate.clear();
        this.toDelete.clear();
        for (OsmPrimitive osm : ds.allPrimitives()) {
            if (osm.get("josm/ignore") != null) continue;
            if (osm.isNew() && !osm.isDeleted()) {
                this.toAdd.addLast(osm);
                continue;
            }
            if (osm.isModified() && !osm.isDeleted()) {
                this.toUpdate.addLast(osm);
                continue;
            }
            if (!osm.isDeleted() || osm.isNew() || !osm.isModified()) continue;
            this.toDelete.addFirst(osm);
        }
        this.sortDeleted();
    }

    protected void sortDeleted() {
        Collections.sort(this.toDelete, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive o1, OsmPrimitive o2) {
                if (o1 instanceof Node && o2 instanceof Node) {
                    return 0;
                }
                if (o1 instanceof Node) {
                    return 1;
                }
                if (o2 instanceof Node) {
                    return -1;
                }
                if (o1 instanceof Way && o2 instanceof Way) {
                    return 0;
                }
                if (o1 instanceof Way && o2 instanceof Relation) {
                    return 1;
                }
                if (o2 instanceof Way && o1 instanceof Relation) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public APIDataSet(DataSet ds) {
        this();
        this.init(ds);
    }

    public APIDataSet(Collection<OsmPrimitive> primitives) {
        this();
        this.toAdd.clear();
        this.toUpdate.clear();
        this.toDelete.clear();
        for (OsmPrimitive osm : primitives) {
            if (osm.isNew() && !osm.isDeleted()) {
                this.toAdd.addLast(osm);
                continue;
            }
            if (osm.isModified() && !osm.isDeleted()) {
                this.toUpdate.addLast(osm);
                continue;
            }
            if (!osm.isDeleted() || osm.isNew() || !osm.isModified()) continue;
            this.toDelete.addFirst(osm);
        }
        this.sortDeleted();
    }

    public boolean isEmpty() {
        return this.toAdd.isEmpty() && this.toUpdate.isEmpty() && this.toDelete.isEmpty();
    }

    public List<OsmPrimitive> getPrimitivesToAdd() {
        return this.toAdd;
    }

    public List<OsmPrimitive> getPrimitivesToUpdate() {
        return this.toUpdate;
    }

    public List<OsmPrimitive> getPrimitivesToDelete() {
        return this.toDelete;
    }

    public List<OsmPrimitive> getPrimitives() {
        LinkedList<OsmPrimitive> ret = new LinkedList<OsmPrimitive>();
        ret.addAll(this.toAdd);
        ret.addAll(this.toUpdate);
        ret.addAll(this.toDelete);
        return ret;
    }

    public void adjustRelationUploadOrder() throws CyclicUploadDependencyException {
        LinkedList<OsmPrimitive> newToAdd = new LinkedList<OsmPrimitive>();
        newToAdd.addAll(OsmPrimitive.getFilteredList(this.toAdd, Node.class));
        newToAdd.addAll(OsmPrimitive.getFilteredList(this.toAdd, Way.class));
        List<Relation> relationsToAdd = OsmPrimitive.getFilteredList(this.toAdd, Relation.class);
        List<Relation> noProblemRelations = this.filterRelationsNotReferringToNewRelations(relationsToAdd);
        newToAdd.addAll(noProblemRelations);
        relationsToAdd.removeAll(noProblemRelations);
        RelationUploadDependencyGraph graph = new RelationUploadDependencyGraph(relationsToAdd);
        newToAdd.addAll(graph.computeUploadOrder());
        this.toAdd = newToAdd;
    }

    protected List<Relation> filterRelationsNotReferringToNewRelations(Collection<Relation> relations) {
        LinkedList<Relation> ret = new LinkedList<Relation>();
        for (Relation relation : relations) {
            boolean refersToNewRelation = false;
            for (RelationMember m : relation.getMembers()) {
                if (!m.isRelation() || !m.getMember().isNew()) continue;
                refersToNewRelation = true;
                break;
            }
            if (refersToNewRelation) continue;
            ret.add(relation);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationUploadDependencyGraph {
        private final Logger logger = Logger.getLogger(RelationUploadDependencyGraph.class.getName());
        private HashMap<Relation, Set<Relation>> children = new HashMap();
        private Collection<Relation> relations;
        private Set<Relation> visited = new HashSet<Relation>();
        private List<Relation> uploadOrder;

        public RelationUploadDependencyGraph() {
        }

        public RelationUploadDependencyGraph(Collection<Relation> relations) {
            this();
            this.build(relations);
        }

        public void build(Collection<Relation> relations) {
            this.relations = new HashSet<Relation>();
            for (Relation relation : relations) {
                if (!relation.isNew()) continue;
                this.relations.add(relation);
                for (RelationMember m : relation.getMembers()) {
                    if (!m.isRelation() || !m.getMember().isNew()) continue;
                    this.addDependency(relation, (Relation)m.getMember());
                }
            }
        }

        public Set<Relation> getChildren(Relation relation) {
            Set<Relation> p = this.children.get(relation);
            if (p == null) {
                p = new HashSet<Relation>();
                this.children.put(relation, p);
            }
            return p;
        }

        public void addDependency(Relation relation, Relation child) {
            this.getChildren(relation).add(child);
        }

        protected void visit(Stack<Relation> path, Relation current) throws CyclicUploadDependencyException {
            if (path.contains(current)) {
                path.push(current);
                throw new CyclicUploadDependencyException(path);
            }
            if (!this.visited.contains(current)) {
                path.push(current);
                this.visited.add(current);
                for (Relation dependent : this.getChildren(current)) {
                    this.visit(path, dependent);
                }
                this.uploadOrder.add(current);
                path.pop();
            }
        }

        public List<Relation> computeUploadOrder() throws CyclicUploadDependencyException {
            this.visited = new HashSet<Relation>();
            this.uploadOrder = new LinkedList<Relation>();
            Stack<Relation> path = new Stack<Relation>();
            for (Relation relation : this.relations) {
                this.visit(path, relation);
            }
            ArrayList<Relation> ret = new ArrayList<Relation>(this.relations);
            Collections.sort(ret, new Comparator<Relation>(){

                @Override
                public int compare(Relation o1, Relation o2) {
                    return Integer.valueOf(RelationUploadDependencyGraph.this.uploadOrder.indexOf(o1)).compareTo(RelationUploadDependencyGraph.this.uploadOrder.indexOf(o2));
                }
            });
            return ret;
        }
    }
}

