/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.data.coor.LatLon;

public class Bounds {
    public LatLon min;
    public LatLon max;

    public Bounds(LatLon min, LatLon max) {
        this.min = min;
        this.max = max;
    }

    public Bounds(LatLon b) {
        this.min = b;
        this.max = b;
    }

    public String toString() {
        return "Bounds[" + this.min.lat() + "," + this.min.lon() + "," + this.max.lat() + "," + this.max.lon() + "]";
    }

    public LatLon getCenter() {
        return this.min.getCenter(this.max);
    }

    public void extend(LatLon ll) {
        if (ll.lat() < this.min.lat() || ll.lon() < this.min.lon()) {
            this.min = new LatLon(Math.min(ll.lat(), this.min.lat()), Math.min(ll.lon(), this.min.lon()));
        }
        if (ll.lat() > this.max.lat() || ll.lon() > this.max.lon()) {
            this.max = new LatLon(Math.max(ll.lat(), this.max.lat()), Math.max(ll.lon(), this.max.lon()));
        }
    }

    public boolean contains(LatLon ll) {
        if (ll.lat() < this.min.lat() || ll.lon() < this.min.lon()) {
            return false;
        }
        return !(ll.lat() > this.max.lat()) && !(ll.lon() > this.max.lon());
    }

    public Rectangle2D.Double asRect() {
        return new Rectangle2D.Double(this.min.lon(), this.min.lat(), this.max.lon() - this.min.lon(), this.max.lat() - this.min.lat());
    }
}

