/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Changeset
implements Tagged {
    private long id;
    private User user;
    private Date createdAt;
    private Date closedAt;
    private boolean open;
    private LatLon min;
    private LatLon max;
    private Map<String, String> tags;
    private boolean incomplete;

    public Changeset() {
        this.id = 0L;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(long id) {
        this.id = id;
        this.incomplete = id > 0L;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(Changeset other) {
        if (other == null) {
            this.id = 0L;
            this.tags = new HashMap<String, String>();
        } else if (other.isIncomplete()) {
            this.setId(other.getId());
            this.incomplete = true;
        } else {
            this.cloneFrom(other);
            this.incomplete = false;
        }
    }

    public void cloneFrom(Changeset other) {
        this.setId(other.getId());
        this.setUser(other.getUser());
        this.setCreatedAt(other.getCreatedAt());
        this.setClosedAt(other.getClosedAt());
        this.setMin(other.getMin());
        this.setMax(other.getMax());
        this.setKeys(other.getKeys());
        this.setOpen(other.isOpen());
    }

    public void visit(Visitor v) {
        v.visit(this);
    }

    public int compareTo(Changeset other) {
        return Long.valueOf(this.getId()).compareTo(other.getId());
    }

    public String getName() {
        return "changeset " + this.getId();
    }

    public String getLocalName() {
        return I18n.tr("Changeset {0}", this.getId());
    }

    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public LatLon getMin() {
        return this.min;
    }

    public void setMin(LatLon min) {
        this.min = min;
    }

    public LatLon getMax() {
        return this.max;
    }

    public void setMax(LatLon max) {
        this.max = max;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.tags;
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        this.tags = keys;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    @Override
    public void put(String key, String value) {
        this.tags.put(key, value);
    }

    @Override
    public String get(String key) {
        return this.tags.get(key);
    }

    @Override
    public void remove(String key) {
        this.tags.remove(key);
    }

    @Override
    public void removeAll() {
        this.tags.clear();
    }

    public boolean hasEqualSemanticAttributes(Changeset other) {
        if (other == null) {
            return false;
        }
        if (this.closedAt == null ? other.closedAt != null : !this.closedAt.equals(other.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        if (this.open != other.open) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        if (this.id > 0L) {
            return 31 * result + this.getClass().hashCode();
        }
        result = 31 * result + (this.closedAt == null ? 0 : this.closedAt.hashCode());
        result = 31 * result + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + (this.open ? 1231 : 1237);
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Changeset other = (Changeset)obj;
        if (this.id > 0L && other.id == this.id) {
            return true;
        }
        if (this.closedAt == null ? other.closedAt != null : !this.closedAt.equals(other.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        if (this.open != other.open) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @Override
    public boolean hasKeys() {
        return !this.tags.keySet().isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.tags.keySet();
    }
}

