/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class Filters
extends AbstractTableModel {
    public int disabledCount;
    public int hiddenCount;
    private List<Filter> filters = new LinkedList<Filter>();

    public Filters() {
        this.loadPrefs();
    }

    public void filter() {
        LinkedList<OsmPrimitive> seld = new LinkedList<OsmPrimitive>();
        LinkedList<OsmPrimitive> self = new LinkedList<OsmPrimitive>();
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Main.main.getCurrentDataSet().setFiltered(new OsmPrimitive[0]);
        Main.main.getCurrentDataSet().setDisabled(new OsmPrimitive[0]);
        for (Filter flt : this.filters) {
            if (!flt.enable.booleanValue()) continue;
            SearchAction.getSelection(flt, seld, new SearchAction.Function(){

                public Boolean isSomething(OsmPrimitive o) {
                    return o.isDisabled();
                }
            });
            if (!flt.hide.booleanValue()) continue;
            SearchAction.getSelection(flt, self, new SearchAction.Function(){

                public Boolean isSomething(OsmPrimitive o) {
                    return o.isFiltered();
                }
            });
        }
        this.disabledCount = seld.size() - self.size();
        this.hiddenCount = self.size();
        Main.main.getCurrentDataSet().setFiltered(self);
        Main.main.getCurrentDataSet().setDisabled(seld);
        Main.map.mapView.repaint();
    }

    private void loadPrefs() {
        Map<String, String> prefs = Main.pref.getAllPrefix("filters.filter");
        for (String value : prefs.values()) {
            Filter filter = new Filter(value);
            if (filter == null) continue;
            this.filters.add(filter);
        }
    }

    private void savePrefs() {
        Map<String, String> prefs = Main.pref.getAllPrefix("filters.filter");
        for (String key : prefs.keySet()) {
            String[] sts = key.split("\\.");
            if (sts.length != 3) {
                throw new Error("Incompatible filter preferences");
            }
            Main.pref.put("filters.filter." + sts[2], null);
        }
        int i = 0;
        for (Filter flt : this.filters) {
            Main.pref.put("filters.filter." + i++, flt.getPrefString());
        }
    }

    private void savePref(int i) {
        if (i >= this.filters.size()) {
            Main.pref.put("filters.filter." + i, null);
        } else {
            Main.pref.put("filters.filter." + i, this.filters.get(i).getPrefString());
        }
    }

    public void addFilter(Filter f) {
        this.filters.add(f);
        this.savePref(this.filters.size() - 1);
        this.filter();
        this.fireTableRowsInserted(this.filters.size() - 1, this.filters.size() - 1);
    }

    public void moveDownFilter(int i) {
        if (i >= this.filters.size() - 1) {
            return;
        }
        this.filters.add(i + 1, this.filters.remove(i));
        this.savePref(i);
        this.savePref(i + 1);
        this.filter();
        this.fireTableRowsUpdated(i, i + 1);
    }

    public void moveUpFilter(int i) {
        if (i == 0) {
            return;
        }
        this.filters.add(i - 1, this.filters.remove(i));
        this.savePref(i);
        this.savePref(i - 1);
        this.filter();
        this.fireTableRowsUpdated(i - 1, i);
    }

    public void removeFilter(int i) {
        this.filters.remove(i);
        this.savePrefs();
        this.filter();
        this.fireTableRowsDeleted(i, i);
    }

    public void setFilter(int i, Filter f) {
        this.filters.set(i, f);
        this.savePref(i);
        this.filter();
        this.fireTableRowsUpdated(i, i);
    }

    public Filter getFilter(int i) {
        return this.filters.get(i);
    }

    public int getRowCount() {
        return this.filters.size();
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int column) {
        String[] names = new String[]{I18n.trc("filter", "E"), I18n.tr("H"), I18n.tr("Text"), I18n.tr("C"), I18n.tr("I"), I18n.tr("M")};
        return names[column];
    }

    public Class getColumnClass(int column) {
        Class[] classes = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, Boolean.class, String.class};
        return classes[column];
    }

    public boolean isCellEnabled(int row, int column) {
        return this.filters.get((int)row).enable != false || column == 0;
    }

    public boolean isCellEditable(int row, int column) {
        if (!this.filters.get((int)row).enable.booleanValue() && column != 0) {
            return false;
        }
        return column < 5;
    }

    public void setValueAt(Object aValue, int row, int column) {
        Filter f = this.filters.get(row);
        switch (column) {
            case 0: {
                f.enable = (Boolean)aValue;
                this.savePref(row);
                this.filter();
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 1: {
                f.hide = (Boolean)aValue;
                this.savePref(row);
                this.filter();
                break;
            }
            case 2: {
                f.text = (String)aValue;
                this.savePref(row);
                break;
            }
            case 3: {
                f.applyForChildren = (Boolean)aValue;
                this.savePref(row);
                this.filter();
                break;
            }
            case 4: {
                f.inverted = (Boolean)aValue;
                this.savePref(row);
                this.filter();
            }
        }
        if (column != 0) {
            this.fireTableCellUpdated(row, column);
        }
    }

    public Object getValueAt(int row, int column) {
        Filter f = this.filters.get(row);
        switch (column) {
            case 0: {
                return f.enable;
            }
            case 1: {
                return f.hide;
            }
            case 2: {
                return f.text;
            }
            case 3: {
                return f.applyForChildren;
            }
            case 4: {
                return f.inverted;
            }
            case 5: {
                switch (f.mode) {
                    case replace: {
                        return I18n.tr("R");
                    }
                    case add: {
                        return I18n.tr("A");
                    }
                    case remove: {
                        return I18n.tr("D");
                    }
                    case in_selection: {
                        return I18n.tr("F");
                    }
                }
            }
        }
        return null;
    }
}

