/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectBackReferencesVisitor
extends AbstractVisitor {
    private final DataSet ds;
    private final boolean indirectRefs;
    private Collection<OsmPrimitive> data = new HashSet<OsmPrimitive>();
    private Map<OsmPrimitive, Collection<OsmPrimitive>> lookupTable = new HashMap<OsmPrimitive, Collection<OsmPrimitive>>();

    public CollectBackReferencesVisitor(DataSet ds) {
        this(ds, true);
    }

    public CollectBackReferencesVisitor(DataSet ds, boolean indirectRefs) {
        this.ds = ds;
        this.indirectRefs = indirectRefs;
        if (ds != null) {
            this.makeLookupTable();
        }
    }

    private void makeLookupTable() {
        for (Way w : this.ds.ways) {
            for (Node n : w.getNodes()) {
                if (!this.lookupTable.containsKey(n)) {
                    this.lookupTable.put(n, new HashSet());
                }
                this.lookupTable.get(n).add(w);
            }
        }
        for (Relation r : this.ds.relations) {
            for (RelationMember m : r.getMembers()) {
                OsmPrimitive o = m.getMember();
                if (!this.lookupTable.containsKey(o)) {
                    this.lookupTable.put(o, new HashSet());
                }
                this.lookupTable.get(o).add(r);
            }
        }
    }

    public Collection<OsmPrimitive> getData() {
        return this.data;
    }

    public void initialize() {
        this.data = new HashSet<OsmPrimitive>();
    }

    public void visit(OsmPrimitive o) {
        if (this.lookupTable.containsKey(o)) {
            Collection<OsmPrimitive> c = this.lookupTable.get(o);
            HashSet<OsmPrimitive> oldData = new HashSet<OsmPrimitive>(this.data);
            this.data.addAll(c);
            if (this.indirectRefs) {
                for (OsmPrimitive oo : c) {
                    if (oldData.contains(oo)) continue;
                    this.visit(oo);
                }
            }
        }
    }

    @Override
    public void visit(Node n) {
        this.visit((OsmPrimitive)n);
    }

    @Override
    public void visit(Way w) {
        this.visit((OsmPrimitive)w);
    }

    @Override
    public void visit(Relation r) {
        this.visit((OsmPrimitive)r);
    }
}

