/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOsmChangeVisitor
extends AbstractVisitor {
    private String currentMode;
    private PrintWriter writer;
    private StringWriter swriter = new StringWriter();
    private OsmWriter osmwriter;
    private OsmApi api;

    public CreateOsmChangeVisitor(Changeset changeset, OsmApi api) {
        this.writer = new PrintWriter(this.swriter);
        this.writer.write("<osmChange version=\"");
        this.writer.write(api.getVersion());
        this.writer.write("\" generator=\"JOSM\">\n");
        this.api = api;
        this.osmwriter = new OsmWriter(this.writer, false, api.getVersion());
        this.osmwriter.setChangeset(changeset);
    }

    @Override
    public void visit(Node n) {
        if (n.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            this.osmwriter.visit(n);
        } else {
            this.switchMode(n.isNew() ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            this.osmwriter.visit(n);
        }
    }

    @Override
    public void visit(Way w) {
        if (w.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            this.osmwriter.visit(w);
        } else {
            this.switchMode(w.isNew() ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            this.osmwriter.visit(w);
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            this.osmwriter.visit(r);
        } else {
            this.switchMode(r.isNew() ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            this.osmwriter.visit(r);
        }
    }

    private void switchMode(String newMode) {
        if (newMode != null && !newMode.equals(this.currentMode) || newMode == null && this.currentMode != null) {
            if (this.currentMode != null) {
                this.writer.write("</");
                this.writer.write(this.currentMode);
                this.writer.write(">\n");
            }
            if (newMode != null) {
                this.writer.write("<");
                this.writer.write(newMode);
                this.writer.write(" version=\"");
                this.writer.write(this.api.getVersion());
                this.writer.write("\" generator=\"JOSM\">\n");
            }
            this.currentMode = newMode;
        }
    }

    public String getDocument() {
        this.switchMode(null);
        return this.swriter.toString() + "</osmChange>\n";
    }

    public Map<OsmPrimitive, Long> getNewIdMap() {
        return this.osmwriter.usedNewIds;
    }
}

