/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;

public class SimplePaintVisitor
extends AbstractVisitor {
    public static final Color darkerblue = new Color(0, 0, 96);
    public static final Color darkblue = new Color(0, 0, 128);
    public static final Color darkgreen = new Color(0, 128, 0);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color lightteal = new Color(0, 255, 186);
    protected Graphics g;
    protected NavigatableComponent nc;
    public boolean inactive;
    protected static final double PHI = Math.toRadians(20.0);
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color nodeColor;
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color incompleteColor;
    protected Color backgroundColor;
    protected Color highlightColor;
    protected boolean showDirectionArrow;
    protected boolean showRelevantDirectionsOnly;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected int selectedNodeRadius;
    protected int unselectedNodeRadius;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int defaultSegmentWidth;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;
    protected int taggedNodeRadius;
    protected int taggedNodeSize;
    protected Color currentColor = null;
    protected GeneralPath currentPath = new GeneralPath();
    Rectangle bbox = new Rectangle();
    DataSet ds;
    private Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);

    public void getColors() {
        this.inactiveColor = Main.pref.getColor(I18n.marktr("inactive"), Color.darkGray);
        this.selectedColor = Main.pref.getColor(I18n.marktr("selected"), Color.red);
        this.nodeColor = Main.pref.getColor(I18n.marktr("node"), Color.yellow);
        this.dfltWayColor = Main.pref.getColor(I18n.marktr("way"), darkblue);
        this.relationColor = Main.pref.getColor(I18n.marktr("relation"), teal);
        this.untaggedWayColor = Main.pref.getColor(I18n.marktr("untagged way"), darkgreen);
        this.incompleteColor = Main.pref.getColor(I18n.marktr("incomplete way"), darkerblue);
        this.backgroundColor = Main.pref.getColor(I18n.marktr("background"), Color.BLACK);
        this.highlightColor = Main.pref.getColor(I18n.marktr("highlight"), lightteal);
    }

    protected void getSettings(Boolean virtual) {
        this.showDirectionArrow = Main.pref.getBoolean("draw.segment.direction", true);
        this.showRelevantDirectionsOnly = Main.pref.getBoolean("draw.segment.relevant_directions_only", true);
        this.showHeadArrowOnly = Main.pref.getBoolean("draw.segment.head_only", false);
        this.showOrderNumber = Main.pref.getBoolean("draw.segment.order_number", false);
        this.selectedNodeRadius = Main.pref.getInteger("mappaint.node.selected-size", 5) / 2;
        this.selectedNodeSize = this.selectedNodeRadius * 2;
        this.unselectedNodeRadius = Main.pref.getInteger("mappaint.node.unselected-size", 3) / 2;
        this.unselectedNodeSize = this.unselectedNodeRadius * 2;
        this.taggedNodeRadius = Main.pref.getInteger("mappaint.node.tagged-size", 5) / 2;
        this.taggedNodeSize = this.taggedNodeRadius * 2;
        this.defaultSegmentWidth = Main.pref.getInteger("mappaint.segment.default-width", 2);
        this.fillSelectedNode = Main.pref.getBoolean("mappaint.node.fill-selected", true);
        this.fillUnselectedNode = Main.pref.getBoolean("mappaint.node.fill-unselected", false);
        this.virtualNodeSize = virtual != false ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
        ((Graphics2D)this.g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void visitAll(DataSet data, Boolean virtual) {
        this.ds = data;
        this.getSettings(virtual);
        for (OsmPrimitive osmPrimitive : data.relations) {
            if (osmPrimitive.isDeleted() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isFiltered()) continue;
            osmPrimitive.visit(this);
        }
        for (OsmPrimitive osmPrimitive : data.ways) {
            if (osmPrimitive.isDeleted() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isFiltered() || !osmPrimitive.isTagged()) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.ways) {
            if (osmPrimitive.isDeleted() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isFiltered() || osmPrimitive.isTagged()) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (osmPrimitive.isDeleted()) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.nodes) {
            if (osmPrimitive.isDeleted() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isFiltered()) continue;
            osmPrimitive.visit(this);
        }
        if (this.virtualNodeSize != 0) {
            this.currentColor = this.nodeColor;
            for (OsmPrimitive osmPrimitive : data.ways) {
                if (osmPrimitive.isDeleted() || osmPrimitive.isDisabled() || osmPrimitive.isFiltered()) continue;
                this.visitVirtual((Way)osmPrimitive);
            }
            this.displaySegments();
        }
    }

    public void visit(Node n) {
        if (n.incomplete) {
            return;
        }
        if (this.inactive || n.isDisabled()) {
            this.drawNode(n, this.inactiveColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        } else if (n.highlighted) {
            this.drawNode(n, this.highlightColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (this.ds.isSelected(n)) {
            this.drawNode(n, this.selectedColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (n.isTagged()) {
            this.drawNode(n, this.nodeColor, this.taggedNodeSize, this.taggedNodeRadius, this.fillUnselectedNode);
        } else {
            this.drawNode(n, this.nodeColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        }
    }

    public static Boolean isLargeSegment(Point p1, Point p2, int space) {
        int yd;
        int xd = p1.x - p2.x;
        if (xd < 0) {
            xd = -xd;
        }
        if ((yd = p1.y - p2.y) < 0) {
            yd = -yd;
        }
        return xd + yd > space;
    }

    public void visitVirtual(Way w) {
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                if (this.isSegmentVisible(lastP, p) && SimplePaintVisitor.isLargeSegment(lastP, p, this.virtualNodeSpace).booleanValue()) {
                    int x = (p.x + lastP.x) / 2;
                    int y = (p.y + lastP.y) / 2;
                    this.currentPath.moveTo(x - this.virtualNodeSize, y);
                    this.currentPath.lineTo(x + this.virtualNodeSize, y);
                    this.currentPath.moveTo(x, y - this.virtualNodeSize);
                    this.currentPath.lineTo(x, y + this.virtualNodeSize);
                }
                lastP = p;
            }
        }
    }

    public void visit(Way w) {
        boolean showOnlyHeadArrowOnly;
        if (w.incomplete || w.getNodesCount() < 2) {
            return;
        }
        boolean showThisDirectionArrow = this.ds.isSelected(w) || this.showDirectionArrow && (!this.showRelevantDirectionsOnly || w.hasDirectionKeys());
        boolean bl = showOnlyHeadArrowOnly = showThisDirectionArrow && !this.ds.isSelected(w) && this.showHeadArrowOnly;
        Color wayColor = this.inactive || w.isDisabled() ? this.inactiveColor : (w.highlighted ? this.highlightColor : (this.ds.isSelected(w) ? this.selectedColor : (!w.isTagged() ? this.untaggedWayColor : this.dfltWayColor)));
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            int orderNumber = 1;
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                this.drawSegment(lastP, p, wayColor, showOnlyHeadArrowOnly ? !it.hasNext() : showThisDirectionArrow);
                if (this.showOrderNumber) {
                    this.drawOrderNumber(lastP, p, orderNumber);
                }
                lastP = p;
                ++orderNumber;
            }
        }
    }

    public void visit(Relation r) {
        if (r.incomplete) {
            return;
        }
        Color col = this.inactive || r.isDisabled() ? this.inactiveColor : (this.ds.isSelected(r) ? this.selectedColor : this.relationColor);
        this.g.setColor(col);
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().incomplete || m.getMember().isDeleted()) continue;
            if (m.isNode()) {
                Point p = this.nc.getPoint(m.getNode());
                if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) continue;
                this.g.drawOval(p.x - 3, p.y - 3, 6, 6);
                continue;
            }
            if (!m.isWay()) continue;
            GeneralPath path = new GeneralPath();
            boolean first = true;
            for (Node n : m.getWay().getNodes()) {
                if (n.incomplete || n.isDeleted()) continue;
                Point p = this.nc.getPoint(n);
                if (first) {
                    path.moveTo(p.x, p.y);
                    first = false;
                    continue;
                }
                path.lineTo(p.x, p.y);
            }
            ((Graphics2D)this.g).draw(this.relatedWayStroke.createStrokedShape(path));
        }
    }

    protected void drawOrderNumber(Point p1, Point p2, int orderNumber) {
        if (this.isSegmentVisible(p1, p2) && SimplePaintVisitor.isLargeSegment(p1, p2, this.segmentNumberSpace).booleanValue()) {
            String on = Integer.toString(orderNumber);
            int strlen = on.length();
            int x = (p1.x + p2.x) / 2 - 4 * strlen;
            int y = (p1.y + p2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && SimplePaintVisitor.isLargeSegment(p1, p2, this.virtualNodeSpace).booleanValue()) {
                y = (p1.y + p2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.displaySegments();
            Color c = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(x - 1, y - 12, 8 * strlen + 1, 14);
            this.g.setColor(c);
            this.g.drawString(on, x, y);
        }
    }

    public void drawNode(Node n, Color color, int size, int radius, boolean fill) {
        if (size > 1) {
            Point p = this.nc.getPoint(n);
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (fill) {
                this.g.fillRect(p.x - radius, p.y - radius, size, size);
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            } else {
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            }
        }
    }

    protected void drawSegment(Point p1, Point p2, Color col, boolean showDirection) {
        if (col != this.currentColor) {
            this.displaySegments(col);
        }
        if (this.isSegmentVisible(p1, p2)) {
            this.currentPath.moveTo(p1.x, p1.y);
            this.currentPath.lineTo(p2.x, p2.y);
            if (showDirection) {
                double t = Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI;
                this.currentPath.lineTo((int)((double)p2.x + 10.0 * Math.cos(t - PHI)), (int)((double)p2.y + 10.0 * Math.sin(t - PHI)));
                this.currentPath.moveTo((int)((double)p2.x + 10.0 * Math.cos(t + PHI)), (int)((double)p2.y + 10.0 * Math.sin(t + PHI)));
                this.currentPath.lineTo(p2.x, p2.y);
            }
        }
    }

    protected boolean isSegmentVisible(Point p1, Point p2) {
        if (p1.x < 0 && p2.x < 0) {
            return false;
        }
        if (p1.y < 0 && p2.y < 0) {
            return false;
        }
        if (p1.x > this.nc.getWidth() && p2.x > this.nc.getWidth()) {
            return false;
        }
        return p1.y <= this.nc.getHeight() || p2.y <= this.nc.getHeight();
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle bounds = polygon.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            return false;
        }
        if (bounds.x > this.nc.getWidth()) {
            return false;
        }
        if (bounds.y > this.nc.getHeight()) {
            return false;
        }
        if (bounds.x + bounds.width < 0) {
            return false;
        }
        return bounds.y + bounds.height >= 0;
    }

    public void setGraphics(Graphics g) {
        this.g = g;
    }

    public void setNavigatableComponent(NavigatableComponent nc) {
        this.nc = nc;
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color newColor) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            ((Graphics2D)this.g).draw(this.currentPath);
            this.currentPath = new GeneralPath();
            this.currentColor = newColor;
        }
    }
}

