/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class Lambert
implements Projection {
    public static final double[] n = new double[]{0.7604059656, 0.7289686274, 0.6959127966, 0.6712679322};
    public static final double[] c = new double[]{1.160379698E7, 1.174579339E7, 1.194799252E7, 1.213628199E7};
    public static final double[] Xs = new double[]{600000.0, 600000.0, 600000.0, 234.358};
    public static final double[] Ys = new double[]{5657616.674, 6199695.768, 6791905.085, 7239161.542};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-11;
    public static final double cMaxLatZone1 = Math.toRadians(51.300000000000004);
    public static final double[] zoneLimits = new double[]{Math.toRadians(48.15), Math.toRadians(45.45), Math.toRadians(42.767667), Math.toRadians(41.560389)};
    public static final double cMinLonZones = Math.toRadians(-4.416666666666665);
    public static final double cMaxLonZones = Math.toRadians(9.18);
    public static final double cMaxOverlappingZones = Math.toRadians(1.35);
    public static int layoutZone = -1;
    private static int currentZone = 0;

    public EastNorth latlon2eastNorth(LatLon p) {
        LatLon geo = this.GRS802Clark(p);
        double lt = geo.lat();
        double lg = geo.lon();
        currentZone = 0;
        boolean outOfLambertZones = false;
        if (lt >= zoneLimits[3] && lt <= cMaxLatZone1 && lg >= cMinLonZones && lg <= cMaxLonZones) {
            if (lt > zoneLimits[0]) {
                currentZone = 0;
            } else if (lt > zoneLimits[1]) {
                currentZone = 1;
            } else if (lt > zoneLimits[2]) {
                currentZone = 2;
            } else if (lt > zoneLimits[3]) {
                currentZone = lg < Math.toRadians(7.2) ? 2 : 3;
            }
        } else {
            outOfLambertZones = true;
        }
        if (!outOfLambertZones) {
            if (layoutZone == -1) {
                layoutZone = currentZone;
            } else if (layoutZone != currentZone) {
                if (this.farawayFromLambertZoneFrance(lt, lg)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("IMPORTANT : data positioned far away from\nthe current Lambert zone limits.\nDo not upload any data after this message.\nUndo your last action, save your work\nand start a new layer on the new zone."), I18n.tr("Warning"), 2);
                    layoutZone = -1;
                } else {
                    System.out.println("temporarily extend Lambert zone " + layoutZone + " projection at lat,lon:" + lt + "," + lg);
                }
            }
        }
        if (layoutZone == -1) {
            return this.ConicProjection(lt, lg, Xs[currentZone], Ys[currentZone], c[currentZone], n[currentZone]);
        }
        return this.ConicProjection(lt, lg, Xs[layoutZone], Ys[layoutZone], c[layoutZone], n[layoutZone]);
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        LatLon geo = layoutZone == -1 ? this.Geographic(p, Xs[currentZone], Ys[currentZone], c[currentZone], n[currentZone]) : this.Geographic(p, Xs[layoutZone], Ys[layoutZone], c[layoutZone], n[layoutZone]);
        LatLon wgs = this.Clark2GRS80(geo);
        return new LatLon(Math.toDegrees(wgs.lat()), Math.toDegrees(wgs.lon()));
    }

    public String toString() {
        return I18n.tr("Lambert 4 Zones (France)");
    }

    public String toCode() {
        return "EPSG:" + (27561 + currentZone);
    }

    public String getCacheDirectoryName() {
        return "lambert";
    }

    private EastNorth ConicProjection(double lat, double lon, double Xs, double Ys, double c, double n) {
        double eslt = Ellipsoid.clarke.e * Math.sin(lat);
        double l = Math.log(Math.tan(0.7853981633974483 + lat / 2.0) * Math.pow((1.0 - eslt) / (1.0 + eslt), Ellipsoid.clarke.e / 2.0));
        double east = Xs + c * Math.exp(-n * l) * Math.sin(n * (lon - 0.04079234433198));
        double north = Ys - c * Math.exp(-n * l) * Math.cos(n * (lon - 0.04079234433198));
        return new EastNorth(east, north);
    }

    private LatLon Geographic(EastNorth eastNorth, double Xs, double Ys, double c, double n) {
        double dx = eastNorth.east() - Xs;
        double dy = Ys - eastNorth.north();
        double R = Math.sqrt(dx * dx + dy * dy);
        double gamma = Math.atan(dx / dy);
        double l = -1.0 / n * Math.log(Math.abs(R / c));
        l = Math.exp(l);
        double lon = 0.04079234433198 + gamma / n;
        double lat = 2.0 * Math.atan(l) - 1.5707963267948966;
        double delta = 1.0;
        while (delta > 1.0E-11) {
            double eslt = Ellipsoid.clarke.e * Math.sin(lat);
            double nlt = 2.0 * Math.atan(Math.pow((1.0 + eslt) / (1.0 - eslt), Ellipsoid.clarke.e / 2.0) * l) - 1.5707963267948966;
            delta = Math.abs(nlt - lat);
            lat = nlt;
        }
        return new LatLon(lat, lon);
    }

    private LatLon GRS802Clark(LatLon wgs) {
        double lat = Math.toRadians(wgs.lat());
        double lon = Math.toRadians(wgs.lon());
        double N = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(lat) * Math.sin(lat));
        double X = N * Math.cos(lat) * Math.cos(lon);
        double Y = N * Math.cos(lat) * Math.sin(lon);
        double Z = N * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(lat);
        return this.Geographic(X += 168.0, Y += 60.0, Z += -320.0, Ellipsoid.clarke);
    }

    private LatLon Clark2GRS80(LatLon lambert) {
        double lat = lambert.lat();
        double lon = lambert.lon();
        double N = Ellipsoid.clarke.a / Math.sqrt(1.0 - Ellipsoid.clarke.e2 * Math.sin(lat) * Math.sin(lat));
        double X = N * Math.cos(lat) * Math.cos(lon);
        double Y = N * Math.cos(lat) * Math.sin(lon);
        double Z = N * (1.0 - Ellipsoid.clarke.e2) * Math.sin(lat);
        return this.Geographic(X += -168.0, Y += -60.0, Z += 320.0, Ellipsoid.GRS80);
    }

    private LatLon Geographic(double X, double Y, double Z, Ellipsoid ell) {
        double s2;
        double norm = Math.sqrt(X * X + Y * Y);
        double lg = 2.0 * Math.atan(Y / (X + norm));
        double lt = Math.atan(Z / (norm * (1.0 - ell.a * ell.e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double delta = 1.0;
        while (delta > 1.0E-11) {
            s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(Z / norm / (1.0 - ell.a * ell.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - ell.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        s2 = Math.sin(lt);
        s2 *= s2;
        return new LatLon(lt, lg);
    }

    private boolean farawayFromLambertZoneFrance(double lat, double lon) {
        return lat < zoneLimits[3] - cMaxOverlappingZones || lat > cMaxLatZone1 + cMaxOverlappingZones || lon < cMinLonZones - cMaxOverlappingZones || lon > cMaxLonZones + cMaxOverlappingZones;
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-85.05112877980659, -180.0), new LatLon(85.05112877980659, 180.0));
    }

    public double getDefaultZoomInPPD() {
        return 0.0;
    }
}

