/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class LambertCC9Zones
implements Projection {
    public static final double[] n = new double[]{0.6691500006885269, 0.682018118346418, 0.6946784863203991, 0.7071272481559119, 0.7193606118567315, 0.7313748510399917, 0.7431663060711892, 0.7547313851789208, 0.7660665655489937};
    public static final double[] c = new double[]{1.215363305807804E7, 1.2050261119223533E7, 1.195716926884592E7, 1.18737533925172E7, 1.1799460698022118E7, 1.17337838820243E7, 1.16762559948139E7, 1.1626445901183508E7, 1.1583954251630554E7};
    public static final double Xs = 1700000.0;
    public static final double[] Ys = new double[]{8293467.503439436, 9049604.665107645, 9814691.693461388, 1.0588107871787189E7, 1.1369285637569271E7, 1.2157704903382052E7, 1.2952888086405803E7, 1.3754395745267643E7, 1.4561822739114787E7};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-12;
    public static final double cMaxLatZones = Math.toRadians(51.1);
    public static final double cMinLatZones = Math.toRadians(41.0);
    public static final double cMinLonZones = Math.toRadians(-5.0);
    public static final double cMaxLonZones = Math.toRadians(10.2);
    public static final double lambda0 = Math.toRadians(3.0);
    public static final double e = Ellipsoid.GRS80.e;
    public static final double e2 = Ellipsoid.GRS80.e2;
    public static final double a = Ellipsoid.GRS80.a;
    public static final double cMaxOverlappingZones = Math.toRadians(1.5);
    public static int layoutZone = -1;

    private double L(double phi, double e) {
        double sinphi = Math.sin(phi);
        return 0.5 * Math.log((1.0 + sinphi) / (1.0 - sinphi)) - e / 2.0 * Math.log((1.0 + e * sinphi) / (1.0 - e * sinphi));
    }

    public EastNorth latlon2eastNorth(LatLon p) {
        double lt = Math.toRadians(p.lat());
        double lg = Math.toRadians(p.lon());
        int possibleZone = 0;
        boolean outOfLambertZones = false;
        if (lt >= cMinLatZones && lt <= cMaxLatZones && lg >= cMinLonZones && lg <= cMaxLonZones) {
            possibleZone = (int)p.lat() - 42;
            if (possibleZone > 8) {
                possibleZone = 8;
            }
            if (possibleZone < 0) {
                possibleZone = 0;
            }
        } else {
            outOfLambertZones = true;
        }
        if (!outOfLambertZones) {
            if (layoutZone == -1) {
                if (layoutZone != possibleZone) {
                    System.out.println("change Lambert zone from " + layoutZone + " to " + possibleZone);
                }
                layoutZone = possibleZone;
            } else if (Math.abs(layoutZone - possibleZone) > 1) {
                if (this.farawayFromLambertZoneFrance(lt, lg)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("IMPORTANT : data positioned far away from\nthe current Lambert zone limits.\nDo not upload any data after this message.\nUndo your last action, save your work\nand start a new layer on the new zone."), I18n.tr("Warning"), 2);
                    layoutZone = -1;
                } else {
                    System.out.println("temporarily extend Lambert zone " + layoutZone + " projection at lat,lon:" + lt + "," + lg);
                }
            }
        }
        if (layoutZone == -1) {
            return this.ConicProjection(lt, lg, possibleZone);
        }
        return this.ConicProjection(lt, lg, layoutZone);
    }

    private EastNorth ConicProjection(double lat, double lon, int nz) {
        double R = c[nz] * Math.exp(-n[nz] * this.L(lat, e));
        double gamma = n[nz] * (lon - lambda0);
        double X = 1700000.0 + R * Math.sin(gamma);
        double Y = Ys[nz] + -R * Math.cos(gamma);
        return new EastNorth(X, Y);
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        layoutZone = LambertCC9Zones.north2ZoneNumber(p.north());
        return this.Geographic(p, layoutZone);
    }

    private LatLon Geographic(EastNorth ea, int nz) {
        double R = Math.sqrt(Math.pow(ea.getX() - 1700000.0, 2.0) + Math.pow(ea.getY() - Ys[nz], 2.0));
        double gamma = Math.atan((ea.getX() - 1700000.0) / (Ys[nz] - ea.getY()));
        double lon = lambda0 + gamma / n[nz];
        double latIso = -1.0 / n[nz] * Math.log(Math.abs(R / c[nz]));
        double lat = Ellipsoid.GRS80.latitude(latIso, e, 1.0E-12);
        return new LatLon(Math.toDegrees(lat), Math.toDegrees(lon));
    }

    public String toString() {
        return I18n.tr("Lambert CC9 Zone (France)");
    }

    public static int north2ZoneNumber(double north) {
        int nz = (int)(north / 1000000.0) - 1;
        if (nz < 0) {
            return 0;
        }
        if (nz > 8) {
            return 8;
        }
        return nz;
    }

    public static boolean isInL9CCZones(LatLon p) {
        double lt = Math.toRadians(p.lat());
        double lg = Math.toRadians(p.lon());
        return lg >= cMinLonZones && lg <= cMaxLonZones && lt >= cMinLatZones && lt <= cMaxLatZones;
    }

    public String toCode() {
        if (layoutZone == -1) {
            return "EPSG:3942";
        }
        return "EPSG:" + (3942 + layoutZone);
    }

    public String getCacheDirectoryName() {
        return "lambert";
    }

    private boolean farawayFromLambertZoneFrance(double lat, double lon) {
        return lat < cMinLatZones - cMaxOverlappingZones || lat > cMaxLatZones + cMaxOverlappingZones || lon < cMinLonZones - cMaxOverlappingZones || lon > cMaxLonZones + cMaxOverlappingZones;
    }

    public double getDefaultZoomInPPD() {
        return 0.0;
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-85.05112877980659, -180.0), new LatLon(85.05112877980659, 180.0));
    }
}

