/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;

public class UTM_20N_France_DOM {
    private static final double Xs = 500000.0;
    private static double Ys = 0.0;
    protected double lg0;
    int zone = 20;
    private boolean isNorth = true;
    double tx = 0.0;
    double ty = 0.0;
    double tz = 0.0;
    double rx = 0.0;
    double ry = 0.0;
    double rz = 0.0;
    double scaleDiff = 0.0;
    public static final double epsilon = 1.0E-11;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;

    public UTM_20N_France_DOM(double[] translation, double[] rotation, double scaleDiff) {
        this.tx = translation[0];
        this.ty = translation[1];
        this.tz = translation[2];
        this.rx = rotation[0] / 206264.80624709636;
        this.ry = rotation[1] / 206264.80624709636;
        this.rz = rotation[2] / 206264.80624709636;
        this.scaleDiff = scaleDiff;
    }

    public EastNorth latlon2eastNorth(LatLon p) {
        LatLon geo = this.GRS802Hayford(p);
        return this.MTProjection(geo, Ellipsoid.hayford.a, Ellipsoid.hayford.e);
    }

    private LatLon GRS802Hayford(LatLon wgs) {
        double lat = Math.toRadians(wgs.lat());
        double lon = Math.toRadians(wgs.lon());
        double N = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(lat) * Math.sin(lat));
        double X = N * Math.cos(lat) * Math.cos(lon);
        double Y = N * Math.cos(lat) * Math.sin(lon);
        double Z = N * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(lat);
        double[] coord = this.invSevenParametersTransformation(X, Y, Z);
        return this.Geographic(coord[0], coord[1], coord[2], Ellipsoid.hayford);
    }

    private LatLon Geographic(double X, double Y, double Z, Ellipsoid ell) {
        double s2;
        double norm = Math.sqrt(X * X + Y * Y);
        double lg = 2.0 * Math.atan(Y / (X + norm));
        double lt = Math.atan(Z / (norm * (1.0 - ell.a * ell.e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double delta = 1.0;
        while (delta > 1.0E-11) {
            s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(Z / norm / (1.0 - ell.a * ell.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - ell.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        s2 = Math.sin(lt);
        s2 *= s2;
        return new LatLon(lt, lg);
    }

    private EastNorth MTProjection(LatLon coord, double a, double e) {
        double n = 0.9996 * a;
        Ys = coord.lat() >= 0.0 ? 0.0 : 1.0E7;
        double r6d = 0.10471975511965977;
        this.lg0 = r6d * ((double)this.zone - 0.5) - Math.PI;
        double e2 = e * e;
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] C = new double[]{1.0 - e2 / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0 - 175.0 * e8 / 16384.0, e2 / 8.0 - e4 / 96.0 - 9.0 * e6 / 1024.0 - 901.0 * e8 / 184320.0, 13.0 * e4 / 768.0 + 17.0 * e6 / 5120.0 - 311.0 * e8 / 737280.0, 61.0 * e6 / 15360.0 + 899.0 * e8 / 430080.0, 49561.0 * e8 / 4.128768E7};
        double s = e * Math.sin(coord.lat());
        double l = Math.log(Math.tan(0.7853981633974483 + coord.lat() / 2.0) * Math.pow((1.0 - s) / (1.0 + s), e / 2.0));
        double phi = Math.asin(Math.sin(coord.lon() - this.lg0) / ((Math.exp(l) + Math.exp(-l)) / 2.0));
        double ls = Math.log(Math.tan(0.7853981633974483 + phi / 2.0));
        double lambda = Math.atan((Math.exp(l) - Math.exp(-l)) / 2.0 / Math.cos(coord.lon() - this.lg0));
        double north = C[0] * lambda;
        double east = C[0] * ls;
        for (int k = 1; k < 5; ++k) {
            double r = 2.0 * (double)k * lambda;
            double m = 2.0 * (double)k * ls;
            double em = Math.exp(m);
            double en = Math.exp(-m);
            double sr = Math.sin(r) / 2.0 * (em + en);
            double sm = Math.cos(r) / 2.0 * (em - en);
            north += C[k] * sr;
            east += C[k] * sm;
        }
        east *= n;
        north *= n;
        return new EastNorth(east += 500000.0, north += Ys);
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        this.MTProjection(p.east(), p.north(), this.zone, this.isNorth);
        LatLon geo = this.Geographic(p, Ellipsoid.hayford.a, Ellipsoid.hayford.e, 0.0);
        double N = Ellipsoid.hayford.a / Math.sqrt(1.0 - Ellipsoid.hayford.e2 * Math.sin(geo.lat()) * Math.sin(geo.lat()));
        double X = N * Math.cos(geo.lat()) * Math.cos(geo.lon());
        double Y = N * Math.cos(geo.lat()) * Math.sin(geo.lon());
        double Z = N * (1.0 - Ellipsoid.hayford.e2) * Math.sin(geo.lat());
        double[] coord = this.sevenParametersTransformation(X, Y, Z);
        LatLon wgs = this.cart2LatLon(coord[0], coord[1], coord[2], Ellipsoid.GRS80);
        return new LatLon(Math.toDegrees(wgs.lat()), Math.toDegrees(wgs.lon()));
    }

    private void MTProjection(double east, double north, int zone, boolean isNorth) {
        Ys = isNorth ? 0.0 : 1.0E7;
        double r6d = 0.10471975511965977;
        this.lg0 = r6d * ((double)zone - 0.5) - Math.PI;
    }

    public double scaleFactor() {
        return 0.15915494309189535;
    }

    private LatLon Geographic(EastNorth coord, double a, double e, double z) {
        double lt0;
        double s;
        double n = 0.9996 * a;
        double e2 = e * e;
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] C = new double[]{1.0 - e2 / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0 - 175.0 * e8 / 16384.0, e2 / 8.0 + e4 / 48.0 + 7.0 * e6 / 2048.0 + e8 / 61440.0, e4 / 768.0 + 3.0 * e6 / 1280.0 + 559.0 * e8 / 368640.0, 17.0 * e6 / 30720.0 + 283.0 * e8 / 430080.0, 4397.0 * e8 / 4.128768E7};
        double l = (coord.north() - Ys) / (n * C[0]);
        double ls = (coord.east() - 500000.0) / (n * C[0]);
        double l0 = l;
        double ls0 = ls;
        for (int k = 1; k < 5; ++k) {
            double r = 2.0 * (double)k * l0;
            double m = 2.0 * (double)k * ls0;
            double em = Math.exp(m);
            double en = Math.exp(-m);
            double sr = Math.sin(r) / 2.0 * (em + en);
            double sm = Math.cos(r) / 2.0 * (em - en);
            l -= C[k] * sr;
            ls -= C[k] * sm;
        }
        double lon = this.lg0 + Math.atan((Math.exp(ls) - Math.exp(-ls)) / 2.0 / Math.cos(l));
        double phi = Math.asin(Math.sin(l) / ((Math.exp(ls) + Math.exp(-ls)) / 2.0));
        l = Math.log(Math.tan(0.7853981633974483 + phi / 2.0));
        double lat = 2.0 * Math.atan(Math.exp(l)) - 1.5707963267948966;
        do {
            lt0 = lat;
        } while (Math.abs((lat = 2.0 * Math.atan(Math.pow((1.0 + (s = e * Math.sin(lat))) / (1.0 - s), e / 2.0) * Math.exp(l)) - 1.5707963267948966) - lt0) >= 1.0E-11);
        return new LatLon(lat, lon);
    }

    private LatLon cart2LatLon(double X, double Y, double Z, Ellipsoid ell) {
        double s2;
        double norm = Math.sqrt(X * X + Y * Y);
        double lg = 2.0 * Math.atan(Y / (X + norm));
        double lt = Math.atan(Z / (norm * (1.0 - ell.a * ell.e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double delta = 1.0;
        while (delta > 1.0E-11) {
            s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(Z / norm / (1.0 - ell.a * ell.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - ell.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        s2 = Math.sin(lt);
        s2 *= s2;
        return new LatLon(lt, lg);
    }

    private double[] sevenParametersTransformation(double Xa, double Ya, double Za) {
        double Xb = this.tx + Xa * (1.0 + this.scaleDiff) + Za * this.ry - Ya * this.rz;
        double Yb = this.ty + Ya * (1.0 + this.scaleDiff) + Xa * this.rz - Za * this.rx;
        double Zb = this.tz + Za * (1.0 + this.scaleDiff) + Ya * this.rx - Xa * this.ry;
        return new double[]{Xb, Yb, Zb};
    }

    private double[] invSevenParametersTransformation(double Xa, double Ya, double Za) {
        double Xb = (1.0 - this.scaleDiff) * (-this.tx + Xa + ((-this.tz + Za) * -this.ry - (-this.ty + Ya) * -this.rz));
        double Yb = (1.0 - this.scaleDiff) * (-this.ty + Ya + ((-this.tx + Xa) * -this.rz - (-this.tz + Za) * -this.rx));
        double Zb = (1.0 - this.scaleDiff) * (-this.tz + Za + ((-this.ty + Ya) * -this.rx - (-this.tx + Xa) * -this.ry));
        return new double[]{Xb, Yb, Zb};
    }
}

