/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.I18n;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
    }

    public void load() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.removeAllElements();
        try {
            for (Preferences.Bookmark b : Main.pref.loadBookmarks()) {
                model.addElement(b);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", Main.pref.getBookmarksFile(), e.getMessage()), I18n.tr("Error"), 0);
        }
    }

    public void save() {
        try {
            LinkedList<Preferences.Bookmark> bookmarks = new LinkedList<Preferences.Bookmark>();
            for (Object o : ((DefaultListModel)this.getModel()).toArray()) {
                bookmarks.add((Preferences.Bookmark)o);
            }
            Main.pref.saveBookmarks(bookmarks);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not write bookmark.<br>{0}</html>", e.getMessage()), I18n.tr("Error"), 0);
        }
    }
}

