/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.Shortcut;

public class MapMover
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    private EastNorth mousePosMove;
    private final NavigatableComponent nc;
    private Cursor oldCursor;
    private boolean movementInPlace = false;

    public MapMover(NavigatableComponent navComp, JPanel contentPane) {
        this.nc = navComp;
        this.nc.addMouseListener(this);
        this.nc.addMouseMotionListener(this);
        this.nc.addMouseWheelListener(this);
        if (contentPane != null) {
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusright", I18n.tr("Map: {0}", I18n.tr("Move right")), 39, 1).getKeyStroke(), "MapMover.Zoomer.right");
            contentPane.getActionMap().put("MapMover.Zoomer.right", new ZoomerAction("right"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusleft", I18n.tr("Map: {0}", I18n.tr("Move left")), 37, 1).getKeyStroke(), "MapMover.Zoomer.left");
            contentPane.getActionMap().put("MapMover.Zoomer.left", new ZoomerAction("left"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusup", I18n.tr("Map: {0}", I18n.tr("Move up")), 38, 1).getKeyStroke(), "MapMover.Zoomer.up");
            contentPane.getActionMap().put("MapMover.Zoomer.up", new ZoomerAction("up"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusdown", I18n.tr("Map: {0}", I18n.tr("Move down")), 40, 1).getKeyStroke(), "MapMover.Zoomer.down");
            contentPane.getActionMap().put("MapMover.Zoomer.down", new ZoomerAction("down"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("view:zoominalternate", I18n.tr("Map: {0}", I18n.tr("Zoom in")), 44, 1).getKeyStroke(), "MapMover.Zoomer.in");
            contentPane.getActionMap().put("MapMover.Zoomer.in", new ZoomerAction(","));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("view:zoomoutalternate", I18n.tr("Map: {0}", I18n.tr("Zoom out")), 46, 1).getKeyStroke(), "MapMover.Zoomer.out");
            contentPane.getActionMap().put("MapMover.Zoomer.out", new ZoomerAction("."));
        }
    }

    public void mouseDragged(MouseEvent e) {
        int offMask = 3072;
        if ((e.getModifiersEx() & (0x1000 | offMask)) == 4096) {
            if (this.mousePosMove == null) {
                this.startMovement(e);
            }
            EastNorth center = this.nc.getCenter();
            EastNorth mouseCenter = this.nc.getEastNorth(e.getX(), e.getY());
            this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + center.east() - mouseCenter.east(), this.mousePosMove.north() + center.north() - mouseCenter.north()));
        } else {
            this.endMovement();
        }
    }

    public void mousePressed(MouseEvent e) {
        int offMask = 3072;
        int macMouseMask = 1152;
        if (e.getButton() == 3 && (e.getModifiersEx() & offMask) == 0) {
            this.startMovement(e);
        } else if (MapMover.isPlatformOsx() && e.getModifiersEx() == macMouseMask) {
            this.startMovement(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            this.endMovement();
        } else if (MapMover.isPlatformOsx() && e.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent e) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = this.nc.getEastNorth(e.getX(), e.getY());
        this.oldCursor = this.nc.getCursor();
        this.nc.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        if (this.oldCursor != null) {
            this.nc.setCursor(this.oldCursor);
        } else {
            this.nc.setCursor(Cursor.getDefaultCursor());
        }
        this.mousePosMove = null;
        this.oldCursor = null;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.nc.zoomToFactor(e.getX(), e.getY(), Math.pow(0.8, -e.getWheelRotation()));
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.movementInPlace) {
            return;
        }
        if (MapMover.isPlatformOsx()) {
            if (e.getModifiersEx() == 128) {
                if (this.mousePosMove == null) {
                    this.startMovement(e);
                }
                EastNorth center = this.nc.getCenter();
                EastNorth mouseCenter = this.nc.getEastNorth(e.getX(), e.getY());
                this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + center.east() - mouseCenter.east(), this.mousePosMove.north() + center.north() - mouseCenter.north()));
            } else {
                this.endMovement();
            }
        }
    }

    public static boolean isPlatformOsx() {
        return Main.platform != null && Main.platform instanceof PlatformHookOsx;
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        public ZoomerAction(String action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.action.equals(".") || this.action.equals(",")) {
                Point mouse = MapMover.this.nc.getMousePosition();
                if (mouse == null) {
                    mouse = new Point((int)MapMover.this.nc.getBounds().getCenterX(), (int)MapMover.this.nc.getBounds().getCenterY());
                }
                MouseWheelEvent we = new MouseWheelEvent((Component)MapMover.this.nc, e.getID(), e.getWhen(), e.getModifiers(), mouse.x, mouse.y, 0, false, 0, 1, this.action.equals(",") ? -1 : 1);
                MapMover.this.mouseWheelMoved(we);
            } else {
                EastNorth center = MapMover.this.nc.getCenter();
                EastNorth newcenter = MapMover.this.nc.getEastNorth(MapMover.this.nc.getWidth() / 2 + MapMover.this.nc.getWidth() / 5, MapMover.this.nc.getHeight() / 2 + MapMover.this.nc.getHeight() / 5);
                if (this.action.equals("left")) {
                    MapMover.this.nc.zoomTo(new EastNorth(2.0 * center.east() - newcenter.east(), center.north()));
                } else if (this.action.equals("right")) {
                    MapMover.this.nc.zoomTo(new EastNorth(newcenter.east(), center.north()));
                } else if (this.action.equals("up")) {
                    MapMover.this.nc.zoomTo(new EastNorth(center.east(), 2.0 * center.north() - newcenter.north()));
                } else if (this.action.equals("down")) {
                    MapMover.this.nc.zoomTo(new EastNorth(center.east(), newcenter.north()));
                }
            }
        }
    }
}

