/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.I18n;

public class MapScaler
extends JComponent
implements Helpful {
    private final NavigatableComponent mv;

    public MapScaler(NavigatableComponent mv) {
        this.mv = mv;
        this.setSize(100, 30);
        this.setOpaque(false);
    }

    public void paint(Graphics g) {
        String text = this.mv.getDist100PixelText();
        Rectangle2D bound = g.getFontMetrics().getStringBounds(text, g);
        g.setColor(MapScaler.getColor());
        g.drawLine(0, 5, 99, 5);
        g.drawLine(0, 0, 0, 10);
        g.drawLine(99, 0, 99, 10);
        g.drawLine(49, 0, 49, 10);
        g.drawLine(24, 3, 24, 7);
        g.drawLine(74, 3, 74, 7);
        g.drawString(text, (int)(100.0 - bound.getWidth()), 23);
        g.drawString("0", 0, 23);
    }

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("scale"), Color.white);
    }

    public String helpTopic() {
        return "MapView/Scaler";
    }
}

