/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SplashScreen
extends JWindow {
    private JLabel status;
    private boolean visible;
    private Runnable closerRunner;
    private AWTEventListener awtListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent event) {
            if (event.getSource() != SplashScreen.this) {
                SplashScreen.this.closeSplash();
            }
        }
    };

    public SplashScreen(boolean visible) {
        this.visible = visible;
        if (!visible) {
            return;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        EtchedBorder margin = new EtchedBorder(1, Color.white, Color.gray);
        contentPane.setBorder(margin);
        JPanel innerContentPane = new JPanel();
        innerContentPane.setBorder(new EmptyBorder(10, 10, 2, 10));
        contentPane.add(innerContentPane);
        innerContentPane.setLayout(new GridBagLayout());
        JLabel logo = new JLabel(ImageProvider.get("logo.png"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 2;
        innerContentPane.add((Component)logo, gbc);
        JLabel caption = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        caption.setFont(new Font("Helvetica", 1, 20));
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.insets = new Insets(30, 0, 0, 0);
        innerContentPane.add((Component)caption, gbc);
        JLabel version = new JLabel(I18n.tr("Version {0}", AboutAction.getVersionString()));
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        innerContentPane.add((Component)version, gbc);
        JSeparator separator = new JSeparator(0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 0, 5, 0);
        innerContentPane.add((Component)separator, gbc);
        this.status = new JLabel();
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        innerContentPane.add((Component)this.status, gbc);
        this.setStatus(I18n.tr("Initializing"));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = contentPane.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.closerRunner = new Runnable(){

            public void run() {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                try {
                    SplashScreen.this.closerRunner.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 64L);
        this.setVisible(true);
    }

    public void setStatus(String message) {
        if (!this.visible) {
            return;
        }
        this.status.setText(message + "...");
    }

    public void closeSplash() {
        if (!this.visible) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        try {
            SwingUtilities.invokeLater(this.closerRunner);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

